<!doctype html>
<html lang="en" >
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!-- Bootstrap CSS -->
        <?php if($locale == 'en'): ?>
            <link rel="stylesheet" href="<?php echo e(asset('assets/theme/css/bootstrap.min_latist_version.css')); ?>">
            <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/default.css')); ?>">

        <?php else: ?>
            <link rel="stylesheet" href="<?php echo e(asset('assets/theme/css/bootstrap.rtl.min_latist_version.css')); ?>">
            <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/css/default_rtl.css')); ?>">
        <?php endif; ?>

        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.6.1/font/bootstrap-icons.css">
        <!-- online google font s
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Oswald&display=swap" rel="stylesheet">
        slider -->
        <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/slider/css/lightslider.css')); ?>">

        <title><?php echo e(($site_info->site_title)); ?></title>

        <link rel="icon" href="<?php echo e(asset('images/logo/'.$site_info->favicon)); ?>" type="image/x-icon">

    </head>
<body>
<!-- navbar start -->
<?php if($settings['topbar']['hide']): ?>
<nav class="navbar navbar-expand-lg text-center fixed-top" id="nav_togller" style="background:<?php echo e($settings['topbar']['colors']['background_color']); ?>;">
    <div class="container-fluid">

        <a class="navbar-brand" href="#">
            <img src="<?php echo e(asset($settings['topbar']['photo'])); ?>" class="img-fluid" width="40px" alt="logo">
        </a>
        <div class="">
        <form class="d-flex d-md-none" method="POST" action="<?php echo e(route('logout')); ?>">
            <?php echo csrf_field(); ?>
            <?php if($locale == 'en'): ?>
                <a style="text-decoration: none; " href="<?php echo e(url('localeA/ar')); ?>" class="text-white fs-6 px-1"> <img src="<?php echo e(asset('project/frontend/default/flag_arabic.png')); ?>" class="img-fluid" alt=""> <?php echo e(trans('default.arabic')); ?></a>
            <?php else: ?>
                <a style="text-decoration: none; " href="<?php echo e(url('localeA/en')); ?>" class="text-white fs-6 px-1"> <img src="<?php echo e(asset('project/frontend/default/flag_en.png')); ?>" class="img-fluid" alt="">  <?php echo e(trans('default.english')); ?></a>
            <?php endif; ?>
            <?php if(Auth::check() && !empty(Auth::user())): ?>
                <a style="text-decoration: none; " href="<?php echo e(url('/home')); ?>" class="text-white fs-6 px-1"><?php echo e((!empty(Auth::user()->name)) ? Auth::user()->name : trans('project.dashboard')); ?></a>
                <a class="text-white fs-6 px-1" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); this.closest('form').submit();" style="text-decoration: none;">
                    Logout
                    </a>
            <?php else: ?>
                <a href="<?php echo e(url('/login')); ?>" class="text-white fs-6 px-3"><?php echo e(trans('default.login')); ?></a>
            <?php endif; ?>
        </form>
    </div>
        <button class="navbar-toggler text-black me-3" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"><p class="text-black fs-2"><i class="bi bi-list"></i></p></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <ul class="navbar-nav me-auto mb-2 mb-lg-0 px-5">
                <li class="nav-item">
                    <a class="nav-link active" aria-current="page" href="/"><?php echo e(trans('default.home')); ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link px-3" href="/#about"><?php echo e(trans('default.about')); ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link px-3" href="/#feature"><?php echo e(trans('default.features')); ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link px-3" href="/#download"><?php echo e(trans('default.download')); ?></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link px-3" href="/#contact"><?php echo e(trans('default.contact')); ?></a>
                </li>
            </ul>

        </div>

        <div class="div d-md-flex d-none">
            <form class="d-flex  justify-content-end forms" method="POST" action="<?php echo e(route('logout')); ?>">
                <?php echo csrf_field(); ?>
               <!--        <?php if($locale == 'en'): ?>
         <a href="<?php echo e(url('localeA/ar')); ?>" class="bar_link"> <img src="<?php echo e(asset('project/frontend/default/flag_arabic.png')); ?>" class="img-fluid px-2" alt=""> <?php echo e(trans('default.arabic')); ?></a>
            <?php else: ?>
                <a style="text-decoration: none; " href="<?php echo e(url('localeA/en')); ?>" class="bar_link"> <img src="<?php echo e(asset('project/frontend/default/flag_en.png')); ?>" class="img-fluid px-2" alt="">  <?php echo e(trans('default.english')); ?></a>
            <?php endif; ?> -->
            <?php if(Auth::check() && !empty(Auth::user())): ?>
                <a href="<?php echo e(url('/home')); ?>" class="bar_link"><?php echo e((!empty(Auth::user()->name)) ? Auth::user()->name : trans('project.dashboard')); ?></a>

              <a class="bar_link" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); this.closest('form').submit();" style="text-decoration: none;">
                  Logout
                  </a>
            <?php else: ?>
                <a href="<?php echo e(url('/login')); ?>" class="bar_link"><?php echo e(trans('default.login')); ?></a>
            <?php endif; ?>
          </form>
          </div>
    </div>
</nav>
<?php endif; ?>
<!-- end navbar -->
<?php /**PATH /home/vagrant/code/manage_sarfapp/resources/views//frontend/default/header.blade.php ENDPATH**/ ?>