<?php
use App\Http\Controllers\AppController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Project\HomeController;
use App\Http\Controllers\Project\UserController;
use App\Http\Controllers\Project\SubsController;
use App\Http\Controllers\Project\ExpenseTypeController;
use App\Http\Controllers\Project\ColorController;
use App\Http\Controllers\Project\PackageController;
use App\Http\Controllers\Project\QrController;
use App\Http\Controllers\Project\CategoryController;
use App\Http\Controllers\Project\ProductController;
use App\Http\Controllers\Project\ImportExcelController;
use App\Http\Controllers\Project\CommonController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/generate_qr/{id}', [QrController::class, 'generate_qr']);
Route::get('/generate_qr_andriod/{id}', [QrController::class, 'generate_qr_andriod']);
Route::get('/login', function () {
    return view('auth.login');
});

Route::get('localeA/{locale?}', [AppController::class, 'setLocaleA']);
Auth::routes();

Route::get('/invoice_detail_pdf/{invoice_id}/{lang}', [CommonController::class, 'invoiceDetailPDF']);

Route::group(['middleware' => ['auth']], function () {
Route::get('/home', [HomeController::class, 'index'])->name('home');

// Project work
/*category*/
Route::get('/manage_category', [CategoryController::class, "index"])->name('manage_category');
Route::prefix("/manage_category")->group(function(){
    Route::get("/add", [CategoryController::class, "add"]);
    Route::post("/save", [CategoryController::class, "save"]);
    Route::get("/edit/{id}", [CategoryController::class, "edit"]);
    Route::post("/update", [CategoryController::class, "update"]);
    Route::post("/status", [CategoryController::class, "status"]);
    Route::post("/destroy", [CategoryController::class, "destroy"]);
});
/*category end*/

/*products*/
Route::get('/manage_product', [ProductController::class, "index"])->name('manage_product');
Route::prefix("/manage_product")->group(function(){
    Route::get("/add", [ProductController::class, "add"]);
    Route::post("/save", [ProductController::class, "save"]);
    Route::get("/edit/{id}", [ProductController::class, "edit"]);
    Route::post("/update", [ProductController::class, "update"]);
    Route::post("/status", [ProductController::class, "status"]);
    Route::post("/destroy", [ProductController::class, "destroy"]);
    // imports data from excel
    Route::post('/import', [ProductController::class, "import"]);
});
/*products end*/
Route::get('/template/download/{file}', function ($file) {
    $file_path = public_path('import_template/'.$file);
    if (file_exists($file_path)) {
        return response()->download($file_path, $file, [
            'Content-Type' => 'application/vnd.ms-excel',
            'Content-Disposition' => 'inline; filename="'.$file.'"'
        ]);
    }
    abort(404);
});

Route::prefix("/pos")->group(function(){
    Route::post("/generate_invoice", [HomeController::class, "generate_invoice"])->name('generate_invoice');
    Route::get("/invoice_member_add/{id}", [HomeController::class, "invoice_member_add"]);
    Route::post("/invoice_product_add", [HomeController::class, "invoice_product_add"])->name('invoice_product_add');
    Route::post("/extraDiscount", [HomeController::class, "extraDiscount"]);
    Route::get("/item_destroy/{id}/{inv_id}", [HomeController::class, "item_destroy"]);
    Route::get("/member_destroy", [HomeController::class, "member_destroy"]);
    Route::post("/edit_item_form", [HomeController::class, "edit_item_form"]);
    Route::post("/invoice_product_update", [HomeController::class, "invoice_product_update"]);
});
Route::get("/simple_invoice", [HomeController::class, "simple_invoice"]);
Route::post("/generate_simple_invoice", [HomeController::class, "generate_simple_invoice"])->name('generate_simple_invoice');
// Project work end

/*package*/
Route::get('/packages_list', [PackageController::class, "index"])->name('packages_list');
Route::prefix("/packages_list")->group(function(){
    Route::post("/add", [PackageController::class, "add"]);
    Route::post("/save", [PackageController::class, "save"]);
    Route::post("/edit", [PackageController::class, "edit"]);
    Route::post("/update", [PackageController::class, "update"]);
    Route::post("/status", [PackageController::class, "status"]);
    Route::post("/destroy", [PackageController::class, "destroy"]);
});
/*package end*/

/*subscription*/
Route::get('/Subscription_list', [SubsController::class, "index"])->name('Subscription_list');
Route::prefix("/Subscription_list")->group(function(){
    Route::post("/add", [SubsController::class, "add"]);
    Route::post("/save", [SubsController::class, "save"]);
    Route::post("/edit", [SubsController::class, "edit"]);
    Route::post("/update", [SubsController::class, "update"]);
    Route::post("/status", [SubsController::class, "status"]);
    Route::post("/destroy", [SubsController::class, "destroy"]);
});
/*subscription end*/

/*subscription*/
Route::get('/exp_type', [ExpenseTypeController::class, "index"])->name('exp_type');
Route::prefix("/exp_type")->group(function(){
    Route::post("/add", [ExpenseTypeController::class, "add"]);
    Route::post("/save", [ExpenseTypeController::class, "save"]);
    Route::post("/edit", [ExpenseTypeController::class, "edit"]);
    Route::post("/update", [ExpenseTypeController::class, "update"]);
    Route::post("/status", [ExpenseTypeController::class, "status"]);
    Route::post("/destroy", [ExpenseTypeController::class, "destroy"]);
});
/*subscription end*/

// user list
Route::get('/user_list', [UserController::class, 'index'])->name('users.index');
Route::prefix("/user_list")->group(function(){
    //Route::post("/addModel", [UserController::class, "addModel"]);
    //Route::post("/save", [UserController::class, "save"]);
    //Route::post("/editModel", [UserController::class, "editModel"]);
    //Route::post("/update", [UserController::class, "update"]);
    //Route::post("/destroy", [UserController::class, "destroy"]);
    Route::post("/status_change", [UserController::class, "status"]);
    Route::get("/user_detail/{id}", [UserController::class, "user_detail"]);
});
// user list end

// business list
Route::get('/business_list', [UserController::class, 'business_list'])->name('business_list');
Route::prefix("/business_list")->group(function(){
    //Route::post("/addModel", [UserController::class, "addModel"]);
    //Route::post("/save", [UserController::class, "save"]);
    //Route::post("/editModel", [UserController::class, "editModel"]);
    //Route::post("/update", [UserController::class, "update"]);
    //Route::post("/destroy", [UserController::class, "destroy"]);
    Route::post("/status_change", [UserController::class, "statusBusiness"]);
    Route::get("/vendor_detail/{id}", [UserController::class, "vendor_detail"]);
});
// business list endcolor_list

// color list
Route::get('/color_list', [ColorController::class, 'index'])->name('color_list');
Route::prefix("/color_list")->group(function(){
    Route::post("/add", [ColorController::class, "add"]);
    Route::post("/save", [ColorController::class, "save"]);
    Route::post("/edit", [ColorController::class, "edit"]);
    Route::post("/update", [ColorController::class, "update"]);
    Route::post("/status", [ColorController::class, "status"]);
    Route::post("/destroy", [ColorController::class, "destroy"]);
});



// color_list end
/*manage end*/
  
    });

