<?php
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AppController;
use App\Http\Controllers\api\RegisterController;
use App\Http\Controllers\api\LoginController;
use App\Http\Controllers\api\HomeController;
use App\Http\Controllers\api\UserProfileController;
use App\Http\Controllers\api\BudgetController;
use App\Http\Controllers\api\ExpenseController;
use App\Http\Controllers\api\PagesController;
use App\Http\Controllers\api\FrontController;
use App\Http\Controllers\api\SupportController;
use App\Http\Controllers\api\ExpenseVendorsController;
use App\Http\Controllers\api\SalaryController;
// vendor controllers
use App\Http\Controllers\api\HomeVendorController;

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
Route::middleware('auth:sanctum')->get('/athenticated', function () {
    return true;
});
Route::post('/change_language', [AppController::class, "change_language"]);
/*front site api end*/
// landing page
Route::get('/front', [FrontController::class, "index"]);
Route::prefix("/front")->group(function(){
    Route::post('/contact_msg', [FrontController::class, "contact_msg"]);
});
// landing page end

// Authentication
// user registraion
Route::post('/register2', [RegisterController::class, "register"]);

// business registraions
Route::post('/user_detail', [RegisterController::class, "user_detail"]);
Route::post('/vendor_detail', [RegisterController::class, "vendor_detail"]);

// username checking if already taken/Avialable
Route::post('/username_check', [RegisterController::class, "username_check"]);
Route::post('/mobile_check', [RegisterController::class, "mobile_check"]);
Route::post('/otp', [LoginController::class, "otp"]);
Route::post('/otp_verify', [RegisterController::class, "otp_verify"]);
Route::post('/resend_opt', [RegisterController::class, "resend_opt"]);
Route::get('/country_list', [RegisterController::class, "country_list"]);
Route::get('/city_list', [RegisterController::class, "city_list"]);
Route::post('/forgot_pass', [RegisterController::class, "forgot_pass"]);
Route::post('/change_pass_forgot', [RegisterController::class, "change_pass_forgot"]);

Route::post('/change_language', [RegisterController::class, "change_language"]);

//authentication
Route::post('/login', [LoginController::class, "login"]);
Route::post('/logout', [LoginController::class, "logout"]);
//authentication end
/*front site api end*/

/*Business penel api start*/
Route::post('/home_vendor', [HomeVendorController::class, "index"]);
Route::post('/budget_and_expances', [HomeVendorController::class, "budget_and_expances"]);
Route::post('/generate_invoice', [HomeVendorController::class, "generate_invoice"]);
Route::post('/members', [HomeVendorController::class, "members"]);
Route::post('/member_search', [HomeVendorController::class, "member_search"]);
Route::post('/products', [HomeVendorController::class, "products"]);
Route::post('/product_search', [HomeVendorController::class, "product_search"]);
Route::post('/member_offer', [HomeVendorController::class, "member_offer"]);
Route::post('/offer_add', [HomeVendorController::class, "offer_add"]);
Route::post('/business_profile', [HomeVendorController::class, "business_profile"]);
Route::post('/update_business_profile', [HomeVendorController::class, "update_business_profile"]);
Route::post('/manage_categories', [HomeVendorController::class, "manage_categories"]);
Route::post('/category_add', [HomeVendorController::class, "category_add"]);
Route::post('/category_update', [HomeVendorController::class, "category_update"]);
Route::post('/manage_products', [HomeVendorController::class, "manage_products"]);
Route::post('/product_add', [HomeVendorController::class, "product_add"]);
Route::post('/product_update', [HomeVendorController::class, "product_update"]);
Route::post('/manage_invoices', [HomeVendorController::class, "manage_invoices"]);
Route::post('/invoice_member', [HomeVendorController::class, "invoice_member"]);
Route::post('/invoice_product', [HomeVendorController::class, "invoice_product"]);
Route::post('/member_invoices', [HomeVendorController::class, "member_invoices"]);
Route::post('/invoice_members', [HomeVendorController::class, "invoice_members"]);
Route::post('/invoice_member_add', [HomeVendorController::class, "invoice_member_add"]);
Route::post('/invoice_member_barcode', [HomeVendorController::class, "invoice_member_barcode"]);

// simple invoice
Route::post('/simple_invoice_member_qrcode', [HomeVendorController::class, "simple_invoice_member_qrcode"]);
Route::post('/checking_member_qrcode', [HomeVendorController::class, "checking_member_qrcode"]);
Route::post('/checking_user_by_username', [HomeVendorController::class, "checking_user_by_username"]);

Route::post('/generate_simple_invoice', [HomeVendorController::class, "generate_simple_invoice"]);
Route::post('/generate_custom_invoice', [HomeController::class, "generate_custom_invoice"]);

Route::post('/invoice_member_remove', [HomeVendorController::class, "invoice_member_remove"]);

Route::post('/invoice_products', [HomeVendorController::class, "invoice_products"]);
Route::post('/invoice_product_add', [HomeVendorController::class, "invoice_product_add"]);
Route::post('/invoice_product_add_barcode', [HomeVendorController::class, "invoice_product_add_barcode"]);


Route::post('/invoice_product_update', [HomeVendorController::class, "invoice_product_update"]);
Route::post('/invoice_product_delete', [HomeVendorController::class, "invoice_product_delete"]);
Route::post('/cart_data', [HomeVendorController::class, "cart_data"]);

Route::post('/vendor_types', [HomeVendorController::class, "vendor_types"]);
Route::post('/products_chart', [HomeVendorController::class, "products_chart"]);
Route::post('/members_chart', [HomeVendorController::class, "members_chart"]);
Route::post('/offer_create', [HomeVendorController::class, "offer_create"]);
Route::post('/offer_total', [HomeVendorController::class, "offer_total"]);
Route::post('/offer_members', [HomeVendorController::class, "offer_members"]);
Route::post('/vendor_membership', [HomeVendorController::class, "vendor_membership"]);
Route::post('/renew_membership', [HomeVendorController::class, "renew_membership"]);
/*Business penel api end*/
Route::post('/veiw_alerts', [HomeVendorController::class, "veiw_alerts"]);
Route::post('/alert_read', [HomeVendorController::class, "alert_read"]);

Route::post('/pay_invoice_user', [HomeVendorController::class, "pay_invoice_user"]);
Route::post('/pay_invoice', [HomeVendorController::class, "pay_invoice"]);
Route::post('/vendor_approve', [HomeVendorController::class, "vendor_approve"]);


/*user penel api start*/
Route::post('/home', [HomeController::class, "index"]);
Route::post('/budget_detail_index', [HomeController::class, "budget_detail_index"]);
Route::post('/member_add', [HomeController::class, "member_add"]);



/*user info*/
Route::post('/edit_profile', [UserProfileController::class, "index"]);
Route::post('/view_profile', [UserProfileController::class, "view"]);
Route::post('/change_profile', [UserProfileController::class, "update"]);
Route::post('/change_pass', [UserProfileController::class, "change_pass"]);

/*budgets*/
Route::get('/budget', [BudgetController::class, "index"]);
Route::prefix("/budget")->group(function(){
    Route::post("/add", [BudgetController::class, "add"]);
    Route::put("/{id}", [BudgetController::class, "update"]);
    Route::put("/salary/{id}", [BudgetController::class, "updateSalary"]);
    Route::delete("/{id}", [BudgetController::class, "destroy"]);
});
Route::post("/budget_list", [BudgetController::class, "budget_list"]);
Route::post("/budget_update", [BudgetController::class, "budget_update"]);
Route::post("/budget_reset", [BudgetController::class, "budget_reset"]);
Route::post("/budget_delete", [BudgetController::class, "budget_delete"]);
Route::post("/user_exptype_list", [ExpenseController::class, "user_exptype_list"]);
Route::post("/exptype_update", [ExpenseController::class, "exptype_update"]);
/*expense types uses*/
Route::get('/expense', [ExpenseController::class, "index"]);
Route::prefix("/expense")->group(function(){
    Route::post("/expense_type_add", [ExpenseController::class, "expense_type_add"]);
    Route::post('/Expdata', [ExpenseController::class, "data"]);
    Route::put("/{id}", [ExpenseController::class, "update"]);
    Route::delete("/{id}", [ExpenseController::class, "destroy"]);
    Route::post("/exptype_delete", [ExpenseController::class, "exptype_delete"]);
});

/*support*/
// Route::post('/support', [SupportController::class, "index"]);
// Route::get('/support_types', [SupportController::class, "support_types"]);
// Route::post("/support_add_web", [SupportController::class, "add"]);
// Route::post("/support_add", [SupportController::class, "add_api_support"]);
// Route::post("/support_update", [SupportController::class, "update"]);
// Route::post("/support_delete", [SupportController::class, "destroy"]);
// Support APi
Route::get('/support_type',[SupportController::class,'support_type']);
Route::prefix('/support')->group(function(){
    Route::post('/',[SupportController::class,'index']);
    Route::post('/details',[SupportController::class,'supportDetails']);
    Route::post('/add-support',[SupportController::class,'add_support']);
    Route::post('/reply-support',[SupportController::class,'reply_support']);
});

/*pages*/
Route::post('/pages', [PagesController::class, "index"]);
/*user penel api end*/

// expense type vendors
Route::post('/expense_vendors', [ExpenseVendorsController::class, "expense_vendors"]);
Route::post('/expense_vendor_detail', [ExpenseVendorsController::class, "expense_vendor_detail"]);
Route::post('/invoice_detail', [ExpenseVendorsController::class, "invoice_detail"]);
Route::post('/vendor_warranty', [ExpenseVendorsController::class, "vendor_warranty"]);
Route::post('/user_invoice_setting', [ExpenseVendorsController::class, "invoice_setting"]);
Route::post('/user_vendor_setting', [ExpenseVendorsController::class, "vendor_setting"]);

Route::post('/due_list_users', [ExpenseVendorsController::class, "due_list_users"]);
Route::post('/due_list_vendors', [ExpenseVendorsController::class, "due_list_vendors"]);



Route::post('/manage_salary', [SalaryController::class, "manage_salary"]);
Route::post('/salary_update', [SalaryController::class, "salary_update"]);
Route::post('/salary_reset', [SalaryController::class, "salary_reset"]);
Route::post('/salary_reset_monthly', [SalaryController::class, "salary_reset_monthly"]);

Route::post('/user_more', [HomeController::class, "user_more"]);
Route::post('/profile_edit', [HomeController::class, "profile_edit"]);
Route::post('/profile_view', [HomeController::class, "profile_view"]);
Route::post('/profile_update', [HomeController::class, "profile_update"]);
Route::post('/members_list', [HomeController::class, "members_list"]);
Route::post('/members_user', [HomeController::class, "members_user"]);
Route::post('/members_vendor', [HomeController::class, "members_vendor"]);

Route::post('/user_subscribe', [HomeController::class, "user_subscribe"]);
Route::post('/packages', [HomeController::class, "packages"]);
Route::post('/user_offers', [HomeController::class, "user_offers"]);
Route::post('/general_all_offers', [HomeController::class, "general_all_offers"]);
Route::post('/skip_renew', [HomeController::class, "skip_renew"]);

Route::post('/salary_detail', [HomeController::class, "salary_detail"]);
Route::post('/budget_detail', [HomeController::class, "budget_detail"]);
Route::post('/shop_add_type', [HomeController::class, "shop_add_type"]);
Route::post('/read', [HomeController::class, "read"]);
// nearby in locations
Route::post('/near_by', [HomeController::class, "near_by"])->name('near_by');
Route::post('/offer_read', [HomeController::class, "offer_read"]);
Route::post('/vendor_online', [HomeController::class, "vendor_online"]);

Route::post('/vendor_barcode', [HomeVendorController::class, "vendor_barcode"]);

Route::post('/delete_account', [HomeController::class, "delete_account"]);
Route::post('/otp_delete', [HomeController::class, "otp_delete"]);