<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\OrdernoController;
use App\Http\Controllers\Admin\LanguageController;
use App\Http\Controllers\Admin\NotificationController;

use App\Http\Controllers\Admin\SMSController;
use App\Http\Controllers\Admin\EmailController;
use App\Http\Controllers\Admin\MailingController;
use App\Http\Controllers\Admin\TemplateController;
use App\Http\Controllers\Admin\ProfileController;
use App\Http\Controllers\Admin\SiteController;
use App\Http\Controllers\Admin\ActivityLog;
use App\Http\Controllers\Admin\LogeController;
use App\Http\Controllers\Admin\MenuController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\ThemeController;

use App\Http\Controllers\Extra\ServiceController;
use App\Http\Controllers\Extra\TeamController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\PagesController;
use App\Http\Controllers\Extra\ClientController;
use App\Http\Controllers\Admin\CountryController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\PortFolioController;
use App\Http\Controllers\Extra\TestimonialController;
use App\Http\Controllers\Extra\PortfolioTypeController;
use App\Http\Controllers\Extra\PortfolioGalleryController;
use App\Http\Controllers\Admin\SupportController;
use App\Http\Controllers\Admin\ContactUstController;
use App\Http\Controllers\AppController;



Route::get('/', [ThemeController::class, 'home']);
Route::get('/privacy', [ThemeController::class, 'privacy'])->name('privacy');
Route::get('/terms', [ThemeController::class, 'terms'])->name('terms');
Route::post('/contact_msg', [ThemeController::class, 'contact_msg_save'])->name('contact_msg_save');

Route::group(['middleware' => ['auth']], function() {
    // Orders
    Route::any('/order_12', [OrdernoController::class, 'index'])->name('order_no');

    // Language
    Route::get('/languages', [LanguageController::class, 'index'])->name('languages');
    Route::prefix("/language")->group(function(){
        Route::get('/labels/{lang?}/{file?}', [LanguageController::class, 'showTexts'])->where('lang', '[^/]*')->where('file', '[^/]*')->name('translation');
        Route::post('/labels/{lang}/{file}', [LanguageController::class, 'updateTexts'])->where('lang', '[^/]+')->where('file', '[^/]+')->name('save_translation');
        Route::get('/create', [LanguageController::class, 'create']);
        Route::post('/store', [LanguageController::class, 'store']);
        Route::post('/update', [LanguageController::class, 'update']);
        Route::get('/edit/{id}', [LanguageController::class, 'edit']);
    });

    // Notification
    Route::prefix("/notification")->group(function(){
        Route::get('/', [NotificationController::class, 'index'])->name('notification');
        Route::get('/get-list', [NotificationController::class, 'get_list']);
        Route::post('/send', [NotificationController::class, 'send'])->name('send_notification');
        Route::get('/get_template/{id}', [NotificationController::class, 'get_template'])->name('get_template_notify');
    });

    // Notification host
    Route::get('/notification_host', [NotificationController::class, 'host_list'])->name('notification_host');
    Route::prefix("/notification_host")->group(function(){
        Route::get('/add', [NotificationController::class, 'create']);
        Route::post('/store', [NotificationController::class, 'store'])->name('add_notify_hosts');
        Route::get('/edit/{id}', [NotificationController::class, 'edit']);
        Route::post('/update', [NotificationController::class, 'update'])->name('update_notify_hosts');
        Route::post('/status', [NotificationController::class, 'status']);
        Route::post('/is_default', [NotificationController::class, 'is_default']);
        Route::post('/destroy', [NotificationController::class, 'destroy']);
    });

    // Notification templates
    Route::get('/notification_template', [NotificationController::class, 'notification_template'])->name('notification_template');
    Route::prefix("/notification_template")->group(function(){
        Route::get('/add', [NotificationController::class, 'add_temp']);
        Route::post('/save', [NotificationController::class, 'save_temp'])->name('save_notify_temp');
        Route::get('/edit/{id}', [NotificationController::class, 'edit_temp']);
        Route::post('/update', [NotificationController::class, 'update_temp'])->name('update_notify_temp');
        Route::post('/status', [NotificationController::class, 'temp_status']);
        Route::post('/is_default', [NotificationController::class, 'temp_is_default']);
        Route::post('/destroy', [NotificationController::class, 'temp_destroy']);
    });

    // Sms hosts
    Route::prefix("/sms_hosts")->group(function(){
        Route::get('/', [SMSController::class, 'index'])->name('sms_hosts');
        Route::get('/host_list', [SMSController::class, 'host_list']);
        Route::get('/add', [SMSController::class, 'create']);
        Route::post('/store', [SMSController::class, 'store'])->name('add_sms_hosts');
        Route::get('/edit/{id}', [SMSController::class, 'edit']);
        Route::post('/update', [SMSController::class, 'update'])->name('update_sms_hosts');
        Route::post('/status', [SMSController::class, 'status']);
        Route::post('/is_default', [SMSController::class, 'is_default']);
        Route::post('/destroy', [SMSController::class, 'destroy']);
    });

    // Sms templates
    Route::get('/sms_template', [SMSController::class, 'sms_template'])->name('sms_template');
    Route::prefix("/sms_template")->group(function(){
        Route::get('/add_temp', [SMSController::class, 'add_temp']);
        Route::post('/save_temp', [SMSController::class, 'save_temp'])->name('save_temp');
        Route::get('/edit_temp/{id}', [SMSController::class, 'edit_temp']);
        Route::post('/update_temp', [SMSController::class, 'update_temp'])->name('update_temp');
        Route::post('/status', [SMSController::class, 'temp_status']);
        Route::post('/is_default', [SMSController::class, 'temp_is_default']);
        Route::post('/destroy', [SMSController::class, 'temp_destroy']);
    });

    // Sms
    Route::get('/sms', [SMSController::class, "sms_index"])->name('sms');
    Route::prefix("/sms")->group(function () {
        Route::post("/send_sms", [SMSController::class, "send_sms"])->name('send_sms');
        Route::get("/get_template/{id}", [SMSController::class, "get_template"])->name('get_sms_template');
    });

    // Email hosts
    Route::prefix("/email_hosts")->group(function(){
        Route::get('/', [EmailController::class, 'index'])->name('email_hosts');
        Route::get('/host_list', [EmailController::class, 'host_list']);
        Route::get('/add', [EmailController::class, 'create']);
        Route::post('/store', [EmailController::class, 'store'])->name('add_email_hosts');
        Route::get('/edit/{id}', [EmailController::class, 'edit']);
        Route::post('/update', [EmailController::class, 'update'])->name('update_email_hosts');
        Route::post('/status', [EmailController::class, 'status']);
        Route::post('/is_default', [EmailController::class, 'is_default']);
        Route::post('/destroy', [EmailController::class, 'destroy']);
    });

    // Email mailing
    Route::get('/send_email', [MailingController::class, "index"])->name('send_email');
    Route::prefix("/send_email")->group(function () {
        Route::post("/send", [MailingController::class, "send"])->name('send_mail');
        Route::get("/get_template/{id}", [MailingController::class, "get_template"])->name('get_template');
    });

    /*template*/
    Route::match(['get', 'post'], '/email_templates', [TemplateController::class, "index"])->name('email_templates');
    Route::prefix("/email_templates")->group(function () {
        Route::get("/add", [TemplateController::class, "add"]);
        Route::post("/save", [TemplateController::class, "save"]);
        Route::get("/edit/{id}", [TemplateController::class, "edit"]);
        Route::post("/update", [TemplateController::class, "update"]);
        Route::post("/status", [TemplateController::class, "status"]);
        Route::post("/destroy", [TemplateController::class, "destroy"]);
    });
    /*template end*/

    // Frond End Theme
    Route::prefix("/theme")->group(function(){
        Route::get('/', [ThemeController::class, 'index'])->name('notification');
        Route::get('/settings{id}', [ThemeController::class, 'edit'])->name('udpate_theme');
        Route::post('/update{id}', [ThemeController::class, 'update'])->name('udpate_theme');
    });

    //Profile
    Route::get('/profile', [ProfileController::class, "index"])->name('profile');
    Route::prefix("/profile")->group(function () {
        Route::post("/updateProfile", [ProfileController::class, "updateProfile"])->name('updateProfile');
        Route::post("/resetPass", [ProfileController::class, "resetPass"])->name('resetPass');
        Route::post("/favourite_menu", [ProfileController::class, "favourite_menu"])->name('favourite_menu');
    });

    //site info
    Route::get('/site_info', [SiteController::class, "index"])->name('site_info');
    Route::prefix("/site_info")->group(function () {
        Route::post("/update", [SiteController::class, "update"])->name('site_info_update');
    });

	// Front end routes ..
	Route::prefix('/frontend')->group(function(){
    Route::get('/', [ThemeController::class, 'settings']);
    Route::get('/section/{section}/{lang?}', [ThemeController::class, 'show']);
    Route::get('/delete-slider/{slider}/{section}', [ThemeController::class, 'delete_slider']);

    Route::post('/update', [ThemeController::class, 'update']);

    Route::post('/change-status', [ThemeController::class, 'change_status']);
	});


    Route::get('ChangeTheme/{theme?}', [AppController::class, 'ChangeTheme']);
    //Get All Category
    // Roufa

    //manage users
    Route::get('/users', [UserController::class, 'index'])->name('users.index');
    Route::prefix("/users")->group(function () {
        Route::post("/addModel", [UserController::class, "addModel"]);
        Route::post("/save", [UserController::class, "save"]);
        Route::post("/editModel", [UserController::class, "editModel"]);
        Route::post("/update", [UserController::class, "update"]);
        Route::post("/destroy", [UserController::class, "destroy"]);
        //Route::post("/status_change", [UserController::class, "statusChange"]);
    });


    //manage roles and permissins
    Route::get('/user_roles', [RoleController::class, 'index'])->name('user_roles.index');
    Route::prefix("/user_roles")->group(function () {
        Route::post("/addModel", [RoleController::class, "addModel"]);
        Route::post("/save", [RoleController::class, "save"]);
        Route::post("/editModel", [RoleController::class, "editModel"]);
        Route::post("/update", [RoleController::class, "update"]);
        Route::post("/destroy", [RoleController::class, "destroy"]);
        Route::get("/assign-permissions-view/{role_id}", [RoleController::class, "assign_permissions"])->name('assign-permissions-view');
        Route::post("/assign-permission", [RoleController::class, "assign_permission_to_role"])->name('assign-permission');
    });

    Route::get('/socials', [SiteController::class, "socials"])->name('socials');
    Route::prefix("/socials")->group(function () {
        Route::post("/addModel", [SiteController::class, "addModelSocials"]);
        Route::post("/save", [SiteController::class, "saveSocials"]);
        Route::post("/editModel", [SiteController::class, "editModelSocials"]);
        Route::post("/update", [SiteController::class, "updateSocials"]);
        Route::post("/status_change", [SiteController::class, "statusSocials"]);
        Route::post("/destroy", [SiteController::class, "destroySocials"]);
    });


    //country
    Route::get('/countries', [CountryController::class, "index"])->name('countries');
    Route::prefix("/countries")->group(function () {
        Route::post("/addModel", [CountryController::class, "addModel"]);
        Route::post("/save", [CountryController::class, "save"]);
        Route::post("/editModel", [CountryController::class, "editModel"]);
        Route::post("/update", [CountryController::class, "update"]);
        Route::post("/status_change", [CountryController::class, "statusChange"]);
        Route::post("/destroy", [CountryController::class, "destroy"]);
    });

    /*pages*/
    Route::get('/pages', [PagesController::class, "index"])->name('pages');
    Route::prefix("/pages")->group(function () {
        //Route::post('/add', [PagesController::class, 'add']);
        Route::get("/edit/{id}", [PagesController::class, "edit"]);
        Route::post("/update", [PagesController::class, "update"])->name('pages_update');
        Route::post("/status", [PagesController::class, "status"]);
        //Route::post("/destroy", [PagesController::class, "destroy"]);
    });
    /*pages end*/

    // Menus
    Route::get('/menu', [MenuController::class, 'index'])->name('menu');
    Route::prefix('/menu')->group(function () {
        Route::post('/save', [MenuController::class, 'store']);
        Route::post('/status_change', [MenuController::class, 'status_change']);
        Route::get('/addMenu', [MenuController::class, 'addMenu']);
        Route::get('/edit/{id}', [MenuController::class, 'edit']);
        Route::get('/destroy/{id}', [MenuController::class, 'destroy']);
        Route::post('/update', [MenuController::class, 'update']);
    });
    // end menus

    // Portfolio
    Route::any('/portfolio', [PortFolioController::class, 'index'])->name('portfolio');
    Route::prefix('/portfolio')->group(function () {
        Route::match(['get', 'post'], '/', [PortFolioController::class, 'index']);
        Route::post('/save', [PortFolioController::class, 'store']);
        Route::post('/status_change', [PortFolioController::class, 'status_change']);
        Route::get('/edit/{id}', [PortFolioController::class, 'edit']);
        Route::post('/update', [PortFolioController::class, 'update']);
        Route::get('/destroy/{id}', [PortFolioController::class, 'destroy']);
    });
    // endportfolio

    // Portfolio Type
    Route::any('/portfolio-type', [PortfolioTypeController::class, 'index'])->name('portfolio-type');
    Route::prefix('/portfolio-type')->group(function () {
        Route::match(['get', 'post'], '/', [PortfolioTypeController::class, 'index']);
        Route::post('/save', [PortfolioTypeController::class, 'store']);
        Route::post('/status_change', [PortfolioTypeController::class, 'status_change']);
        Route::get('/edit/{id}', [PortfolioTypeController::class, 'edit']);
        Route::post('/update', [PortfolioTypeController::class, 'update']);
        Route::get('/destroy/{id}', [PortfolioTypeController::class, 'destroy']);
    });
    // endportfolio Type

    // Portfolio Gallery
    Route::any('/portfolio-gallery', [PortfolioGalleryController::class, 'index'])->name('portfolio-gallery');
    Route::prefix('/portfolio-gallery')->group(function () {
        Route::match(['get', 'post'], '/', [PortfolioGalleryController::class, 'index']);
        Route::post('/save', [PortfolioGalleryController::class, 'store']);
        Route::post('/status_change', [PortfolioGalleryController::class, 'status_change']);
        Route::get('/edit/{id}', [PortfolioGalleryController::class, 'edit']);
        Route::post('/update', [PortfolioGalleryController::class, 'update']);
        Route::get('/destroy/{id}', [PortfolioGalleryController::class, 'destroy']);
    });
    // endportfolio Gallery

    // testimonials
    Route::any('/testimonials', [TestimonialController::class, 'index'])->name('testimonials');
    Route::prefix('/testimonials')->group(function () {
        Route::match(['get', 'post'], '/', [TestimonialController::class, 'index']);
        Route::post('/save', [TestimonialController::class, 'store']);
        Route::post('/status_change', [TestimonialController::class, 'status_change']);
        Route::get('/edit/{id}', [TestimonialController::class, 'edit']);
        Route::post('/update', [TestimonialController::class, 'update']);
        Route::get('/destroy/{id}', [TestimonialController::class, 'destroy']);
    });
    // testimonials

    // Services
    Route::any('/services', [ServiceController::class, 'index'])->name('services');
    Route::prefix('/services')->group(function () {
        Route::match(['get', 'post'], '/', [ServiceController::class, 'index']);
        Route::post('/save', [ServiceController::class, 'store']);
        Route::post('/status_change', [ServiceController::class, 'status_change']);
        Route::get('/edit/{id}', [ServiceController::class, 'edit']);
        Route::post('/update', [ServiceController::class, 'update']);
        Route::get('/destroy/{id}', [ServiceController::class, 'destroy']);
    });
    // Services


    // Team
    Route::any('/team', [TeamController::class, 'index'])->name('team');
    Route::prefix('/team')->group(function () {
        Route::match(['get', 'post'], '/', [TeamController::class, 'index']);
        Route::post('/save', [TeamController::class, 'store']);
        Route::post('/status_change', [TeamController::class, 'status_change']);
        Route::get('/edit/{id}', [TeamController::class, 'edit']);
        Route::post('/update', [TeamController::class, 'update']);
        Route::get('/destroy/{id}', [TeamController::class, 'destroy']);
    });
    // Team

    // Clients
    Route::any('/clients', [ClientController::class, 'index'])->name('clients');
    Route::prefix('/clients')->group(function () {
        Route::match(['get', 'post'], '/', [ClientController::class, 'index']);
        Route::post('/save', [ClientController::class, 'store']);
        Route::post('/status_change', [ClientController::class, 'status_change']);
        Route::get('/edit/{id}', [ClientController::class, 'edit']);
        Route::post('/update', [ClientController::class, 'update']);
        Route::get('/destroy/{id}', [ClientController::class, 'destroy']);
    });
    // Clients

    // User Activity
    Route::any('/user-activity', [ActivityLog::class, 'index'])->name('user-activity');
    Route::prefix('/user-activity')->group(function () {
        Route::match(['get', 'post'], '/', [ActivityLog::class, 'index']);
        Route::match(['get', 'post'], '/user-login-log', [LogeController::class, 'getUserLoginLog'])->name('user-login-log');
        Route::get('/loges/{fromdate?}/{toDate?}', [LogeController::class, 'index'])->name('my-loges');
    });

	Route::any('/setting', [SettingController::class, 'index'])->name('setting');

    // support manage list
	//Route::any('/support', [SupportController::class, 'index'])->name('provider');
    Route::get('/support', [SupportController::class, 'index'])->name('support');
    Route::prefix("/support")->group(function(){
        Route::get('/status_change/{id}/{status}', [SupportController::class, 'status_change']);
        Route::get('/support_view/{id}', [SupportController::class, 'support_view']);
        Route::post('/support_reply', [SupportController::class, 'support_reply'])->name('support_reply');
    });

    Route::get('/contact_us_list', [ContactUstController::class, 'index'])->name('contact_us_list');
    Route::prefix("/contact_us_list")->group(function(){
        Route::get('/status_change/{id}/{status}', [ContactUstController::class, 'status_change']);
        Route::get('/viewed/{id}', [ContactUstController::class, 'viewed']);
        Route::post('/reply', [ContactUstController::class, 'reply'])->name('contact_reply');
    });

    Route::get('/contact_us_list', [ContactUstController::class, 'index'])->name('contact_us_list');
    Route::prefix("/contact_us_list")->group(function(){
        Route::get('/status_change/{id}/{status}', [ContactUstController::class, 'status_change']);
        Route::get('/viewed/{id}', [ContactUstController::class, 'viewed']);
        Route::post('/reply', [ContactUstController::class, 'reply'])->name('contact_reply');
    });
});
