<script type="text/javascript" >
$(document).ready(function () {
   $("#save_user").on('submit', (function (e) {
     var u_name = $('#u_name').val();
     var u_email = $('#u_email').val();
     var u_pass = $('#u_pass').val();
     if(u_name === ''){
       swal("{{trans('admin.please_enter_user_name')}}");
       $('#u_name').focus();
       e.preventDefault();
     }
     else if(u_email === ''){
       swal("{{trans('admin.please_enter_valid_email_Address')}}");
       $('#u_email').focus();
       e.preventDefault();
     }
     else if(u_pass === ''){
       swal("{{trans('admin.please_enter_valid_Password')}}");
       $('#u_pass').focus();
       e.preventDefault();
     }
     else{
      $("#spiner-save_user").addClass('fa fa-refresh fa-spin');
       e.preventDefault();
       var fd = new FormData(this);
       $.ajax({
           url: '{{url("/user_list/save")}}',
           data:fd,
           type: "POST",
           dataType: 'json',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token()}}'
            },
           contentType: false,
           processData: false,
           cache: false,
           success: function (data) {
               swal(data.text,data.cls);
               $("#spiner-save_user").removeClass('fa fa-refresh fa-spin');
           },
           error: function (xhr) {
               $("#status_msg").html("Error: - " + xhr.status + " " + xhr.statusText);
               $("#spiner-save_user").removeClass('fa fa-refresh fa-spin');
           }
       });
       }
   }));

   //Updating User record
   $("#update_user").on('submit', (function (e) {
     var u_name = $('#u_name_u').val();
     var u_email = $('#u_email_u').val();
     if(u_name === ''){
       swal("{{trans('admin.please_enter_user_name')}}");
       $('#u_name').focus();
       e.preventDefault();
     }
     else if(u_email === ''){
       swal("{{trans('admin.please_enter_valid_email_Address')}}");
       $('#u_email').focus();
       e.preventDefault();
     }
  else{
    $("#spiner-update_user").addClass('fa fa-refresh fa-spin');
       e.preventDefault();
       var fd = new FormData(this);
       $.ajax({
           url: '{{url("/user_list/update")}}',
           data:fd,
           type: "POST",
           dataType: 'json',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token()}}'
            },
           contentType: false,
           processData: false,
           cache: false,
           success: function (data) {
               swal(data.text,data.cls);
               $("#spiner-update_user").removeClass('fa fa-refresh fa-spin');
           },
           error: function (xhr) {
               $("#status_update").html("Error: - " + xhr.status + " " + xhr.statusText);
               $("#spiner-update_user").removeClass('fa fa-refresh fa-spin');
           }
       });
       }
   }));

   $(document).on('change', '.state_switch', function(event) {
    event.preventDefault();
      loading();
        var cid = $(this).val();
        $.ajax({
            url: '{{url("/user_list/status_change")}}',
            type: 'post',
            dataType:'json',
            data: {_token: '{!! csrf_token() !!}', id: cid}
        })
        .done(function (response) {
          swal(response.text,response.cls);
        })
        .fail(function () {
            console.log("error");

        }).always(function(){
          loading("stop");
        });
  });
});

  function delete_user(id){
    try{
    if(confirm("{{trans('admin.Are_you_sure')}}")){
      $.ajax({
        url: '{{url("/user_list/destroy")}}',
        data:{
          _token: '{!! csrf_token() !!}',
          id:id
        },
        type:"POST",
        dataType: 'json',
        cache:false,
        success: function(res){
          swal(res.text,res.cls);
          $("#"+id).hide(2000);
        },
        error: function(xhr){
          alert('Error: - </b>'+xhr.status+' '+xhr.statusText);
          }
        });
      }
    }catch(e){
      alert(e.message);
    }
  }

  function add_user(){
  $("#status_msg").html('');
 try{
   $("#adduser").modal("show");
   $.ajax({
     url: '{{url("/user_list/addModel")}}',
     data:{
       _token: '{!! csrf_token() !!}',
     },
     type: 'POST',
     cache:false,
     success: function(frm){
       $("#box").html(frm);
       },
     error: function(xhr){
       $("#box").html(xhr.status+' '+xhr.statusText);
       }
     });
   }catch(e){
     alert(e.message);
   }
 };

 function edit_user(id){
   $("#status_update").html('');
  try{
    $("#edituser").modal("show");
    $.ajax({
      url: '{{url("/user_list/editModel")}}',
      data:{
        _token: '{!! csrf_token() !!}',
        id:id
      },
      type: 'POST',
      cache:false,
      success: function(frm){
        $("#box_edit").html(frm);
        },
      error: function(xhr){
        $("#box_edit").html(xhr.status+' '+xhr.statusText);
        }
      });
    }catch(e){
      alert(e.message);
    }
  };
</script>
