@extends('admin.layout.master')
@section('content')
@include('admin/users/user_js')

<main class="container-fluid mt-2 px-0 scroll-y">
    <!-- body content  -->
    <div class="card card-invoice rounded border-0">
      <div class="card-body pt-0">
        <div class="row p-0 g-2 align-items-end bg-light px-2 pb-2 border mt-1 mx-0 no-print" id="from_to_date_area">
          <div class="col-lg-8 col-md-4">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('sarf.home')}}  </a> <span class="bi bi-caret-right"></span>
            <span class='text-decoration-none fw-bold' >{{trans('sarf.manage_users')}}</span>  
          </div>
          <div class="d-flex justify-content-between col-lg-4 col-12">
            <div class="col-6 mt-1 mt-1">
              <input type="text" class="filtertbl form-control form-control-sm" id="search_new" style="min-width:150px;" placeholder="{{trans('sarf.search')}}">
            </div>
            <div class="col-6 ml-md-auto">
               <!-- <button class="btn btn-success rounded-pill btn-sm px-3" onclick="add_user()">
              Add New
            </button> -->
            </div>
          </div>
      </div>

        <div class="row">
          <div class="col-lg-12">
            <div class="table-responsive">
              <table class="table w-100 table-sm table-hover mb-0 table-bordered data-table">
                <thead class="bg-light">
                    <tr>
                        <th width="2%">{{trans('admin.id')}}</th>
                        <th width="5%">{{trans('admin.Name')}}</th>
                        <th width="25%">{{trans('admin.username')}}</th>
                        <th width="2%">{{trans('admin.status')}}</th>
                        <th width="2%">{{trans('admin.action')}}</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
        </div>
      </div>
    </div>
  </div>
</main>
<style>
	.dataTables_filter {
    display: none;
  }
</style>
<script type="text/javascript">
var table ="";
  $(function () {
    
     table = $('.data-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ route('users.index') }}",
        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {data: 'name', name: 'name'},
            {data: 'username', name: 'username'},
            {data: 'status', name: 'status', orderable: false, searchable: false},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ],
		"lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]]
    });
     
  });
  $("#search_new").on("keyup search input paste cut", function() {
   table.search(this.value).draw();
});  
</script>

{!! modelBox("adduser", trans('admin.Add'),"box","status_msg","save_user") !!}
{!! modelBox("edituser", trans('admin.Edit'),"box_edit","status_update","update_user") !!}
@endsection