@extends('sarf/pos.layout.master')
@section('content')
<!-- THE ROW END HERE -->
<div class='bg-white p-2 rounded m-2'>
    {{-- <div class="rowjustify-content-between p-2 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center p-2">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill"></span>
            <a class='text-decoration-none fw-bold ' href="{{url('/manage_category')}}">{{trans('category')}}  </a> <span class="bi bi-caret-right"></span>
            <span class='text-decoration-none fw-bold' >{{trans('add category')}}</span>
        </div>
    </div> --}}
    <div class='p-3'>
        <form action="{{route('generate_simple_invoice')}}" method="post" enctype="multipart/form-data">
            <input type="hidden" name="_token" value="{{ csrf_token() }}" />
            <div class="row">
                <div class="col-md-6">
                    @if(session()->has('success'))
                        <div class="bg-success p-2 mt-4 rounded text-white">
                            <span class="input-error">{{ session()->get('success') }}</span>
                        </div>
                    @elseif(session()->has('error'))
                        <div class="bg-danger p-2 mt-4 rounded text-white">
                            <span class="input-error">{{ session()->get('error') }}</span>
                        </div>
                    @endif
                    <br>
                    <div class="mb-3 font-text">
                        <label for="name_en" class="form-label">{{ trans('admin.select member') }}</label>
                        <select class="form-select rounded-pill bg-light_c border-0 @error('member_id') is-invalid @enderror" name="member_id" id="member_id">
                            <option value="">Select</option>
                            @foreach($data['members_list'] as $value)
                            <option value="{{$value->user_id}}" @if(old('member_id') == $value->user_id) selected @endif> 
                                {{$value->name}} 
                            </option>
                            @endforeach
                        </select>
                        @error('member_id') 
                            <span class="text-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                    <div class="mb-3 font-text">
                        <label for="invoice_note" class="form-label">{{ trans('admin.description') }}</label>
                        <textarea type="text" class="form-control bg-light_c border-0 @error('invoice_note') is-invalid @enderror" id="invoice_note" name="invoice_note" placeholder="{{ trans('admin.description') }}" aria-describedby="emailHelp" rows="5">{{old('invoice_note')}}</textarea>
                        @error('invoice_note') 
                            <span class="text-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                    <div class="mb-3 font-text">
                        <label for="net_total" class="form-label">{{ trans('admin.amount') }}</label>
                        <input type="number" class="form-control rounded-pill bg-light_c border-0 @error('net_total') is-invalid @enderror" id="net_total" name="net_total" placeholder="{{ trans('admin.amount') }}" aria-describedby="emailHelp" value="{{old('net_total')}}">
                        @error('net_total') 
                            <span class="text-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                </div>
            </div>
            <button type='sumbit' class='btn  btn-color rounded-pill text-light px-5 mt-3 '>{{ trans('admin.generate') }}</button>
        </form>
    </div>
</div>
@endsection
