@extends('sarf/pos.layout.master')
@section('content')
<div class='bg-white p-2 rounded m-2'>
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right"></span>
            <span class='text-decoration-none fw-bold' >{{trans('admin.products')}}</span>  
        </div>
        <div class="col-8 col-md-6 align-self-center float-end ">
            <div class='align-self-center  text-center justify-content-center'>
            <div class="row">
                <div class="col-md-5">
                    <div>
                        <input type="text" class="form-control rounded-pill bg-light" id="search_new" placeholder="{{trans('admin.search')}}">
                    </div>
                </div>
                <div class="col-md-3">
                  <select id="status_filter" class="form-select rounded-pill">
                      <option value="" selected>{{trans('admin.all_status')}}</option>
                      <option value="1"> {{trans('admin.active')}} </option>
                      <option value="0"> {{trans('admin.inactive')}} </option>
                  </select>
                </div>
                <div class="col-md-2">
                  <a class='text-decoration-none ' href="{{url('/manage_product/add')}}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 55 55">
                        <g id="Group_12506" data-name="Group 12506" transform="translate(-1134.648 -427.545)">
                        <ellipse id="Ellipse_593" data-name="Ellipse 593" cx="27.5" cy="27.5" rx="27.5" ry="27.5" transform="translate(1134.648 427.545)" fill="#f56a20"/>
                        <path id="Path_15415" data-name="Path 15415" d="M1.438-6.844V-9.469H8.25v-6.859h2.672v6.859h6.813v2.625H10.922V0H8.25V-6.844Z" transform="translate(1153.017 463.249)" fill="#fff"/>
                        </g>
                        </svg>
                    </a>
                </div>
                <div class="col-md-2">
                    <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#exampleModal">
                        Import
                    </button>
                </div>
                </div>
            </div>
        </div>
    </div>
   
</div>
<div class="container-fluid p-2 rounded my-2 mx-3">
    <div class='table-responsive '>
        @if (session()->has('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session()->get('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @elseif(session()->has('error'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ session()->get('error') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
        @error('file')
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ $message }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div> 
        @enderror
        <table class='table table-sm w-100 table-border data-table'>
            <thead>
                <tr class='tex-g'>
                    <th>{{ trans('admin.name') }}</th>
                    <th>{{ trans('admin.price') }}</th>
                    <th class='text-center'>{{ trans("admin.status") }}</th>
                    <th>{{ trans('admin.actions') }}</th>
                </tr>
            </thead>
            <tbody>

            </tbody>
        </table>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Import</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{url('/manage_product/import')}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="input-group mb-3">
                        <input type="file" name="file" class="form-control">
                        <button class="btn btn-primary" type="submit">Submit</button>
                    </div>
                    <a href="{{url('/template/download/products.xlsx')}}">Please click here to download template and fill accordingly</a>
                </form>
            </div>
        </div>
    </div>
    </div>
<script type="text/javascript">
    var table = "";
    $(function() {
        table = $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            "searching": false,
            ajax: {
                url: "{{ route('manage_product') }}",
                type: 'GET',
                data: function(d) {
                  d.search_new = $('#search_new').val();
                  d.status_filter = $('#status_filter').val();
                  // console.log(d);
                }
            },
            columns: [
                {data: 'name', name: 'name'},
                {data: 'price', name: 'price'},
                {data: 'status', name: 'status', orderable: false, searchable: false},
                {data: 'actions', name: 'actions', orderable: false, searchable: false},
            ],
            "lengthMenu": [[10, 25, 50, 100, -1], [100, 200, 500, 700, "All"]]
        });
    });
    $('body').on('change', '#status_filter', function(e) {
      table.draw(true);
    });
    $('body').on('keyup', '#search_new', function(e) {
      table.draw(true);
    });
    $('body').on('click', '.clear', function(e) {
        $('#search_new').val("");
        $('#status_filter').val("");
        table.draw(true);
    });

    function state_switch(id) {
    	loading();
        //var cid = $(this).val();
        $.ajax({
            url: '{{url("/manage_product/status")}}',
            type: 'post',
            dataType:'json',
            data: {_token: '{!! csrf_token() !!}', id: id}
        })
        .done(function (res) {
        	swal(res.text,res.cls);
        })
        .fail(function () {
            console.log("error");

        }).always(function(){
        	loading("stop");
        });
    }

	function destroy(id) {
	    bootbox.confirm("{{trans('admin.Are_you_sure_to_delete')}}", function(result){
	      loading();
	      //let id = $(this).val();
	      $.ajax({
	          url: '{{url("/manage_product/destroy")}}',
	          type: 'post',
	          dataType:'json',
	          data: {_token: '{!! csrf_token() !!}', id: id},
	      })
	      .done(function(res) {
	          swal(res.text,res.cls);
	          $("#"+id).hide(1000);
	      })
	      .fail(function() {
	          console.log("error");
	      })
	      .always(function() {
	          loading("stop");
	      }); 
	    })      
  	}
</script>
@endsection