@extends('sarf/pos.layout.master')
@section('content')
<!-- THE ROW END HERE -->
<div class='bg-white p-2 rounded m-2'>
    <div class="rowjustify-content-between p-2 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center p-2">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill"></span>
            <a class='text-decoration-none fw-bold ' href="{{url('/manage_product')}}">{{trans('products')}}  </a> <span class="bi bi-caret-right"></span>
            <span class='text-decoration-none fw-bold' >{{trans('add products')}}</span>
        </div>
    </div>
    <div class='p-3'>
        <form action="{{url('manage_product/save')}}" method="post" enctype="multipart/form-data">
            <input type="hidden" name="_token" value="{{ csrf_token() }}" />
            <div class="row">
                <div class="col-12">
                    @if(session()->has('success'))
                        <div class="bg-success p-2 mt-4 rounded text-white">
                            <span class="input-error">{{ session()->get('success') }}</span>
                        </div>
                    @elseif(session()->has('error'))
                        <div class="bg-danger p-2 mt-4 rounded text-white">
                            <span class="input-error">{{ session()->get('error') }}</span>
                        </div>
                    @endif
                </div>
                <div class="col-md-6">
                    <div class="mb-3 font-text">
                        <label for="category_id" class="form-label label">Category</label>
                        <select  id="category_id" class="form-select rounded-pill bg-light cat @error('category_id') is-invalid @enderror" name="category_id">
                            <option value="">Select</option>
                            @foreach($category_list as $value)
                            <option value="{{$value->id}}">
                                @if (Session::get('locale') == "ar")
                                    {{$value->name_ar}}
                                @else
                                    {{$value->name_en}}
                                @endif
                            </option>
                            @endforeach
                        </select>
                        @error('category_id') 
                            <span class="text-danger alert-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                    <div class="mb-3 font-text">
                        <label for="name" class="form-label">{{ trans('admin.name') }}</label>
                        <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('name') is-invalid @enderror" id="name" name="name" placeholder="{{ trans('admin.name') }}" aria-describedby="emailHelp">
                        @error('name') 
                            <span class="text-danger alert-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                    <div class="mb-3 font-text">
                        <label for="price" class="form-label">{{ trans('admin.price') }}</label>
                        <input type="number" class="form-control rounded-pill bg-light_c border-0 @error('price') is-invalid @enderror" id="price" name="price" placeholder="{{ trans('admin.price') }}" aria-describedby="emailHelp">
                        @error('price') 
                            <span class="text-danger alert-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                    <div class="mb-3 font-text">
                        <label for="barcode" class="form-label">{{ trans('admin.barcode') }}</label>
                        <input type="number" class="form-control rounded-pill bg-light_c border-0 @error('barcode') is-invalid @enderror" id="barcode" name="barcode" placeholder="{{ trans('admin.barcode') }}" aria-describedby="emailHelp">
                        @error('barcode') 
                            <span class="text-danger alert-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                    <!-- switch end  -->
                    <div class="d-flex justify-content-between py-3">
                        <label for="status" class="ms-2 mb-1">{{ trans('admin.status') }}</label>
                        <label class="switch">
                            <input type="checkbox" name="status" id="status" value="1">
                            <div class="slider round">
                                <!--ADDED HTML -->
                                <span class="on">{{ trans('admin.on') }}</span>
                                <span class="off">{{ trans('admin.off') }}</span>
                            </div>
                        </label>
                    </div>
                    <!-- switch end  -->
                </div>
            </div>
            <button type='sumbit' class='btn  btn-color rounded-pill text-light px-5 mt-3 '>{{ trans('admin.add') }}</button>
        </form>
    </div>
</div>
@endsection
