@extends('sarf/pos.layout.master')
@section('content')
<!-- THE ROW END HERE -->
<div class='bg-white p-2 rounded m-2'>
    <div class="rowjustify-content-between p-2 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center p-2">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill"></span>
            <a class='text-decoration-none fw-bold ' href="{{url('/manage_category')}}">{{trans('category')}}  </a> <span class="bi bi-caret-right"></span>
            <span class='text-decoration-none fw-bold' >{{trans('add category')}}</span>
        </div>
    </div>
    <div class='p-3'>
        <form action="{{url('manage_category/save')}}" method="post" enctype="multipart/form-data">
            <input type="hidden" name="_token" value="{{ csrf_token() }}" />
            <div class="row">
                <div class="col-12">
                    @if(session()->has('success'))
                        <div class="bg-success p-2 mt-4 rounded text-white">
                            <span class="input-error">{{ session()->get('success') }}</span>
                        </div>
                    @elseif(session()->has('error'))
                        <div class="bg-danger p-2 mt-4 rounded text-white">
                            <span class="input-error">{{ session()->get('error') }}</span>
                        </div>
                    @endif
                </div>
                <div class="col-md-6">
                    <div class="mb-3 font-text">
                        <label for="name_en" class="form-label">{{ trans('admin.name') }}</label>
                        <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('name_en') is-invalid @enderror" id="name_en" name="name_en" placeholder="{{ trans('admin.name') }}" aria-describedby="emailHelp">
                        @error('name_en') 
                            <span class="text-danger alert-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                    <div class="mb-3 font-text">
                        <label for="name_ar" class="form-label">{{ trans('admin.name_ar') }}</label>
                        <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('name_ar') is-invalid @enderror" id="name_ar" name="name_ar" placeholder="{{ trans('admin.name') }}" aria-describedby="emailHelp">
                        @error('name_ar') 
                            <span class="text-danger alert-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                    <!-- switch end  -->
                    <div class="d-flex justify-content-between py-3">
                        <label for="status" class="ms-2 mb-1">{{ trans('admin.status') }}</label>
                        <label class="switch">
                            <input type="checkbox" name="status" id="status" value="1">
                            <div class="slider round">
                                <!--ADDED HTML -->
                                <span class="on">{{ trans('admin.on') }}</span>
                                <span class="off">{{ trans('admin.off') }}</span>
                            </div>
                        </label>
                    </div>
                    <!-- switch end  -->
                </div>
            </div>
            <button type='sumbit' class='btn  btn-color rounded-pill text-light px-5 mt-3 '>{{ trans('admin.add') }}</button>
        </form>
    </div>
</div>
@endsection
