@extends('sarf/pos.layout.master')
@section('content')
<section>
    <form action="{{url('/pos/generate_invoice')}}" method="post" enctype="multipart/form-data">
    <input type="hidden" name="_token" value="{{ csrf_token() }}" />
    <input type="hidden" id="invoice_id" name="invoice_id" value="{{$data['inv_id']}}">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-5 bg-light">
                <div class="font-text input-group input-group-sm">
                    <div class="input-group-text">Select Member <i class="bi-arrow-right"></i></div>
                    <select class="form-select" name="member_id" id="member_id">
                        <option value="">Select</option>
                        @foreach($data['members_list'] as $value)
                        <option value="{{$value->user_id}}" @if($data['user_id'] == $value->user_id) selected @endif>
                            {{$value->name}}
                        </option>
                        @endforeach
                    </select>
                    <button type="button" class="btn btn-danger" onclick="deleteMember()"><i class="bi bi-x"></i></button>
                </div>
                {{-- for main area --}}
                <div style="height:80%; overflow: auto !important;">
                    <div class="mb-1 tabale-responsive ">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Unit</th>
                                    <th width="80px">Qty</th>
                                    <th>Price</th>
                                    <th>Amount</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody id="tbody">
                                @php $total_amount=$discount=$itemDiscount=$net_amount=0; @endphp
                                @foreach($data['cart_items'] as $row)
                                    @php
                                        $total_amount += $row->amount;
                                        $itemDiscount += $row->discount;
                                    @endphp
                                    <tr id="row_{{$row->product_id}}">
                                        <td>
                                            <input type="hidden" id="product_id" name="product_id" value="{{$row->product_id}}">
                                            {{$row->name}}
                                        </td>
                                        <td>{{$row->unit}}</td>
                                        <td>{{$row->qty}}</td>
                                        <td>{{$row->price}}</td>
                                        <td>{{$row->amount}}</td>
                                        <td>
                                            <i class="bi-trash text-danger" onclick="destroy({{$row->product_id}}, {{$data['inv_id']}})"></i> 
                                            <i class="bi-pencil text-success" onclick="edit({{$row->product_id}}, {{$data['inv_id']}})"></i>
                                        </td>
                                    </tr>
                                @endforeach
                                @if($total_amount>0)
                                    @php 
                                        $net_amount=($total_amount+$data['tax_value'])-$itemDiscount;
                                    @endphp
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
                {{-- for genrate button area --}}
                <div class="fixed bg-light p-2">
                    <div class="mb-3">
                        <input type="text" class="form-control" id="extra_discount" name="extra_discount" placeholder="Add extra discount">
                    </div>
                    <div class="mb-3 tabale-responsive">
                        <table class="table">
                            <tr class="text-muted">
                                <td>Total</td>
                                <td>Discount</td>
                                <td>Tax</td>
                                <td>Net Total</td>
                            </tr>
                            <tr class="">
                                <th><span id="total">{{$total_amount}}</span> <input type="hidden" value="{{$total_amount}}" id="total_val" name="total_amount"></th>
                                <th><span id="discount">{{$itemDiscount}}</span> <input type="hidden" value="{{$itemDiscount}}" id="discount_val" name="discount"></th>
                                <th><span id="tax">{{$data['tax_value']}}</span> <input type="hidden" value="{{$data['tax_value']}}" id="tax_val" name="tax_total"></th>
                                <th><span id="net_total">{{$total_amount+$data['tax_value']}}</span> <input type="hidden" value="{{$net_amount}}" id="net_total_val" name="net_amount"></th>
                            </tr>
                        </table>
                    </div>
                    <div class="mb-3">
                        <textarea type="text" class="form-control" id="note" name="note" placeholder="Note" rows="5"></textarea>
                    </div>
                    <div class="mb-2 d-flex">
                        <button type="submit" class="btn btn-warning rounded-fill" >Generate</button>
                        <button class="btn btn-outline-warning rounded-fill">Cancel</button>
                    </div>
                </form>
                </div>
            </div>
            <div class="col-md-7">
                <div class="font-text input-group input-group-sm">
                    <div class="input-group-text">Product Search <i class="bi-arrow-right"></i></div>
                    <input type="text" class="form-control w-50" id="product" name="product" placeholder="Search">
                    <a href="{{url('/manage_category')}}" class="btn btn-outline-success">Add categories</a>
                    <a href="{{url('/manage_product')}}" class="btn btn-outline-success">Add products</a>
                </div>
                <div class="row">
                    @foreach ($data['products_list'] as $item)
                    <div class="col-md-2 col-sm-4 col-6 p-sm-1 pr-0 mb-2" data-bs-toggle="modal" data-bs-target="#itemModal{{$item->id}}">
                        <div class="card group-widget ms-lg-2">
                            <img class="card-img-top p-1" src="{{asset('project/sv.png')}}" alt="Product Image">
                            <div class="card-footer p-1">
                                <small class="font-weight-bold">{{$item->id}} - {{$item->name}}</small>
                            </div>
                        </div>
                    </div>
                    {{-- modales for item adding --}}
                    <div class="modal fade rounded" id="itemModal{{$item->id}}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content" style="background-color:transparent">
                                <div class="p-2 bg-white rounded">
                                    <div class='cross'>
                                        <button type="button" class="border-0  cancel_icon" data-bs-dismiss="modal" style="background-color: ">
                                            <i class="bi bi-x"></i>
                                        </button>
                                    </div>
                                    <div class='p-4'>
                                        <form id="itemForm{{$item->id}}" method="POST" enctype="multipart/form-data">
                                            <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                                            <input type="hidden" name="product_id" value="{{$item->id}}" />
                                            <input type="hidden" name="invoice_main_id" value="{{$data['inv_id']}}" />
                                            <div class="row">
                                                <div class="col-12 text-center">
                                                    <div class="mb-3 font-text">
                                                        <label for="product_name" class="form-label label">Product Name</label>
                                                        <input type="hidden" name="product_name" id="product_name" value="{{$item->name}}" />
                                                        <h3>{{$item->name}}</h3>

                                                        <label for="product_name" class="form-label label">Price</label>
                                                        <h3>{{$item->price}}</h3>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3 font-text">
                                                        <input type="number" name="quantity" id="quantity" class="form-control rounded-pill bg-light_c border-0" value="1" />
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="mb-3 font-text">
                                                        <select  id="unit" class="form-select rounded-pill bg-light cat" name="unit">
                                                            <option value="Pcs">Pcs</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="mb-3 font-text">
                                                        <input type="number" name="price" id="price" class="form-control rounded-pill bg-light_c border-0" value="{{$item->price}}" />
                                                    </div>
                                                    <div class="mb-3 font-text">
                                                        <input type="hidden" name="offer_id" value="" />
                                                    </div>
                                                </div>
                                            </div>
                                            <button type='button' onclick="addProduct({{$item->id}})" class='btn  btn-color rounded-pill text-light px-5 mt-3 '>{{ trans('admin.add') }}</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
    {{-- modales for item adding --}}
    <div class="modal fade rounded" id="itemUpForm" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content" style="background-color:transparent">
                <div class="p-2 bg-white rounded">
                    <div class='cross'>
                        <button type="button" class="border-0  cancel_icon" data-bs-dismiss="modal" style="background-color: ">
                            <i class="bi bi-x"></i>
                        </button>
                    </div>
                    <div class='p-4' id="box_edit">
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- edit form end --}}
</section>
<script>
$(document).ready(function () {
    $("#sidebar").addClass('barhide');
    $("#content").addClass('barhide');
});

$('body').on('change','#member_id',function(e){
    e.preventDefault();
    loading('start');
    var id = $("#member_id").val();
    if (id != "") {
      $.ajax({
          url: '{{url("/pos/invoice_member_add")}}/'+id,
          type: 'get',
          dataType:'json',
      })
      .done(function (res) {
        swal(res.text,res.cls);
        window.location.reload();
      })
      .fail(function () {
        console.log("error");
      }).always(function(){
        loading("stop");
      });
    }
  });
  
  $('body').on('change','#extra_discount',function(e){
    e.preventDefault();
    loading('start');
    var exDiscount = $("#extra_discount").val();
    var net_total = $("#net_total_val").val();
    if (exDiscount != "" && net_total != "") {
      $.ajax({
          url: '{{url("/pos/extraDiscount")}}',
          data: {_token: '{!! csrf_token() !!}', exDiscount:exDiscount, net_total:net_total},
          type: 'post',
          dataType:'json',
      })
      .done(function (res) {
        $("#net_total").html(res.net_total);
        $("#net_total_val").val(res.net_total);
      })
      .fail(function () {
        console.log("error");
      }).always(function(){
        loading("stop");
      });
    }else{
        loading("stop");
    }
  });

  function addProduct(id){
    loading('start');
    var form_data = new FormData(document.getElementById('itemForm'+id));
    $.ajax({
        url: '{{route("invoice_product_add")}}',
        data: form_data,
        contentType: false,
        processData: false,
        cache: false,
        type:'POST',
        dataType: 'json',
    })
    .done(function (res) {
        swal(res.text, res.cls);
        window.location.reload();
        loading('stop');
    })
    .fail(function () {
    console.log("error");
    }).always(function(){
    loading("stop");
    });
  }
  
  function destroy(id, inv_id) {
    bootbox.confirm("{{trans('admin.Are_you_sure')}}", function(result){
        loading();
        $.ajax({
            url: '{{url("/pos/item_destroy")}}/'+id+'/'+inv_id,
            type: 'get',
            dataType:'json',
        })
        .done(function(res) {
            swal(res.text,res.cls);
            $("#row_"+id).hide(1000);
            window.location.reload();
        })
        .fail(function() {
            console.log("error");
        })
        .always(function() {
            loading("stop");
        }); 
    });   
}

function deleteMember() {
    //var id = $("#member_id").val();
    loading();
    $.ajax({
        url: '{{url("/pos/member_destroy")}}',
        type: 'get',
        dataType:'json',
    })
    .done(function(res) {
        swal(res.text,res.cls);
        window.location.reload();
    })
    .fail(function() {
        console.log("error");
    })
    .always(function() {
        loading("stop");
    });   
}

function edit(id, inv_id){
  try{
    loading();
    $('#itemUpForm').modal('show');
    //alert(id);
    $.ajax({
      url: '{{url("/pos/edit_item_form")}}',
      data:{
        _token: '{!! csrf_token() !!}',
        id:id, invoice_main_id:inv_id
      },
      type: 'POST',
      cache:false,
      success: function(frm){
        $("#box_edit").html(frm);
        loading("stop");
        },
      error: function(xhr){
        $("#box_edit").html(xhr.status+' '+xhr.statusText);
        loading("stop");
        }
      });
    }catch(e){
      alert(e.message);
    }
  };

  function updateProduct(){
    loading('start');
    var form_data = new FormData(document.getElementById('itemEditForm'));
    $.ajax({
        url: '{{url("/pos/invoice_product_update")}}/',
        data: form_data,
        contentType: false,
        processData: false,
        cache: false,
        type:'POST',
        dataType: 'json',
    })
    .done(function (res) {
        swal(res.text, res.cls);
        window.location.reload();
        loading('stop');
    })
    .fail(function () {
    console.log("error");
    }).always(function(){
    loading("stop");
    });
  }
</script>
<style>
div.fixed {
  position: fixed;
  bottom: 0;
  left: 0;
  width: 620px;
  border: 0.5px solid #73AD21;
  z-index: 500;
}
</style>
@if (session()->has('success'))
    <script>
        swal('', "{{ session()->get('success') }}",'success');
    </script>
@elseif(session()->has('error'))
    <script>
        swal('', "{{ session()->get('error') }}",'error');
    </script>
@endif
@endsection