@extends('admin.layout.master')
@section('content')
@include('sarf/package/package_js')


<main class="container-fluid px-0 mt-2 scroll-y">
    <!-- body content  -->
    <div class="card card-invoice rounded border-0">
      <div class="card-body pt-0">
        <div class="row g-2 justify-content-between align-items-center bg-light px-2 pb-2 border mt-1 mx-0 no-print p-0" id="from_to_date_area">
          <div class="col-md-8">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('sarf.home')}}  </a> <span class="bi bi-caret-right"></span>
            <span class='text-decoration-none fw-bold' >{{trans('sarf.packages')}}</span>  
          </div>
          <div class="d-flex justify-content-between col-lg-4 col-12">
            <div class="col-6 mt-1">
              <input type="text" class="filtertbl form-control form-control-sm" id="search_new" style="min-width:150px;" placeholder="{{trans('sarf.search')}}">
            </div>
            <div class="col-5 mt-1 ml-4">
              <button class="btn btn-success rounded-pill btn-sm px-3" onclick="add_package()">
                {{trans('sarf.add_new')}}
              </button>
            </div>
          </div>
        </div>

        <div class="row">
          <div class="col-lg-12">
            <div class="table-responsive">
              <table class="table w-100 table-sm table-hover mb-0 table-bordered data-table">
                <thead class="bg-light">
                    <tr>
                        <th>{{trans('sarf.id')}}</th>
                        <th>{{trans('sarf.name_en')}}</th>
						 <th>{{trans('sarf.name_ar')}}</th>
                        <th>{{trans('sarf.date')}}</th>
                        <th>{{trans('sarf.amount')}}</th>
                        <th>{{trans('sarf.status')}}</th>
                        <th>{{trans('sarf.action')}}</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
        </div>
      </div>
    </div>
  </div>
</main>
<style>
    .dataTables_filter {
    display: none;
  }
</style>
<script type="text/javascript">
  var table ="";
  $(function () {
    table = $('.data-table').DataTable({
      processing: true,
      serverSide: true,
      ajax: "{{ route('packages_list') }}",
      columns: [
          {data: 'id', name: 'id'},
          {data: 'name_en', name: 'name_en'},
		     {data: 'name_ar', name: 'name_ar'},
          {data: 'duration', name: 'duration'},
          {data: 'amount', name: 'amount'},
          {data: 'status', name: 'status'},
          {data: 'action', name: 'action', orderable: false, searchable: false},
      ],
      "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]]
    });
  });
  $("#search_new").on("keyup search input paste cut", function() {
     table.search(this.value).draw();
  });  
</script>

{!! modelBox("addpackage", trans('sarf.add'),"box","status_msg","add_package") !!}
{!! modelBox("editpackage", trans('sarf.edit'),"box_edit","status_update","update_package") !!}
@endsection