@extends('admin.layout.master')
@section('content')
@include('sarf/expense_type/expense_js')


<main class="container-fluid px-0 mt-2 scroll-y">
    <!-- body content  -->
    <div class="card card-invoice rounded border-0">
      <div class="card-body pt-0">
        <div class="row g-2 align-items-end bg-light px-2 pb-2 border mt-1 mx-0 no-print p-0" id="from_to_date_area">
          <div class="col-lg-8 col-md-4">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('sarf.home')}}  </a> <span class="bi bi-caret-right"></span>
            <span class='text-decoration-none fw-bold' >{{trans('sarf.expense_types')}}</span>  
          </div>
          <div class="d-flex justify-content-between col-lg-4 col-12">
            <div class="col-6 mt-1">
              <input type="text" class="filtertbl form-control form-control-sm" id="search_new" style="min-width:150px;" placeholder="{{trans('sarf.search')}}">
            </div>
            <div class="col-5 mt-1 ml-md-auto">
              <button class="btn btn-success rounded-pill btn-sm px-3" onclick="add_category()">
                {{trans('sarf.add_new')}}
              </button>
            </div>
          </div>
          
        </div>

        <div class="row">
          <div class="col-lg-12">
            <div class="table-responsive">
              <table class="table w-100 table-sm table-hover mb-0 table-bordered data-table">
                <thead class="bg-light">
                    <tr>
                        <th>{{trans('sarf.id')}}</th>
                        <th>{{trans('sarf.expense_name')}}</th>
                        <th>{{trans('sarf.expense_name_ar')}}</th>
                        <th>{{trans('sarf.color')}}</th>
                        <th>{{trans('sarf.status')}}</th>
                        <th>{{trans('sarf.action')}}</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
        </div>
      </div>
    </div>
  </div>
</main>
<style>
    .dataTables_filter {
    display: none;
  }
</style>
<script type="text/javascript">
  var table ="";
  $(function () {
    table = $('.data-table').DataTable({
      processing: true,
      serverSide: true,
      ajax: "{{ route('exp_type') }}",
      columns: [
          {data: 'id', name: 'id'},
          {data: 'expense_name', name: 'expense_name'},
          {data: 'expense_name_ar', name: 'expense_name_ar'},
          {data: 'color', name: 'color'},
          {data: 'status', name: 'status'},
          {data: 'action', name: 'action', orderable: false, searchable: false},
      ],
      "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]]
    });
  });
  $("#search_new").on("keyup search input paste cut", function() {
     table.search(this.value).draw();
  });  
</script>

{!! modelBox("addcategory", trans('sarf.add'),"box","status_msg","add_category") !!}
{!! modelBox("editcategory", trans('sarf.edit'),"box_edit","status_update","update_category") !!}
@endsection