@extends('admin.layout.master')
@section('content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.min.css">
<!-- <style>
    .card{
        transition:0.2s;
    }
    .card:hover {
        box-shadow: 0 0 11px rgba(33,33,33,.2) !important;
    }
</style> -->
<!-- body content  -->
<div class="card card-dashboard rounded border-0 p-2 bg-light">
	<div class="card-body p-0 p-md-2">
		<div class="p-3 rounded mb-2 clearfix bg-white shadow-sm">
	   		<div class="row align-items-center">
              	<div class="col-md-4">
	                <h3 class="font-500">{{trans('sarf.welcome')}}
	                    <span class="text" style="font-weight:600;">{{$data['username']}}</span>
	                </h3>
	                <a href="{{url('/user_list')}}" class="btn mt-2 rounded-pill px-3 alert-success btn-sm">{{trans('sarf.client_list')}}</a>
	                <a href="{{url('/business_list')}}" class="btn mt-2 rounded-pill px-3 alert-danger btn-sm ml-2">{{trans('sarf.business_list')}}</a>
            	</div>
				<div class="col mt-3 mt-md-0">
					<div class="row row-cols-2 row-cols-md-4 row-cols-sm-2 g-3 align-items-center">
				        <!-- color cards  -->
				        <div class="col ml-auto">
				          <div class="card alert-warning">
				            <div class="card-body clearfix">
				              	<div class="card-icon float-right">
				                	<i class="bi-people" style="font-size: 2.3em"></i>
				            	</div>
					            <h5 class="card-title font-weight-bold">
					                <a  class="text-warning no-deco" href="{{url('/user')}}">{{$data['dataCount1']}}</a>
					            </h5>
				                <p class="card-text font-weight-bold">{{trans('sarf.clients')}}</p>
				            </div>
				            </div>
				        </div>

					    <div class="col">
					      	<div class="card alert-danger">
						        <div class="card-body">
						          	<div class="card-icon float-right">
						            	<i class="bi-layers" style="font-size: 2.3em"></i>
							        </div>
							        <h5 class="card-title font-weight-bold">
							          <a class="text-danger no-deco" href="{{url('/user')}}">{{$data['dataCount2']}}</a>
							    	</h5>
							    	<p class="card-text font-weight-bold">{{trans('sarf.business')}}</p>
								</div>
							</div>
						</div>

				        <div class="col">
				          	<div class="card alert-success">
				                <div class="card-body">
				                  	<div class="card-icon float-right">
				                    	<i class="bi-people" style="font-size: 2.3em"></i>
				                	</div>
				                	<h5 class="card-title font-weight-bold">
				                 		<a class="text-success no-deco" href="{{url('/user')}}">{{$data['dataCount3']}}</a>
				             		</h5>
				                 	<p class="card-text font-weight-bold">{{trans('sarf.admin_Users')}}</p>
				             	</div>
				     		</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- <div class="row row-cols-sm-1 g-2 row-cols-md-2 row-cols-lg-3">
		    <!-- graph 1 --
		    <div class="col h-100">
		        <div class="card shadow-sm border-0">
		          	<div class="card-header border-0 bg-white d-flex justify-content-between align-items-center py-1 px-1">
			            <p class="smal mb-0 pl-2"> Encome Expense </p>
			            <button type="button" class="btn btn-white px-1 py-0" id="btn-collapse" data-toggle="collapse" data-target="#graph1" aria-expanded="false" aria-controls="graph1">
			                <i class="fa fa-chevron-down"></i>
			            </button>
			        </div>

			        <div id="graph1" class="collapse show" role="alert">
			            <div class="card-body">

			              <canvas id="incomeTax"></canvas>

			          </div>
			      	</div>
			  	</div>
			</div>

			<!-- graph 2 --
			<div class="col h-100">
			    <div class="card shadow-sm border-0">
			      	<div class="card-header border-0 bg-white d-flex justify-content-between align-items-center py-1 px-1">
				        <p class="smal mb-0 pl-2"> Sale Recovery </p>
				        <button type="button" class="btn btn-white px-1 py-0" id="btn-collapse" data-toggle="collapse" data-target="#graph2" aria-expanded="false" aria-controls="graph2">
				            <i class="fa fa-chevron-down"></i>
				        </button>
			    	</div>

				    <div id="graph2" class="collapse show">
				        <div class="card-body">
				            <canvas id="customerSales"></canvas>
				        </div>
				    </div>
				</div>
			</div>

			<!-- graph 3 --
			<div class="col h-100">
			    <div class="card shadow-sm border-0">
			        <div class="card-header border-0 bg-white d-flex justify-content-between align-items-center py-1 px-1">
			          <p class="smal mb-0 pl-2">expenses trend</p>
			          <button type="button" class="btn btn-white px-1 py-0" id="btn-collapse" data-toggle="collapse" data-target="#graph3" aria-expanded="false" aria-controls="graph3">
			              <i class="fa fa-chevron-down"></i>
			          </button>
				      </div>

				      <div id="graph3" class="collapse show">
				          <div class="card-body">

				            <canvas id="expenseBreakdown" ></canvas>

				        </div>
				    </div>
				</div>
			</div>
		</div> --> <!-- rows-cols end -->

		<div class="row g-2" id="dash-card2">
            <div class="col-md-4">
                <div class="card shadow-sm border-0 pt-3 mb-2">
                    <div class="card-header border-0 bg-white py-1 d-flex align-items-center pl-3">
                        <h6 class="p-2 alert-warning text-warning rounded-circle ">
                            <i class="bi bi-people" style="font-size: 2.3em"></i>
                        </h6>
                        <h4 class="mb-0 pl-2 text-warning">{{trans('sarf.clients')}}</h4>
                    </div>
                    <div class="card-body px-0">
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('sarf.total')}}
                                <span class="badge alert-success rounded-pill py-2 px-3">{{$data['dataCount1']}}</span>
                            </li>
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('sarf.active')}}
                                <span class="badge alert-warning rounded-pill py-2 px-3">{{$data['dataCount1_active']}}</span>
                            </li>
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('sarf.inactive')}}
                                <span class="badge alert-danger rounded-pill py-2 px-3">{{$data['dataCount1_unactive']}}</span>
                            </li>
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('sarf.deleted')}}
                                <span class="badge alert-primary rounded-pill py-2 px-3">{{$data['dataCount1_deleted']}}</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card shadow-sm border-0 pt-3 mb-2">
                    <div class="card-header border-0 bg-white py-1 d-flex align-items-center pl-3">
                        <h6 class="p-2 alert-danger text-danger rounded-circle align-self-center">
                        	<i class="bi-layers" style="font-size: 2.3em"></i>
                        </h6>
                        <h4 class="mb-0 pl-2 text-danger">{{trans('sarf.business')}}</h4>
                    </div>
                    <div class="card-body px-0">
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('sarf.total')}}
                                <span class="badge alert-success rounded-pill py-2 px-3">{{$data['dataCount2']}}</span>
                            </li>
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('sarf.active')}}
                                <span class="badge alert-warning rounded-pill py-2 px-3">{{$data['dataCount2_active']}}</span>
                            </li>
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('sarf.inactive')}}
                                <span class="badge alert-danger rounded-pill py-2 px-3">{{$data['dataCount2_unactive']}}</span>
                            </li>
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('sarf.deleted')}}
                                <span class="badge alert-primary rounded-pill py-2 px-3">{{$data['dataCount2_deleted']}}</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card shadow-sm border-0 pt-3 mb-2">
                    <div class="card-header border-0 bg-white py-1 d-flex align-items-center pl-31">
                        <h6 class="p-2 alert-success text-success rounded-circle align-self-center">
                        	<i class="bi bi-people" style="font-size: 2.3em"></i>
                        </h6>
                        <h4 class="mb-0 pl-2 text-success">{{trans('sarf.admin_Users')}}</h4>
                    </div>
                    <div class="card-body px-0">
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('sarf.total')}}
                                <span class="badge alert-success rounded-pill py-2 px-3">{{$data['dataCount3']}}</span>
                            </li>
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('sarf.active')}}
                                <span class="badge alert-warning rounded-pill py-2 px-3">{{$data['dataCount3_active']}}</span>
                            </li>
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('sarf.inactive')}}
                                <span class="badge alert-danger rounded-pill py-2 px-3">{{$data['dataCount3_unactive']}}</span>
                            </li>
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('sarf.deleted')}}
                                <span class="badge alert-primary rounded-pill py-2 px-3">{{$data['dataCount3_deleted']}}</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

		<div class="row g-2">
            <div class="col-md-4">
                <div class="card shadow-sm border-0 p-3 mb-2">
                    <div class="card-header border-0 bg-white py-1  px-1">
                        <h4 class="mb-0 pl-1 mt-3">{{trans('sarf.new_clients')}}</h4>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive table-scroll p-0" style="min-height: 185px; max-height: 185;">
                            <table class="table table-success  table-sm table-hover mb-0 table-bordered">
                                <thead>
                                    <tr class="text-center">
                                        <th class="text-lowercase">{{trans('sarf.id')}}</th>
                                        <th class="text-left">{{trans('sarf.name')}}</th>
                                        <th class="text-left">{{trans('sarf.mobile')}}</th>
                                        <th class="text-left">{{trans('sarf.email')}}</th>
                                    </tr>
                                </thead>
                                <tbody class="text-center" id="entries">
                                    @php $counter=0; @endphp
                                    @foreach($data['post1'] as $row)
                                    	<tr id="{{$row->id}}">
                                    		<td>{{$counter+=1}}</td>
                                    		<td>{{$row->username}}</td>
                                    		<td>{{$row->mobile}}</td>
                                    		<td>{{$row->email}}</td>
                                    	</tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card shadow-sm border-0 p-3 mb-2">
                    <div class="card-header border-0 bg-white py-1  px-1">
                        <h4 class="mb-0 pl-1 mt-3">{{trans('sarf.new_business')}}</h4>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive table-scroll p-0" style="min-height: 185px; max-height: 185;">
                            <table class="table table-danger table-sm table-hover mb-0 table-bordered">
                                <thead>
                                    <tr class="text-center">
                                        <th class="text-lowercase">{{trans('sarf.id')}}</th>
                                        <th class="text-left">{{trans('sarf.name')}}</th>
                                        <th class="text-left">{{trans('sarf.mobile')}}</th>
                                        <th class="text-left">{{trans('sarf.email')}}</th>
                                    </tr>
                                </thead>
                                <tbody class="text-center" id="entries">
                                    @php $counter=0; @endphp
                                	@foreach($data['post2'] as $row)
                                    	<tr id="{{$row->id}}">
                                    		<td>{{$counter+=1}}</td>
                                    		<td>{{$row->username}}</td>
                                    		<td>{{$row->mobile}}</td>
                                    		<td>{{$row->email}}</td>
                                    	</tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card shadow-sm border-0 p-3 mb-2">
                    <div class="card-header border-0 bg-white py-1  px-1">
                        <h4 class="mb-0 pl-1 mt-3">{{trans('sarf.new_admin_users')}}</h4>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive table-scroll p-0" style="min-height: 185px; max-height: 185;">
                            <table class="table table-warning table-sm table-hover mb-0 table-bordered">
                                <thead>
                                    <tr class="text-center">
                                        <th class="text-lowercase">{{trans('sarf.id')}}</th>
                                        <th class="text-left">{{trans('sarf.name')}}</th>
                                        <th class="text-left">{{trans('sarf.mobile')}}</th>
                                        <th class="text-left">{{trans('sarf.email')}}</th>
                                    </tr>
                                </thead>
                                <tbody class="text-center" id="entries">
                                    @php $counter=0; @endphp
                                    @foreach($data['post3'] as $row)
                                    	<tr id="{{$row->id}}">
                                    		<td>{{$counter+=1}}</td>
                                    		<td>{{$row->name}}</td>
                                    		<td>{{$row->mobile}}</td>
                                    		<td>{{$row->email}}</td>
                                    	</tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
	</div> <!-- card body end -->
</div> <!-- Card end -->
	
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.min.js"></script>
<script>
    var ctx = document.getElementById('incomeTax');
    var myChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: [],
            datasets: [{
                label: 'Income',
                data: [],
                backgroundColor: [
                'rgba(54, 162, 235, 0.2)',
                'rgba(54, 162, 235, 0.2)',
                'rgba(54, 162, 235, 0.2)',
                'rgba(54, 162, 235, 0.2)',
                'rgba(54, 162, 235, 0.2)',
                'rgba(54, 162, 235, 0.2)'
                ],
                borderColor: [
                'rgba(54, 162, 235, 1)',
                'rgba(54, 162, 235, 1)',
                'rgba(54, 162, 235, 1)',
                'rgba(54, 162, 235, 1)',
                'rgba(54, 162, 235, 1)',
                'rgba(54, 162, 235, 1)'
                ],
                borderWidth: 1
            },{
                label: 'Expense',
                data: [],
                backgroundColor: [
                'rgba(255, 99, 132, 0.2)',
                'rgba(255, 99, 132, 0.2)',
                'rgba(255, 99, 132, 0.2)',
                'rgba(255, 99, 132, 0.2)',
                'rgba(255, 99, 132, 0.2)',
                'rgba(255, 99, 132, 0.2)'
                ],
                borderColor: [
                'rgba(255, 99, 132, 1)',
                'rgba(255, 99, 132, 1)',
                'rgba(255, 99, 132, 1)',
                'rgba(255, 99, 132, 1)',
                'rgba(255, 99, 132, 1)',
                'rgba(255, 99, 132, 1)'
                ],
                borderWidth: 1
            }]
        }
        // ,
        // options: {
        //     scales: {
        //         yAxes: [{
        //             ticks: {
        //                 beginAtZero: false
        //             }
        //         }]
        //     }
        // }
    });
    
    var ctx = document.getElementById('expenseBreakdown');
    var myChart = new Chart(ctx, {
        type: 'pie',
        options: {
            legend: {
                position: 'right',
            },
        },
        data: {
            labels: [],
            datasets: [{
                data: [],
                backgroundColor: [
                'rgba(255, 99, 132, 0.2)',
                'rgba(54, 162, 235, 0.2)',
                'rgba(255, 206, 86, 0.2)',
                'rgba(75, 192, 192, 0.2)',
                'rgba(153, 102, 255, 0.2)',
                'rgba(255, 159, 64, 0.2)',
                'rgba(42, 157, 143, 0.2)',
                'rgba(62, 31, 71, 0.2)'
                ],
                borderColor: [
                'rgba(255, 99, 132, 1)',
                'rgba(54, 162, 235, 1)',
                'rgba(255, 206, 86, 1)',
                'rgba(75, 192, 192, 1)',
                'rgba(153, 102, 255, 1)',
                'rgba(255, 159, 64, 1)',
                'rgba(42, 157, 143, 1)',
                'rgba(62, 31, 71, 1)'
                ],
                borderWidth: 1
            }]
        }
    });


    var ctx = document.getElementById('customerSales');
    var myChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: [],
            datasets: [{
                label: 'Sale',
                data: [],
                backgroundColor: [
                'rgba(255, 99, 132, 0.2)',
                'rgba(255, 99, 132, 0.2)',
                'rgba(255, 99, 132, 0.2)',
                'rgba(255, 99, 132, 0.2)',
                'rgba(255, 99, 132, 0.2)',
                'rgba(255, 99, 132, 0.2)'
                ],
                borderColor: [
                'rgba(255, 99, 132, 1)',
                'rgba(255, 99, 132, 1)',
                'rgba(255, 99, 132, 1)',
                'rgba(255, 99, 132, 1)',
                'rgba(255, 99, 132, 1)',
                'rgba(255, 99, 132, 1)'
                ],
                borderWidth: 1
            },
            {
                label: 'Recovery',
                data: [],
                backgroundColor: [
                'rgba(54, 162, 235, 0.2)',
                'rgba(54, 162, 235, 0.2)',
                'rgba(54, 162, 235, 0.2)',
                'rgba(54, 162, 235, 0.2)',
                'rgba(54, 162, 235, 0.2)',
                'rgba(54, 162, 235, 0.2)'
                ],
                borderColor: [
                'rgba(54, 162, 235, 1)',
                'rgba(54, 162, 235, 1)',
                'rgba(54, 162, 235, 1)',
                'rgba(54, 162, 235, 1)',
                'rgba(54, 162, 235, 1)',
                'rgba(54, 162, 235, 1)'
                ],
                borderWidth: 1
            }]
        },

        options: {
            scales: {
                yAxes: [{
                    ticks: {
                        beginAtZero: true
                    }
                }]
            }
        }
    });
</script>
@endsection