@extends('admin.layout.master')
@section('content')
<!-- THE ROW END HERE -->
<div class='bg-white p-2 rounded m-2'>
    <div class="rowjustify-content-between p-2 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center p-2">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill"></span>
            <a class='text-decoration-none fw-bold ' href="{{url('/vendor_sliders')}}">{{trans('admin.vendor sliders')}}  </a> <span class="bi bi-caret-right"></span>
            <span class='text-decoration-none fw-bold' >{{trans('admin.add_slider')}}</span>
        </div>
    </div>
    <div class='p-3'>
        <form action="{{route('update_vendor_slider')}}" method="post" enctype="multipart/form-data">
            <input type="hidden" name="_token" value="{{ csrf_token() }}" />
            <input type="hidden" name="id" value="{{ $post->id }}" />
            <div class="row">
                <div class="col-12">
                    @if (session()->has('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session()->get('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @elseif(session()->has('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session()->get('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                </div>
                <div class="col-md-6">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3 font-text">
                                <label for="vendor_id" class="form-label label">{{trans('vendors')}}</label>
                                <select  id="vendor_id" class="form-select rounded-pill bg-light cat @error('vendor_id') is-invalid @enderror" name="vendor_id">
                                    <option value="">Select</option>
                                    @foreach($vdata as $data)
                                        <option value="{{$data->user->id}}"  @if($post->vendor_id == $data->user->id) selected @endif>{{$data->user->name}}</option>
                                    @endforeach
                                </select>
                                @error('vendor_id') 
                                    <span class="text-danger">{{ $message }}</span> 
                                @enderror                                
                            </div>
                        </div>
                        <div class="col-md-4">
                            <!-- switch start  -->
                            <div class="d-flex justify-content-between py-3 ">
                                <label for="status" class="ms-2 mb-1">{{ trans('admin.status') }}</label>
                                <label class="switch">
                                    <input type="checkbox" name="status" id="status" value="1" @if($post->status == 1) checked @endif>
                                    <div class="slider round">
                                        <!--ADDED HTML -->
                                        <span class="on">{{ trans('admin.on') }}</span>
                                        <span class="off">{{ trans('admin.off') }}</span>
                                    </div>
                                </label>
                            </div>
                            <!-- switch end  -->
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="container mt-lg-2 pt-3 ">
                        <label class="upload-btn-wrapper bg-light_c" for="file">
                            <img src="{{ asset('images/vendor_sliders/'.$post->photo) }}" class="img-fluid" alt="" id="preview">
                            <span class=" p-1 text-start"><i class="bi bi-camera pe-1"></i>Click Here</span>
                            @error('photo') 
                            <br><span class="text-danger">{{ $message }}</span> 
                            @enderror
                        </label>
                        <input type="file" name="photo" id="file" class="d-none  bg-light_c" onchange="itemname(event)" />
                    </div>
                </div>
            </div>
            <button type='sumbit' class='btn  btn-color rounded-pill text-light px-5 mt-3 '>{{ trans('admin.add') }}</button>
        </form>
    </div>
</div>
</div>
<script>
    function itemname(event) {
        var preview = document.getElementById("preview");
        preview.src = URL.createObjectURL(event.target.files[0]);
    }
</script>
@endsection
