@extends('admin.layout.master')
@section('content')
<!-- THE ROW END HERE -->
<div class='bg-white p-2 rounded m-2'>
    <div class="rowjustify-content-between p-2 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center p-2">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill"></span>
            <a class='text-decoration-none fw-bold ' href="{{url('/promotion_sliders')}}">{{trans('admin.promotion sliders')}}  </a> <span class="bi bi-caret-right"></span>
            <span class='text-decoration-none fw-bold' >{{trans('admin.edit_slider')}}</span>
        </div>
    </div>
    <div class='p-3'>
        <form action="{{route('update_promotion_slider')}}" method="post" enctype="multipart/form-data">
            <input type="hidden" name="_token" value="{{ csrf_token() }}" />
            <input type="hidden" name="id" value="{{ $post->id }}" />
            <div class="row">
                <div class="col-12">
                    @if (session()->has('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session()->get('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @elseif(session()->has('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session()->get('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                </div>
                <div class="col-md-9">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3 font-text">
                                <label for="vendor_id" class="form-label label">{{trans('vendors')}}</label>
                                <select  id="vendor_id" class="form-select rounded-pill bg-light cat @error('vendor_id') is-invalid @enderror" name="vendor_id">
                                    <option value="">Select</option>
                                    @foreach($vendors as $data)
                                        <option value="{{$data->user->id}}" @if($post->vendor_id==$data->user->id) selected @endif>{{$data->user->name}}</option>
                                    @endforeach
                                </select>
                                @error('vendor_id') 
                                    <span class="text-danger">{{ $message }}</span> 
                                @enderror                                
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3 font-text">
                                <label for="item_id" class="form-label label">{{trans('items')}}</label>
                                <select  id="item_id" class="form-select rounded-pill bg-light cat @error('item_id') is-invalid @enderror" name="item_id">
                                    <option value="">Select</option>
                                    @foreach($items as $data)
                                        <option value="{{$data->id}}" @if($post->item_id == $data->id) selected @endif>
                                            @if (Session::get('locale')=='ar')
                                                {{$data->item_name_ar}}
                                            @else
                                                {{$data->item_name_en}}
                                            @endif
                                        </option>
                                    @endforeach
                                </select>
                                @error('item_id') 
                                    <span class="text-danger">{{ $message }}</span> 
                                @enderror                                
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3 font-text">
                                <label for="type" class="form-label label">{{trans('type')}}</label>
                                <select  id="type" class="form-select rounded-pill bg-light cat @error('type') is-invalid @enderror" name="type">
                                    <option value="">Select</option>
                                    <option value="1" @if($post->type == 1) selected @endif>Restuarent</option>
                                    <option value="2" @if($post->type == 2) selected @endif>Item</option>
                                </select>
                                @error('type') 
                                    <span class="text-danger">{{ $message }}</span> 
                                @enderror                                
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="mb-3 font-text">
                                <label for="expiry_date" class="form-label">{{ trans('project.expiry') }}</label>
                                <input type="date" class="form-control bg-light_c border-0 @error('expiry_date') is-invalid @enderror" id="expiry_date" name="expiry_date" placeholder="{{ trans('project.expiry') }}" aria-describedby="emailHelp" value="{{$post->expiry_date}}">
                                @error('expiry_date') 
                                    <span class="text-danger">{{ $message }}</span> 
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-4">
                            <!-- switch start  -->
                            <div class="d-flex justify-content-between py-3 ">
                                <label for="status" class="ms-2 mb-1">{{ trans('project.status') }}</label>
                                <label class="switch">
                                    <input type="checkbox" name="status" id="status" value="1" @if($post->status == 1) selected @endif>
                                    <div class="slider round">
                                        <!--ADDED HTML -->
                                        <span class="on">{{ trans('project.on') }}</span>
                                        <span class="off">{{ trans('project.off') }}</span>
                                    </div>
                                </label>
                            </div>
                            <!-- switch end  -->
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="container mt-lg-2 pt-3 ">
                        <label class="upload-btn-wrapper bg-light_c" for="file">
                            <img src="{{ asset('images/promotion_sliders/'.$post->photo) }}" class="img-fluid" alt="" id="preview">
                            <span class=" p-1 text-start"><i class="bi bi-camera pe-1"></i>Click Here</span>
                            @error('photo') 
                            <br><span class="text-danger">{{ $message }}</span> 
                            @enderror
                        </label>
                        <input type="file" name="photo" id="file" class="d-none  bg-light_c" onchange="itemname(event)" />
                    </div>
                </div>
            </div>
            <button type='sumbit' class='btn  btn-color rounded-pill text-light px-5 mt-3 '>{{ trans('admin.update') }}</button>
        </form>
    </div>
</div>
</div>
<script>
    function itemname(event) {
        var preview = document.getElementById("preview");
        preview.src = URL.createObjectURL(event.target.files[0]);
    }
</script>
@endsection
