<!DOCTYPE html>
<html>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Invoice</title>
    <style>
        @font-face { font-family: 'Roboto Regular'; font-weight: normal; src: url('fonts/Roboto-Regular.ttf') format('truetype'); } 
        @font-face { font-family: 'Roboto Bold'; font-weight: bold; src: url('fonts/Roboto-Bold.ttf') format('truetype'); } 
        body{ font-family: 'Roboto Regular', sans-serif; font-weight: normal; line-height:1.6em; font-size:17pt; }
        .invoice-box {
            max-width: 900px;
            margin: auto;
            padding: 10px;
            border: 1px solid #eee;
            font-size: 16px;
            line-height: 24px;
            font-family: 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
            color: #555;
        }

        .invoice-box table {
            width: 100%;
            line-height: inherit;
            text-align: left;
        }

        .invoice-box table td {
            padding: 5px;
            vertical-align: top;
        }

        .invoice-box table tr td:nth-child(2) {
            text-align: right;
        }

        .invoice-box table tr.top table td {
            padding-bottom: 20px;
        }

        .invoice-box table tr.top table td.title {
            font-size: 45px;
            line-height: 45px;
            color: #333;
        }

        .invoice-box table tr.information table td {
            padding-bottom: 40px;
        }

        .invoice-box table tr.heading td {
            background: #eee;
            border-bottom: 1px solid #ddd;
            font-weight: bold;
        }

        .invoice-box table tr.details td {
            padding-bottom: 20px;
        }

        .invoice-box table tr.item td {
            border-bottom: 1px solid #eee;
        }

        .left{
            text-align: left !important;
        }

        .invoice-box table tr.item.last td {
            border-bottom: none;
        }

        .invoice-box table tr.total td:nth-child(2) {
            border-top: 2px solid #eee;
            font-weight: bold;
        }

        @media only screen and (max-width: 600px) {
            .invoice-box table tr.top table td {
                width: 100%;
                display: block;
                text-align: center;
            }

            .invoice-box table tr.information table td {
                width: 100%;
                display: block;
                text-align: center;
            }
        }
    </style>
    
    @if($data['language'] == "ar")
        <style>
            /* RTL */
            /* .invoice-box {
                direction: rtl;
                font-family: Tahoma, 'Helvetica Neue', 'Helvetica', Helvetica, Arial, sans-serif;
            }

            .invoice-box table {
                text-align: right;
            }

            .invoice-box table tr td:nth-child(2) {
                text-align: left;
            } */
            .left{
                text-align: right !important;
            }
        </style>
    @endif
</head>

<body>
<div class="invoice-box">
    <small>
    @if($data['language'] == "en")
        <table cellpadding="0" cellspacing="0">
            <tr class="top">
                <td colspan="4">
                    <table>
                        <tr>
                            <td class="title">
                                @if (getSiteInfo('photo'))
                                <img src="{{asset(getSiteInfo('photo'))}}"  style="width: 150px; max-width: 150px" />
                                @endif                                
                            </td>
                            <td>
                                Invoice: #{{ !empty($data['post']->id) ? $data['post']->id : " " }}<br />

                                Created: {{ !empty($data['post']->created_at) ? $data['post']->created_at : "0000-00-00" }} <br />

                                Date: {{ !empty($data['post']->date) ? $data['post']->date : "0000-00-00" }}
                            </td>
                        </tr>
                        {{-- detail --}}
                        <tr>
                            <td>
                                @if (!empty($data['post']->status))
                                <b>Status: </b>
                                @switch($data['post']->status)
                                    @case(0)
                                        <b style="color: red;">
                                             Cancel 
                                        </b> 
                                        @break
                                    @case(1)
                                        <b style="color: green;">
                                             Active 
                                        </b>
                                        @break
                                    @case(2)
                                        <b style="color: rgb(59, 194, 187);">
                                             Complete 
                                        </b>
                                        @break
                                    @case(3)
                                        <b style="color: rgb(208, 230, 18);">
                                             Pending 
                                        </b>
                                        @break
                                @endswitch
                                @endif
                            </td>

                            <td>
                                @if (isset($data['post']->customer->name) && !empty($data['post']->customer->name))
                                    <b>Customer: </b>
                                    {{ !empty($data['post']->customer->name) ? $data['post']->customer->name : " " }}
                                @else
                                    <b>Vendor:</b> 
                                    {{ !empty($data['post']->vendor->name) ? $data['post']->vendor->name : " " }}
                                @endif
                                <br />

                                <b>Expense type: </b>
                                @if (!empty($data['post']->expense_type))
                                    <span style="color:orange">{{$data['expense_type']}}</span>
                                @endif
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>

            <tr class="top">
                <td colspan="4">
                    <table>
                        <tr>
                            <td style="width: 25rem">
                                <b>Terms & Condition</b><br />
                                <span>
                                    Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam..
                                </span>
                                <br />
                                <br /><br />
                                {{-- <img src="{{asset('project/R.png')}}" alt="qr code here" style="width: 80px; max-width: 100px" /> --}}
                            </td>
                            <td class="total">
                                <b class="left"> Total: {{ !empty($data['post']->total_amount) ? $data['post']->total_amount : 0 }}</b><br />

                                <b class="left"> Discount: {{ !empty($data['post']->discount_invoice) ? $data['post']->discount_invoice : 0 }}</b><br />

                                <b class="left"> Tax: {{ !empty($data['post']->tax) ? $data['post']->tax : 0 }}</b><br />

                                <b class="left"> Net Amount: {{ !empty($data['post']->net_total) ? $data['post']->net_total : 0 }}</b>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
    @else
    <table cellpadding="0" cellspacing="0">
        <tr class="top">
            <td colspan="4">
                <table>
                    <tr>
                        <td>
                            Invoice_بيمن: #{{ !empty($data['post']->id) ? $data['post']->id : " " }}<br />

                            Created-ar: {{ !empty($data['post']->created_at) ? $data['post']->created_at : "0000-00-00" }}<br />

                            Date: {{ !empty($data['post']->date) ? $data['post']->date : "0000-00-00" }}
                        </td>
                        <td class="title">
                            @if (getSiteInfo('photo'))
                            <img src="{{asset(getSiteInfo('photo'))}}"  style="width: 150px; max-width: 150px" />
                            @endif
                        </td>
                    </tr>
                    {{-- detail --}}
                    <tr>
                        <td>
                            @if (isset($data['post']->customer->name) && !empty($data['post']->customer->name))
                                <b>Customer: </b>
                                {{ !empty($data['post']->customer->name) ? $data['post']->customer->name : " " }}
                            @else
                                <b>Vendor:</b> 
                                {{ !empty($data['post']->vendor->name) ? $data['post']->vendor->name : " " }}
                            @endif
                            <br />

                            <b>Expense type: </b>
                            @if (!empty($data['post']->expense_type))
                                <span style="color:orange">{{$data['expense_type']}}</span>
                            @endif
                        </td>

                        <td>
                            @if (!empty($data['post']->status))
                            <b>Status: </b>
                            @switch($data['post']->status)
                                @case(0)
                                    <b style="color: red;">
                                        Cancel-ar
                                    </b> 
                                    @break
                                @case(1)
                                    <b style="color: green;">
                                        Active-ar
                                    </b>
                                    @break
                                @case(2)
                                    <b style="color: rgb(59, 194, 187);">
                                        Complete-ar
                                    </b>
                                    @break
                                @case(3)
                                    <b style="color: rgb(208, 230, 18);">
                                        Pending-ar
                                    </b>
                                    @break
                            @endswitch
                            @endif
                        </td>
                    </tr>
                </table>
            </td>
        </tr>

        <tr class="top">
            <td colspan="4">
                <table>
                    <tr>
                        <td class="total">
                            <b class="left"> Total: {{ !empty($data['post']->total_amount) ? $data['post']->total_amount : 0 }}</b><br />

                            <b class="left"> Discount: {{ !empty($data['post']->discount_invoice) ? $data['post']->discount_invoice : 0 }}</b><br />

                            <b class="left"> Tax: {{ !empty($data['post']->tax) ? $data['post']->tax : 0 }}</b><br />

                            <b class="left"> Net Amount: {{ !empty($data['post']->net_total) ? $data['post']->net_total : 0 }}</b>
                        </td>
                        
                        <td style="width: 25rem">
                            <b>Terms & Condition</b><br />
                            <span>
                                Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam..
                            </span>
                            <br /><br />
                            {{-- <img src="{{asset('project/R.png')}}" alt="qr code here" style="width: 80px; max-width: 100px" /> --}}
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    @endif
    {{-- <div style="font-weight:bold; text-transform: uppercase; text-align: center;">thank you for parchasing</div> --}}
    </small>
</div>
</body>
</html>