@extends('admin.layout.master')
@section('content')
@include('project/orders/script_js')
<div class='bg-white p-2 rounded m-2'>
    <div class="row justify-content-between p-lg-3 rounded m-2  bg-light">
        <div class="col-md-6 col-12  align-self-center">
            <a class='text-decoration-none fw-bold text-dark breadc' href="">
              Orders List
            </a>
        </div>
        <div class="col-md-6 col-12  align-self-center float-end ">
            <div class='align-self-center  text-center justify-content-center'>
                <div class="row">
                    <div class="col-md-6">
                        <div>
                            <input type="text" class="form-control rounded-pill bg-light" id="search_new" placeholder="{{trans('admin.search')}}">
                        </div>
                    </div>
                    <div class="col-md-6">
                      <select id="status_filter" class="form-select rounded-pill">
                          <option value="" selected>All Status</option>
                          <option value="0"> Pending </option>
                          <option value="1"> Active </option>
                          <option value="2"> Completed </option>
                          <option value="3"> Cancelled </option>
                      </select>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class='table-responsive p-3'>
        <table class='table table-border data-table'>
            <thead>
                <tr class='tex-g'>
                    <th>Customer</th>
                    <th>Vendor</th>
                    <th>Order#</th>
                    <th>Date</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>              
            </tbody>
        </table>
    </div>
</div>
<style>
  .dataTables_filter {
    display: none;
  }
</style>
<script type="text/javascript">
var table ="";
$(function () {
   table = $('.data-table').DataTable({
      processing: true,
      serverSide: true,
      "searching": false,
      ajax: {
          url: "{{ route('order_list') }}",
          type: 'GET',
          data: function(d) {
            d.search_new = $('#search_new').val();
            d.status_filter = $('#status_filter').val();
            // console.log(d);
          }
      },
      columns: [
          {data: 'user_id', name: 'user_id'},
          {data: 'vendor', name: 'vendor'},
          {data: 'id', name: 'id'},
          {data: 'order_date', name: 'order_date'},
          {data: 'net_total', name: 'net_total'},
          {data: 'status', name: 'status', orderable: false, searchable: false},
          {data: 'action', name: 'action', orderable: false, searchable: false},
      ],
  	"lengthMenu": [[10, 25, 50, 100, -1], [100, 200, 500, 700, "All"]]
  });
});
$('body').on('change', '#status_filter', function(e) {
  table.draw(true);
});
$('body').on('keyup', '#search_new', function(e) {
  table.draw(true);
});
$('body').on('click', '.clear', function(e) {
    $('#search_new').val("");
    $('#status_filter').val("");
    table.draw(true);
});
/*$("#search_new").on("keyup", function() {
    table.draw();
 });*/
</script>
@endsection