@extends('admin.layout.master')
@section('content')
<div class="container">
    <div id="print_div">
        <div class="row justify-content-between p-2 rounded m-2  bg-light">
            <div class="col-6 col-md-6 align-self-center">
                <a class='text-decoration-none fw-bold  text-dark breadc' href="">
                    Home/Order #{{$post->id}}
                </a>
            </div>
            <div class="col-6 col-md-6 ">
                <div class='text-center float-end'>
                    <table>
                        <tr>
                            <td><svg xmlns="http://www.w3.org/2000/svg" width="14.221" height="13.359" viewBox="0 0 14.221 13.359">
                                    <g id="Group_12508" data-name="Group 12508" transform="translate(0 -3.042)">
                                        <g id="Group_12300" data-name="Group 12300" transform="translate(0 3.042)">
                                            <path id="Path_15328" data-name="Path 15328" d="M94.308,153.419l2.2,4.4,4.913.705-3.555,3.423.839,4.833L94.308,164.5l-4.395,2.282.839-4.833L87.2,158.522l4.913-.705Z" transform="translate(-87.197 -153.419)" fill="#f4bd05" />
                                        </g>
                                    </g>
                                </svg></td>
                            <td>
                                @if (isset($post->ratings->rating) && !empty($post->ratings->rating))
                                    {{$post->ratings->rating}}
                                @endif
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        <div class="row mt-md-4">
            <div class="col-sm-5">
                <div class="card p-3">
                    <table class='table table-borderless'>
                        <tr class='t_P_10 '>
                            <td>
                                Order ID
                            </td>
                            <td class='text-end text-dark fw-bold'>
                                {{$post->id}}
                            </td>
                        </tr>
                        <tr class='t_P_10'>
                            @if (isset($post->customer->name) && !empty($post->customer->name))
                                <td>
                                    Customer
                                </td>
                                <td class='text-end text-dark fw-bold'>
                                    {{$post->customer->name}}
                                </td>
                            @else
                                <td>
                                    Provider
                                </td>
                                <td class='text-end text-dark fw-bold'>
                                    {{$post->vendor->business_name}}
                                </td>
                            @endif
                        </tr>
                        <tr class='t_P_10'>
                            <td>
                                Detail
                            </td>
                            <td class='text-end text-dark fw-bold'>
                                @if (Session::get('locale')=='ar')
                                    {{$post->tables->title_ar}}
                                @else
                                    {{$post->tables->title_en}}
                                @endif 
                                {{$post->tables->seat}} - {{$post->timings->to_time}}
                            </td>
                        </tr>
                        <tr class='t_P_10'>
                            <td>
                                Date
                            </td>
                            <td class='text-end text-dark fw-bold'>
                                {{$post->order_date}}
                            </td>
                        </tr>
                        <tr class='border-bottom ' style="margin:10px; height:10px"></tr>
                        <!-- this only bottom border  -->
                        <tr class='t_P_10'>
                            <td>
                                Total
                            </td>
                            <td class='text-end text-dark fw-bold'>
                                {{$post->sub_total}}
                            </td>
                        </tr>
                        <tr class='t_P_10'>
                            <td>
                                Tax
                            </td>
                            <td class='text-end text-dark fw-bold'>
                                {{$post->tax_amount}}
                            </td>
                        </tr>
                        <tr class='t_P_10'>
                            <td>
                                Discount
                            </td>
                            <td class='text-end text-dark fw-bold'>
                                {{$post->coupon_value}}
                            </td>
                        </tr>
                        <tr class='t_P_10'>
                            <td>
                                Net Amount
                            </td>
                            <td class='text-end text-dark fw-bold'>
                                {{$post->net_total}}
                            </td>
                        </tr>
                        <br>
                    </table>
                </div>
            </div>
            <!-- col-5 here is complete  -->
            <div class="col-sm-7">
                <div class="card p-3 bg-light rounded">
                    <table class="table table-borderless w-100">
                        <thead>
                            <tr class='tex-g fw-none'>
                                <th>Item</th>
                                <th>Price</th>
                                <th>QTY</th>
                                <th>Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($post->order_details as $row)
                            <tr class='tex-d'>
                                <td style='width:50%;'>{{$row->item_name}}</td>
                                <td>{{$row->item_price}}</td>
                                <td>{{$row->item_qty}}</td>
                                <td>{{$row->item_price * $row->item_qty}}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                <!-- car her complete  -->
                <div class=" col-12  p-2">
                    <table class='table table-borderless '>
                        <thead>
                            <tr class='tex-g'>
                                <th>Adress</th>
                                <th class='text-center'>Order Status</th>
                                <th class='text-end'>Payment Method</th>
                            </tr>
                        </thead>
                        <tr class='tex-d'>
                            <td>
                                @if (isset($post->customer->address) && !empty($post->customer->address))
                                    {{$post->customer->address}}
                                @else
                                    {{$post->vendor->address}}
                                @endif
                            </td>
                            <td class='text-center fw-bold'>
                                @switch($post->status)
                                    @case(0)
                                        <span class="text-danger">Cancel</span> 
                                        @break
                                    @case(1)
                                        <span class="text-success">Active</span>
                                        @break
                                    @case(2)
                                        <span class="text-info">Complete</span>
                                        @break
                                    @case(3)
                                        <span class="text-warning">Pending for gift</span>
                                        @break
                                @endswitch
                            </td>
                            <td class='text-end'>
                                @switch($post->payment_method)
                                    @case(1)
                                        <span class="">Cash</span>
                                        @break
                                    @case(2)
                                        <span class="">Card</span>
                                        @break
                                    @case(3)
                                        <span class="">Wallet for gift</span>
                                        @break
                                @endswitch
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="d-inline">
                    <div class='mt-lg-4 d-inline  '>
                        <button type="button" class='btn btn-warning col-bt mt-lg-5 rounded-pill px-4 text-white no-print' onclick="printDiv('print_div')">Print</button>
                    </div>
                    <div class='float-end d-inline'>
                        <img src="{{asset('images\user\qr-code.png')}}" alt="">
                    </div>
                </div>
            </div>
        </div>
        <!-- row here complete -->
    </div>
</div>
@endsection