@extends('admin.layout.master')
@section('content')
<!-- THE ROW END HERE -->
<div class='bg-white p-2 rounded m-2'>
    <div class="rowjustify-content-between p-2 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center p-2">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill"></span>
            <a class='text-decoration-none fw-bold ' href="{{url('/categories')}}">{{trans('admin.categories')}}  </a> <span class="bi bi-caret-right"></span>
            <span class='text-decoration-none fw-bold' >{{trans('admin.add')}}</span>
        </div>
    </div>
    <div class='p-3'>
        <form action="{{route('save_categories')}}" method="post" enctype="multipart/form-data">
            @csrf
            <div class="row flex-column-reverse flex-md-row">
                <div class="col-12">
                    @if (session()->has('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session()->get('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @elseif(session()->has('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session()->get('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                </div>
                <div class="col-md-9">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3 font-text">
                                <label for="vendor_type_id" class="form-label label">{{trans('vendor_types')}}</label>
                                <select  id="vendor_type_id" class="form-select rounded-pill bg-light cat @error('vendor_type_id') is-invalid @enderror" name="vendor_type_id">
                                    <option value="">Select</option>
                                    @foreach($vendors as $data)
                                        <option value="{{$data->id}}">
                                            @if (Session::get('locale') == 'ar')
                                                {{$data->name_ar}}
                                            @else
                                                {{$data->name_en}}
                                            @endif
                                        </option>
                                    @endforeach
                                </select>
                                @error('vendor_type_id') 
                                    <span class="text-danger">{{ $message }}</span> 
                                @enderror                                
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3 font-text">
                                <label for="name_en" class="form-label">{{ trans('project.name') }}</label>
                                <input type="text" class="form-control bg-light_c border-0 @error('name_en') is-invalid @enderror" id="name_en" name="name_en" placeholder="{{ trans('project.name') }}" aria-describedby="emailHelp">
                                @error('name_en') 
                                    <span class="text-danger">{{ $message }}</span> 
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3 font-text">
                                <label for="name_ar" class="form-label">{{ trans('project.name_ar') }}</label>
                                <input type="text" class="form-control bg-light_c border-0 @error('name_ar') is-invalid @enderror" id="name_ar" name="name_ar" placeholder="{{ trans('project.name') }}" aria-describedby="emailHelp">
                                @error('name_ar') 
                                    <span class="text-danger">{{ $message }}</span> 
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-4">
                            <!-- switch start  -->
                            <div class="d-flex justify-content-between py-3 ">
                                <label for="status" class="ms-2 mb-1">{{ trans('project.status') }}</label>
                                <label class="switch">
                                    <input type="checkbox" name="status" id="status" value="1">
                                    <div class="slider round">
                                        <!--ADDED HTML -->
                                        <span class="on">{{ trans('project.on') }}</span>
                                        <span class="off">{{ trans('project.off') }}</span>
                                    </div>
                                </label>
                            </div>
                            <!-- switch end  -->
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="container mt-lg-2 pt-3 ">
                        <label class="upload-btn-wrapper bg-light_c" for="file">
                            <img src="" class="img-fluid" alt="" id="preview">
                            <span class=" p-1 text-start"><i class="bi bi-camera pe-1"></i>Click Here</span>
                            @error('photo') 
                            <br><span class="text-danger">{{ $message }}</span> 
                            @enderror
                        </label>
                        <input type="file" name="photo" id="file" class="d-none  bg-light_c" onchange="itemname(event)" />
                        @error('photo') 
                            <span class="text-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                </div>
            </div>
            <button type='sumbit' class='btn  btn-color rounded-pill text-light px-5 mt-3 '>{{ trans('admin.add') }}</button>
        </form>
    </div>
</div>
</div>
<script>
    function itemname(event) {
        var preview = document.getElementById("preview");
        preview.src = URL.createObjectURL(event.target.files[0]);
    }
</script>
@endsection
