@extends('admin.layout.master')

@section('content')
<div class="container">
    <div class="row   justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold  text-dark' href="">
                {{__('nadel.home')}} / {{__('nadel.vendor_types')}}
            </a>
        </div>
        <div class="col-md-6 col-12  align-self-center float-end ">
            <div class='align-self-center  text-center justify-content-center'>
                <div class="row">
                    <div class="offset-10 col-md-2">
                        <a class='text-decoration-none ' href="{{url('/vendors/add-vendor')}}">
                            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 55 55">
                                <g id="Group_12506" data-name="Group 12506" transform="translate(-1134.648 -427.545)">
                                    <ellipse id="Ellipse_593" data-name="Ellipse 593" cx="27.5" cy="27.5" rx="27.5" ry="27.5" transform="translate(1134.648 427.545)" fill="#f56a20" />
                                    <path id="Path_15415" data-name="Path 15415" d="M1.438-6.844V-9.469H8.25v-6.859h2.672v6.859h6.813v2.625H10.922V0H8.25V-6.844Z" transform="translate(1153.017 463.249)" fill="#fff" />
                                </g>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        @foreach($record as $item)
        <div class="col-sm-6 my-2" id="rows_{{$item['id']}}">
            <div class="card bg-light p-2 rounded border-0">
                <div class="row">
                    <div class="col-6">
                        <table>
                            <tr>
                                <td> <img class='px-2' src="{{asset($item['photo'])}}" width="55"  alt=""></td>
                                <td>
                                    {{-- <sapn class='fw-bold text-dark'>
                                            {{isset($item['name'][auth()->user()->locale] ) ? $item['name'][auth()->user()->locale] : ""}}
                                    </sapn><br> --}}
                                    <span class="fw-bold text-dark">
                                        {{$item['name_en']}} - {{$item['name_ar']}}
                                    </span>
                                    <span>Count : <b class='bg-o fw-bold'>{{$item['vender_details_count']}}</b></span>
                                </td>
                            </tr>
                        </table>
                    </div> <!--end div-6//-->
                    <div class="col-6 text-end align-self-center">
                        <span>
                            <a class='text-decoration-none px-1' href="{{route('edit-vendor',['id' => $item['id']])}}">
                                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40">
                                    <g id="Group_12735" data-name="Group 12735" transform="translate(-1068 -252)">
                                        <g id="Group_12512" data-name="Group 12512" transform="translate(-44 -88)">
                                        <circle id="Ellipse_598" data-name="Ellipse 598" cx="20" cy="20" r="20" transform="translate(1112 340)" fill="#edebf7"/>
                                        <path id="Icon_feather-edit-2" data-name="Icon feather-edit-2" d="M11.051,3.7A1.518,1.518,0,0,1,13.2,5.849L5.952,13.1,3,13.9l.805-2.952Z" transform="translate(1123.834 351.421)" fill="none" stroke="#543ab2" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        </g>
                                    </g>
                                </svg><span class='px-1'>Edit</span>
                            </a>
                        </span>
                        <span>
                            <a class='text-decoration-none px-1' onClick="destroy({{$item['id']}})">
                                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40">
                                    <g id="Group_12514" data-name="Group 12514" transform="translate(-1211 -340)">
                                        <circle id="Ellipse_597" data-name="Ellipse 597" cx="20" cy="20" r="20" transform="translate(1211 340)" fill="#ff3b3b" opacity="0.1"/>
                                        <g id="Icon_feather-delete" data-name="Icon feather-delete" transform="translate(1221.184 348.679)">
                                        <path id="Path_15433" data-name="Path 15433" d="M14.8,6H6.156L1.5,11.321l4.656,5.321H14.8a1.33,1.33,0,0,0,1.33-1.33V7.33A1.33,1.33,0,0,0,14.8,6Z" fill="none" stroke="#ff3b3b" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        <path id="Path_15434" data-name="Path 15434" d="M21.991,13.5,18,17.491" transform="translate(-9.183 -4.174)" fill="none" stroke="#ff3b3b" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        <path id="Path_15435" data-name="Path 15435" d="M18,13.5l3.991,3.991" transform="translate(-9.183 -4.174)" fill="none" stroke="#ff3b3b" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        </g>
                                    </g>
                                </svg>
                                <span class='px-1'>Delete</span>
                            </a>
                        </span>
                    </div>
                </div>
            </div> <!--the card complete-->
        </div><!--the colum-6 here complete-->
        @endforeach
        {{-- <div class="col-sm-6 my-2">
            <div class="card bg-light p-2 rounded border-0">
                <div class="row">
                    <div class="col-6">
                        <table>
                            <tr>
                                <td> <img class='px-2' src="{{asset('images/user/user-1.png')}}" alt=""></td>
                                <td>
                                    <sapn class='fw-bold text-dark'>Restaurent</sapn><br>
                                    <span>Count : <b class='bg-o fw-bold'>20</b></span>
                                </td>
                            </tr>
                        </table>
                    </div> <!--end div-6//-->
                    <div class="col-6 text-end align-self-center">
                        <span>
                            <a class='text-decoration-none px-1' href="#">
                                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40">
                                    <g id="Group_12735" data-name="Group 12735" transform="translate(-1068 -252)">
                                        <g id="Group_12512" data-name="Group 12512" transform="translate(-44 -88)">
                                        <circle id="Ellipse_598" data-name="Ellipse 598" cx="20" cy="20" r="20" transform="translate(1112 340)" fill="#edebf7"/>
                                        <path id="Icon_feather-edit-2" data-name="Icon feather-edit-2" d="M11.051,3.7A1.518,1.518,0,0,1,13.2,5.849L5.952,13.1,3,13.9l.805-2.952Z" transform="translate(1123.834 351.421)" fill="none" stroke="#543ab2" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        </g>
                                    </g>
                                </svg><span class='px-1'>Edit</span>
                            </a>
                        </span>
                        <span>
                            <a class='text-decoration-none px-1' href="">
                                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40">
                                    <g id="Group_12514" data-name="Group 12514" transform="translate(-1211 -340)">
                                        <circle id="Ellipse_597" data-name="Ellipse 597" cx="20" cy="20" r="20" transform="translate(1211 340)" fill="#ff3b3b" opacity="0.1"/>
                                        <g id="Icon_feather-delete" data-name="Icon feather-delete" transform="translate(1221.184 348.679)">
                                        <path id="Path_15433" data-name="Path 15433" d="M14.8,6H6.156L1.5,11.321l4.656,5.321H14.8a1.33,1.33,0,0,0,1.33-1.33V7.33A1.33,1.33,0,0,0,14.8,6Z" fill="none" stroke="#ff3b3b" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        <path id="Path_15434" data-name="Path 15434" d="M21.991,13.5,18,17.491" transform="translate(-9.183 -4.174)" fill="none" stroke="#ff3b3b" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        <path id="Path_15435" data-name="Path 15435" d="M18,13.5l3.991,3.991" transform="translate(-9.183 -4.174)" fill="none" stroke="#ff3b3b" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        </g>
                                    </g>
                                </svg>
                                <span class='px-1'>Delete</span>
                            </a>
                        </span>
                    </div>
                </div>
            </div> <!--the card complete-->
        </div><!--the colum-6 here complete-->
        <div class="col-sm-6 my-2">
            <div class="card bg-light p-2 rounded border-0">
                <div class="row">
                    <div class="col-6">
                        <table>
                            <tr>
                                <td> <img class='px-2' src="{{asset('images/user/user-1.png')}}" alt=""></td>
                                <td>
                                    <sapn class='fw-bold text-dark'>Restaurent</sapn><br>
                                    <span>Count : <b class='bg-o fw-bold'>20</b></span>
                                </td>
                            </tr>
                        </table>
                    </div> <!--end div-6//-->
                    <div class="col-6 text-end align-self-center">
                        <span>
                            <a class='text-decoration-none px-1' href="#">
                                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40">
                                    <g id="Group_12735" data-name="Group 12735" transform="translate(-1068 -252)">
                                        <g id="Group_12512" data-name="Group 12512" transform="translate(-44 -88)">
                                        <circle id="Ellipse_598" data-name="Ellipse 598" cx="20" cy="20" r="20" transform="translate(1112 340)" fill="#edebf7"/>
                                        <path id="Icon_feather-edit-2" data-name="Icon feather-edit-2" d="M11.051,3.7A1.518,1.518,0,0,1,13.2,5.849L5.952,13.1,3,13.9l.805-2.952Z" transform="translate(1123.834 351.421)" fill="none" stroke="#543ab2" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        </g>
                                    </g>
                                </svg><span class='px-1'>Edit</span>
                            </a>
                        </span>
                        <span>
                            <a class='text-decoration-none px-1' href="">
                                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40">
                                    <g id="Group_12514" data-name="Group 12514" transform="translate(-1211 -340)">
                                        <circle id="Ellipse_597" data-name="Ellipse 597" cx="20" cy="20" r="20" transform="translate(1211 340)" fill="#ff3b3b" opacity="0.1"/>
                                        <g id="Icon_feather-delete" data-name="Icon feather-delete" transform="translate(1221.184 348.679)">
                                        <path id="Path_15433" data-name="Path 15433" d="M14.8,6H6.156L1.5,11.321l4.656,5.321H14.8a1.33,1.33,0,0,0,1.33-1.33V7.33A1.33,1.33,0,0,0,14.8,6Z" fill="none" stroke="#ff3b3b" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        <path id="Path_15434" data-name="Path 15434" d="M21.991,13.5,18,17.491" transform="translate(-9.183 -4.174)" fill="none" stroke="#ff3b3b" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        <path id="Path_15435" data-name="Path 15435" d="M18,13.5l3.991,3.991" transform="translate(-9.183 -4.174)" fill="none" stroke="#ff3b3b" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        </g>
                                    </g>
                                </svg>
                                <span class='px-1'>Delete</span>
                            </a>
                        </span>
                    </div>
                </div>
            </div> <!--the card complete-->
        </div><!--the colum-6 here complete-->
        <div class="col-sm-6 my-2">
            <div class="card bg-light p-2 rounded border-0">
                <div class="row">
                    <div class="col-6">
                        <table>
                            <tr>
                                <td> <img class='px-2' src="{{asset('images/user/user-1.png')}}" alt=""></td>
                                <td>
                                    <sapn class='fw-bold text-dark'>Restaurent</sapn><br>
                                    <span>Count : <b class='bg-o fw-bold'>20</b></span>
                                </td>
                            </tr>
                        </table>
                    </div> <!--end div-6//-->
                    <div class="col-6 text-end align-self-center">
                        <span>
                            <a class='text-decoration-none px-1' href="#">
                                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40">
                                    <g id="Group_12735" data-name="Group 12735" transform="translate(-1068 -252)">
                                        <g id="Group_12512" data-name="Group 12512" transform="translate(-44 -88)">
                                        <circle id="Ellipse_598" data-name="Ellipse 598" cx="20" cy="20" r="20" transform="translate(1112 340)" fill="#edebf7"/>
                                        <path id="Icon_feather-edit-2" data-name="Icon feather-edit-2" d="M11.051,3.7A1.518,1.518,0,0,1,13.2,5.849L5.952,13.1,3,13.9l.805-2.952Z" transform="translate(1123.834 351.421)" fill="none" stroke="#543ab2" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        </g>
                                    </g>
                                </svg><span class='px-1'>Edit</span>
                            </a>
                        </span>
                        <span>
                            <a class='text-decoration-none px-1' href="">
                                <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40">
                                    <g id="Group_12514" data-name="Group 12514" transform="translate(-1211 -340)">
                                        <circle id="Ellipse_597" data-name="Ellipse 597" cx="20" cy="20" r="20" transform="translate(1211 340)" fill="#ff3b3b" opacity="0.1"/>
                                        <g id="Icon_feather-delete" data-name="Icon feather-delete" transform="translate(1221.184 348.679)">
                                        <path id="Path_15433" data-name="Path 15433" d="M14.8,6H6.156L1.5,11.321l4.656,5.321H14.8a1.33,1.33,0,0,0,1.33-1.33V7.33A1.33,1.33,0,0,0,14.8,6Z" fill="none" stroke="#ff3b3b" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        <path id="Path_15434" data-name="Path 15434" d="M21.991,13.5,18,17.491" transform="translate(-9.183 -4.174)" fill="none" stroke="#ff3b3b" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        <path id="Path_15435" data-name="Path 15435" d="M18,13.5l3.991,3.991" transform="translate(-9.183 -4.174)" fill="none" stroke="#ff3b3b" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"/>
                                        </g>
                                    </g>
                                </svg>
                                <span class='px-1'>Delete</span>
                            </a>
                        </span>
                    </div>
                </div>
            </div> <!--the card complete-->
        </div><!--the colum-6 here complete--> --}}
    </div>
</div>
<script type="text/javascript">
    function destroy(id) {
        bootbox.confirm("{{trans('admin.Are_you_sure')}}", function(result){
            loading();
            $.ajax({
                url: '{{url("/vendors/destroy")}}',
                type: 'post',
                //dataType:'json',
                data: {_token: '{!! csrf_token() !!}', id: id},
            })
            .done(function(res) {
                swal(res.text,res.cls);
                $("#rows_"+id).hide(1000);
            })
            .fail(function() {
                console.log("error");
            })
            .always(function() {
                loading("stop");
            }); 
        })
    }
</script>
@endsection
