@extends('admin.layout.master')

@section('content')
<div class="container">
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-6 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold  text-dark' href="">
                {{__('nadel.home')}} / {{__('nadel.vendor_types')}}
            </a>
        </div>
    </div><br>
    <div class="card p-3">
        @if ($errors->any())
        <span class="invalid-feedback" style="display: block">
            {{__('nadel.failed_to_process_the_data_please_review_the_form')}}
        </span>
        @endif
        <div class="row  ">
            <div class="col-sm-5">
                <form action="{{route('create-vendor-type')}}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="mb-3">
                    <label for="name_en" class="form-label">Name </label>
                    <input type="text" class="form-control @error('name_en') is-invalid @enderror rounded-pill bg-light" name="name_en" id="name_en" aria-describedby="emailHelp" placeholder='Name'>
                    @error('name_en') 
                        <span class="invalid-feedback">{{$message}}</span> 
                    @enderror
                </div>

                <div class="mb-3">
                    <label for="name_ar" class="form-label">Name (Arabic)</label>
                    <input type="text" class="form-control rounded-pill bg-light @error('name_ar') is-invalid @enderror" id="name_ar" name="name_ar" aria-describedby="emailHelp" placeholder='Name'>
                    @error('name_ar') 
                        <span class="invalid-feedback">{{$message}}</span> 
                    @enderror
                </div>
                <br>
                <!-- switch start  -->
                <div class="d-flex  mob_just">
                    <label for="status" class="ms-2 mb-1">Status</label>
                    <label class="switch ms-5">
                        <input type="checkbox" name="status" id="status" value="1">
                        <div class="slider round">
                            <!--ADDED HTML -->
                            <span class="on">on</span>
                            <span class="off">off</span>
                        </div>
                    </label>
                </div>
                <!-- switch end  -->
            </div>
            <div class="col-12 col-md-4">
                <div class="mb-3">
                    <label for="description_en" class="form-label">{{__('admin.description')}} </label>
                    <textarea class="form-control @error('description_en') is-invalid @enderror bg-light rounded cat" id="description_en" name="description_en" placeholder="Type here" rows="4"></textarea>
                    @error('description_en') 
                        <span class="invalid-feedback">{{$message}}</span> 
                    @enderror
                </div>
                <div class="mb-3">
                    <label for="description_ar" class="form-label">Description (Arabic)</label>
                    <textarea class="form-control bg-light rounded cat @error('description_ar') is-invalid @enderror" id="description_ar" name="description_ar" placeholder="Type here" rows="4"></textarea>
                    @error('description_ar') 
                        <span class="invalid-feedback">{{$message}}</span> 
                    @enderror
                </div>
            </div>
            <div class="col-12 col-md-2">
                <div class="container">
                    <label class="upload-btn-wrapper bg-light_c" for="file"> <span class="text_img">Photo</span>
                        <img src="" class="img-fluid" alt="" id="preview">
                    </label>
                    <input type="file" name="photo" id="file" class="d-none" onchange="vendor(event)" />
                </div>
                @error('photo')
                <span class="invalid-feedback" style="display: block">{{$message}}</span>
                @enderror
            </div>
        </div>
        <!-- row ended here  -->
        <br>
        <div>
            <button type="submit" class="btn btn-warning col-bt rounded-pill my-4 f-inline">{{__('nadel.save')}}</button>

        </div>
    </div>
    </form>
</div>
</div>
@endsection
@section('custom-js')
@if(Session::has('message'))
<script>
    swal("{{Session::get('message')}}", 'success');
</script>
@endif
<script>
    function vendor(event) {
        var preview = document.getElementById("preview");
        preview.src = URL.createObjectURL(event.target.files[0]);
    }
</script>
@endsection