@extends('admin.layout.master')

@section('content')
<div class="container">
        <div class="row justify-content-between p-3 rounded m-2  bg-light">
            <div class="col-6 col-md-6 align-self-center">
                <a class='text-decoration-none fw-bold  text-dark' href="">
                    {{__('nadel.home')}} / {{__('nadel.edit_vendor_types')}}
                </a>
            </div>
        </div><br>
         <div class="card p-3">
            @if (session()->has('success'))
                <div class="alert alert-warning">
                {{session()->get('success')}}

                </div>
            @endif
        <div class="row  ">
            <div class="col-sm-5">
                <form action="{{route('update-vendor-type')}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="id" value="{{$record->id}}">
                    <div class="mb-3">
                        <label for="exampleInputEmail1" class="form-label">Name  (English)</label>
                        <input value="{{$record->name_en}}" type="text" class="form-control @error('name_en') is-invalid @enderror rounded-pill bg-light" name="name_en" id="exampleInputEmail1" aria-describedby="emailHelp" placeholder='name_en'>
                        @error('name_en') <span class="invalid-feedback">Name Field is required</span> @enderror
                    </div>
                    <div class="mb-3">
                        <label for="exampleInputEmail1" class="form-label">Name  (Arabic)</label>
                        <input value="{{$record->name_ar  }}" type="text" class="form-control @error('name_ar') is-invalid @enderror rounded-pill bg-light" name="name_ar" id="exampleInputEmail1" aria-describedby="emailHelp" placeholder='name_ar'>
                        @error('name_ar') <span class="invalid-feedback">Name Field is required</span> @enderror
                    </div>

                    {{-- <div class="mb-3">
                        <label for="exampleInputEmail1" class="form-label">Name (Arabic)</label>
                        <input type="text" class="form-control  rounded-pill bg-light" id="exampleInputEmail1" aria-describedby="emailHelp" placeholder='Name'>
                    </div> --}}
                    {{-- <div class="mb-3">
                        <label for="exampleInputPassword1" class="form-label">{{__('admin.select_language')}}</label>
                        <select name="language"  id=" Select" class="form-select rounded-pill bg-light cat @error('name') is-invalid @enderror">
                            <option value="">{{__('admin.select')}}</option>
                            <option value="en" >{{__('admin.language_en')}}</option>
                                <option value="ar" >{{__('admin.language_ar')}}</option>

                            </select>
                              @error('language') <span class="invalid-feedback">Name Field is required</span> @enderror
                    </div> <br> --}}
                    <table>
                        <tr>
                            <td> <span class='pe-3'>  Status</span></td>
                            <td>
                                <div>
                                    <label class="switch">
                                    <input type="checkbox" id="togBtn" name="status" {{($record->status == 1) ? "checked" : ""}}>
                                    <div class="slider round">
                                    <!--ADDED HTML -->
                                    <span class="on">ON</span>
                                    <span class="off">OFF</span>
                                </div>
                            </td>
                        </tr>
                    </table>
                    </div>
                    <div class="col-12 col-md-4">
                    <div class="mb-3">
                        <label for="exampleFormControlTextarea1" class="form-label">Description (English) </label>
                        <textarea class="form-control @error('description_en') is-invalid @enderror bg-light rounded cat" id="exampleFormControlTextarea1" name="description_en" rows="4">{{$record->description_en}}</textarea>
                         @error('description_en') <span class="invalid-feedback">Description english is required</span> @enderror
                    </div>
                    <div class="mb-3">
                         <label for="exampleFormControlTextarea1" class="form-label">Description (Arabic) </label>
                        <textarea class="form-control @error('description_ar') is-invalid @enderror bg-light rounded cat" id="exampleFormControlTextarea1" name="description_ar" rows="4">{{$record->description_ar}}</textarea>
                         @error('description_ar') <span class="invalid-feedback">Description arabic is required</span> @enderror
                    </div>
                    </div>
                        <div class="col-12 col-md-2">
                           <div class="container">
                                <label class="upload-btn-wrapper bg-light_c" for="file"> <span class="text_img">Photo</span>
                                    <img src="{{asset($record->photo)}}" name="photo" class="img-fluid" id="preview">
                                </label>
                                <input type="file" name="photo" id="file" class="d-none" onchange="itemname(event)" />
                            </div>
                            @error('photo')
                                <small class="text-danger">{{$message}}</small>
                            @enderror

                        </div>
                         @error('upload_logo')
                                        <span class="invalid-feedback" style="display: block">{{$message}}</span>
                            @enderror
                    </div>
                </div>
                <!-- row ended here  -->
                <br>
                <div>
                <button type="submit" class="btn btn-warning col-bt rounded-pill my-4 f-inline">Update</button>

                </div>
            </div>
         </form>
    </div>
</div>
@endsection
@section('custom-js')
    @if(Session::has('message'))
       <script>
            swal("{{Session::get('message')}}",'success');
       </script>
    @endif
    <script>
    function itemname(event) {
        var preview = document.getElementById("preview");
        preview.src = URL.createObjectURL(event.target.files[0]);
    }
</script>
@endsection
