@extends('admin.layout.master')
@section('content')
<div class="container">
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-6 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold  text-dark breadc' href="">
                {{__('nadel.home')}}/{{(Auth::user()->locale == "en") ? $data->name_en : $data->name_ar}}
            </a>
        </div>
    </div>
    <br>
    <div class="card p-3 m-2">
        @if (session()->has('success'))
        <div class="alert alert-danger">

                {{session()->get('success')}}
        </div>
        @endif
        <form method="post" action="{{url('item-category/update')}}" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="id" value="{{$data->id}}">
            <div class="row flex-column-reverse flex-lg-row">
                <div class="col-sm-6">
                    <form>
                        <div class="mb-3">
                            <label for="exampleInputEmail1" class="form-label label">Enter Category Name (English)</label>
                            <input type="text" class="form-control  @error('name_en') is-invalid @enderror  rounded-pill bg-light_c" name="name_en" aria-describedby="emailHelp" value='{{$data->name_en}}'>
                            @error('name_en')
                                <small class="text-danger">{{$message}}</small>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <label for="exampleInputPassword1" class="form-label label">Enter Category Name (Arabic)</label>
                            <input type="text" class="form-control @error('name_en') is-invalid @enderror rounded-pill bg-light_c" name="name_ar" value='{{$data->name_ar}}'>

                             @error('name_en')
                                <small class="text-danger">{{$message}}</small>
                             @enderror
                            </div> <br>
                        <!-- switch start  -->
                        <div class="d-flex  mob_just">
                            <label for="default" class="ms-2 mb-1">Status</label>
                            <label class="switch ms-5">
                                <input type="checkbox" name="status" id="status" {{ ($data->status == 1) ? "checked" : ""}} >
                                <div class="slider round">
                                    <!--ADDED HTML -->
                                    <span class="on">on</span>
                                    <span class="off">off</span>
                                </div>
                            </label>
                        </div>
                        <!-- switch end  -->
                        <br><br>
                        <button type="submit" class="btn btn-warning col-bt rounded-pill text-white">Update</button>
                    </form>
                    <!-- this padding exctra  -->
                    <div class='m-lg-5 p-lg-4'></div>
                </div>
                <div class="col-6 col-md-6 my-sm-4 margin">
                    <div class="container">
                        <label class="upload-btn-wrapper bg-light_c" for="file"> <span class="text_img">Photo</span>
                            <img src="{{asset($data->photo)}}" class="img-fluid" alt="" id="preview">
                        </label>
                        <input type="file" name="photo" id="file" class="d-none" onchange="preview1(event)" />
                    </div>
                    @error('photo')
                       <small class="text-danger"> {{$message}}</small>
                    @enderror
                </div>
            </div>
        </form>
    </div>
</div>
</div>



<script>

    function preview1(event) {
        var preview = document.getElementById("preview");
        preview.src = URL.createObjectURL(event.target.files[0]);
    }
</script>
@endsection
