@extends('admin.layout.master')
@section('content')
<div class="container">
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-6 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold  text-dark breadc' href="">
                Home/{{(Auth::user()->locale == "en") ? $data->title_en : $data->title_ar}}
            </a>
        </div>
    </div>
    <br>
    <form method="post" action="{{url("tables/update")}}">
        @csrf
        <input type="hidden" value="{{$data->id}}" name="id">
         <div class="card p-3 m-2 mt-3">
             @if (session()->has('success'))
                    <div class="alert alert-warning">
                        {{session()->get('success')}}
                    </div>
             @endif
            <div class="row flex-column-reverse flex-lg-row">
                <div class="col-sm-6">
                    <form>
                        <div class="mb-3">
                            <label for="exampleInputEmail1" class="form-label label">Table Name (English)</label>
                            <input type="text" class="form-control  @error('title_en') is-invalid @enderror rounded-pill bg-light_c border-0" name="title_en" aria-describedby="emailHelp" value="{{$data->title_en}}">
                            @error('title_en')
                                <small class="text-danger">{{$message}}</small>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <label for="exampleInputPassword1" class="form-label label">Table Name (Arabic)</label>
                            <input type="text" class="form-control @error('title_ar') is-invalid @enderror rounded-pill bg-light_c border-0" name="title_ar" value="{{$data->title_ar}}">
                            @error('title_en')
                                <small class="text-danger">{{$message}}</small>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <label for="exampleInputPassword1" class="form-label label">Number of Seats</label>
                            <input type="text" class="form-control @error('seats') is-invalid @enderror rounded-pill bg-light_c border-0" name="seats" value='{{$data->seats}}'>
                            @error('seats')
                                <small class="text-danger">{{$message}}</small>
                            @enderror
                        </div>

                        <br>
                        <!-- switch start  -->
                        <div class="d-flex justify-content-start mob_just">
                            <label for="default" class="ms-2 mb-1">Status</label>
                            <label class="switch ms-5">
                                <input type="checkbox" name="status" id="default" {{($data->status == 1) ? "checked" : ""}} value="1">
                                <div class="slider round">
                                    <!--ADDED HTML -->
                                    <span class="on">on</span>
                                    <span class="off">off</span>
                                </div>
                            </label>
                        </div>
                        <!-- switch end  -->
                        <br><br>
                        <button type="submit" class="btn btn-warning col-bt rounded-pill text-white">Update</button>
                    </form>
                    <br>
                    <br>
                </div>
            </div>

        </div>
    </form>
</div>
</div>

@endsection
