@extends('admin.layout.master')
@section('content')
<div class="container">
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold text-dark breadc' href="">
                {{__('nadel.home')}} / {{$data->title_en}} - {{$data->title_ar}}
            </a>
        </div>
    </div>
    <form method="post" action="{{url('rooms/update')}}" enctype="multipart/form-data">
    <div class="row border rounded p-2 m-2 mt-3">
        @if (session()->has('success'))
            <div class="alert alert-warning">
                {{session()->get('successs')}}
            </div>
        @endif
        <div class="col-md-5 p-3">
                @csrf
                <input type="hidden" name="id" value="{{$data->id}}">
                <div class="mb-3">
                    <label for="exampleInputEmail1" class="form-label">Title (English)</label>
                    <input type="text" class="form-control @error('name_en') is-invalid @enderror  rounded-pill bg-light_c" id="exampleInputEmail1"  value ="{{$data->title_en}}" aria-describedby="emailHelp" name='name_en'>
                   @error('name_en')
                       <small class="text-danger">{{$message}}</small>
                   @enderror
                </div>
                <div class="mb-3">
                    <label for="exampleInputEmail1" class="form-label">Title (Arabic)</label>
                    <input type="text" class="form-control @error('name_ar') is-invalid @enderror  rounded-pill bg-light_c" id="exampleInputEmail1" value ="{{$data->title_ar}}"  aria-describedby="emailHelp" name='name_ar'>
                   @error('name_ar')
                       <small class="text-danger">{{$message}}</small>
                   @enderror
                </div>
                <div class="mb-3">
                    <label for="exampleInputEmail1" class="form-label">Number of Person</label>
                    <input type="text" class="form-control @error('person') is-invalid @enderror  rounded-pill bg-light_c" id="exampleInputEmail1" value ="{{$data->persons}}"  aria-describedby="emailHelp" name='person'>
                   @error('prson')
                       <small class="text-danger">{{$message}}</small>
                   @enderror
                </div> <br>
                <!-- switch start  -->
                <div class="d-flex  mob_just">
                    <label for="default" class="ms-2 mb-1">Status</label>
                    <label class="switch ms-5">
                        <input type="checkbox" name="status" id="default" {{($data->status == 1) ? "checked" : ""}} value="1">
                        <div class="slider round">
                            <!--ADDED HTML -->
                            <span class="on">on</span>
                            <span class="off">off</span>
                        </div>
                    </label>
                </div>
                <!-- switch end  -->
                <br>
                <button type="submit" class="btn btn-warning col-bt rounded-pill mt-4 text-white">Update</button>

        </div>
        <div class="col-md-5">
            <div class="container mt-3">
                <label class="upload-btn-wrapper bg-light_c" for="file"> <span class="text_img">Photo</span>
                    <img src="{{asset($data->photo)}}" class="img-fluid" alt="" id="preview">
                </label>
                <input type="file" name="photo" id="file" class="d-none" onchange="room(event)" />
            </div>
            @error('photo')
            <small class="text-danger">{{$message}}</small>
            @enderror
        </div>
        </form>
    </div>
</div>
<script>
    function room(event) {
        var preview = document.getElementById("preview");
        preview.src = URL.createObjectURL(event.target.files[0]);
    }
</script>
@endsection
