@extends('admin.layout.master') @section('content')
<div class='bg-white p-2 rounded m-2'>
	<div class="row justify-content-between p-3 rounded m-2 bg-light">
		<div class="col-6 col-md-6 align-self-center">
			<a class='text-decoration-none fw-bold  text-dark breadc' href="">
            {{__('nadel.myHome')}} / {{$record->business_name}}
            </a> 
        </div>
        <div class="col-12 col-md-6 align-self-center float-end ">
            <div class='align-self-center  text-center justify-content-center'>
                <div class="row">
                    <div class="col-4">
                        <div>
                            <!-- Button trigger modal for email-->
			                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#mailModal">{{trans('Send Email')}}
			                </button>
                        </div>
                    </div>
                    <div class="col-4">
                        <div>
                            <!-- Button trigger modal for sms-->
			                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#smsModal">{{trans('Send SmS')}}
			                </button>
                        </div>
                    </div>
                    <div class="col-4">
                        <div>
                            <!-- Button trigger modal for notification-->
			                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#notificationModal">{{trans('Send Notification')}}
			                </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
	</div>
    @include('nadel.providers.includes.top_bar')
	<div class='tab-content'>
		<div id='OverView' class='tab-pane fade show active'>
			<div class='row'>
				<!-- ==================================profile detail  -->
				<div class="col-md-4"> @include('nadel.providers.includes.vendor_info') </div>
				<!-- eight colum  -->
				<div class="col-md-8 rounded"> @include('nadel.providers.includes.order_statistics') </div>
			</div>
			<div>
				@include('nadel.providers.includes.recent_order_customer_feedback')
			</div>
			<!-- this div end  -->
		</div>
		<!-- over view end  -->
		<div id='order' class='tab-pane fade show'>
			@include('nadel.providers.includes.orders')
		</div>
		<!-- order tab end  -->
		<div id='ern' class='tab-pane fade show  '>
			<h1 class="display">earn</h1>
		</div>
		<!-- earn tab end  -->
		<div id='item' class='tab-pane fade show  '>
			@include('nadel.providers.includes.items')

		</div>
		<!-- item tab end  the category  -->
		<div id='cat' class='tab-pane fade show'>
			@include('nadel.providers.includes.categories')

		</div>
		<!--cat tab end  -->
		<div id='Rooms' class='tab-pane fade show'>
			@include('nadel.providers.includes.rooms')

		</div>
	</div>
	<!-- room end here  -->
	<div id='Tables' class='tab-pane fade show'>
		@include('nadel.providers.includes.tables')

	</div>
</div>
<!-- Tables end here ---  -->
<div id='Time' class='tab-pane fade show  '>
	@include('nadel.providers.includes.timings')
</div>
<!-- time end here  -->
<div id='riew' class='tab-pane fade show  '>
	@include('nadel.providers.includes.reviews')
</div>
<!-- riew end here  -->
<div id='slide' class='tab-pane fade show  '>
	@include('nadel.providers.includes.slides')

</div>
<!--slide tab end  -->
<div id='log' class='tab-pane fade show '>
	@include('nadel.providers.includes.logs')

	<!--log tab end  -->
</div>
</div>
<style>
	.mytab {
		background-color: red !important;
		font-size: 19px;
	}

	.bg-light {
		background-color: rgba(240, 240, 240, .5) !important;
	}
</style>

<!-- Modal -->
<div class="modal fade" id="mailModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content" style="background-color:transparent">
            <div class="p-2 bg-white rounded">
                <div class='cross'>
                    <button type="button" class="border-0 cancel_icon" data-bs-dismiss="modal" style="background-color: ">
                        <i class="bi bi-x"></i>
                    </button>
                </div>
                <div class='p-4'>
                    <form id="send_mail" enctype="multipart/form-data">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                        <input type="hidden" name="uid" id="uid" value="{{$record->user_id}}">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="mb-3">
	                                <label for="exampleInputEmail1" class="form-label label">Subject</label>
	                                <input type="text" class="form-control rounded-pill bg-light_c @error('subject') is-invalid @enderror" name="subject" id="subject" value="{{ old('subject') }}">
	                            </div>
                            </div>
	                        <div class="col-sm-6">
	                            <div class="mb-3">
	                                <label for="template" class="form-label label">Templates</label>
	                                <select  id="template" class="form-select rounded-pill bg-light cat" name="template">
	                                    <option value="">Select</option>
	                                    @foreach(templates_list() as $temp)
	                                    <option value="{{$temp->id}}">{{$temp->name}}</option>
	                                    @endforeach
	                                </select>
	                            </div>
	                        </div>
	                        <div class="col-sm-6">
	                            <div class="mb-3">
	                                <label for="hosts" class="form-label label">Hosts</label>
	                                <select  id="hosts" class="form-select rounded-pill bg-light cat" name="hosts">
	                                    <option value="">Select</option>
	                                    @foreach(email_host_list() as $host)
	                                    <option value="{{$host->id}}" @if($host->is_default == 1) selected @endif>{{$host->name}}</option>
	                                    @endforeach
	                                </select>
	                            </div>
	                        </div>
	                    </div>
                        <div>
                        	<div class="mb-3">
                                <div class="container bg-light p-2">
                                    <i class="bi bi-question-circle-fill" style="font-size: 20px; padding-top:10px;"></i> <span class='fw-bold text-dark mt-2'>Parameters</span>
                                    <p id="params"></p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">  
                            <div class="mb-3 position-relative">
                                <label for="exampleFormControlTextarea1" class="form-label label">Message</label>
                                <textarea data-emojiable="true" data-emoji-input="unicode" class="form-control bg-light_c textarea-round cat @error('message') is-invalid @enderror" name="message" id="message" rows="8"></textarea>
                            </div>
                        </div>
                        <hr>
                        <div class='d-flixs'>
                            <div class="upload-btn-wrapper pe-2" style="height: 33px;">
                                <lable for="html_btn" type="button" class="btn btn-info col-upload border-0 click bg-light">
                                    <i class="bi bi-paperclip px-1 fs-6"></i>Attach
                                </lable>
                                <input id="active_btn" name="attach[]" type='file' multiple hidden/>
                            </div>
                            <button type="submit" class="btn btn-warning col-bt rounded-pill mb-4  ">Send</button>
                        </div>
                        <div class="mb-1">
                          <label id="g_label" class="text-info font-weight-bold"></label>
                          <div class="row" id="preview_img">
                            <!-- will preview here -->
                          </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="smsModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content" style="background-color:transparent">
            <div class="p-2 bg-white rounded">
                <div class='cross'>
                    <button type="button" class="border-0 cancel_icon" data-bs-dismiss="modal" style="background-color: ">
                        <i class="bi bi-x"></i>
                    </button>
                </div>
                <div class='p-4'>
                    <form id="send" method="post" enctype="multipart/form-data">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                        <input type="hidden" name="uid" id="uid" value="{{$record->user_id}}">
                        <div class="mb-3">
                            <label for="title" class="form-label">Enter Title</label>
                            <input type="text" class="form-control  rounded-pill bg-light_c" id="title" name="title" aria-describedby="emailHelp" placeholder='Title'>
                        </div>
                        <div class="mb-3">
                            <label for="hosts" class="form-label label">Hosts</label>
                            <select  id="hosts" class="form-select rounded-pill bg-light cat" name="hosts">
                                <option value="">Select</option>
                                @foreach(sms_host_list() as $host)
                                    <option value="{{$host->id}}" @if($host->is_default == 1) selected @endif>{{$host->name}}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="mb-3 position-relative">
                            <label for="text" class="form-label">Description</label>
                            <textarea class="form-control bg-light_c rounded cat" id="text" name="text" rows="6"></textarea>
                            <!-- <div class="position-absolute bottom-0 p-2">
                                <button type="button" class="btn btn-info rounded-pill col-upload border-0 epicker" data-type='picker' style=' background-color: transparent;'>
                                <i class="bi bi-emoji-smile-fill"></i>
                                Emoji
                            </button>
                            </div> -->
                        </div>
                        <div class="container text-center">
                            <div class='d-grid'>
                                <button class="btn btn-primary col-bt rounded-pill my-4" type="submit">Send</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="notificationModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content" style="background-color:transparent">
            <div class="p-2 bg-white rounded">
                <div class='cross'>
                    <button type="button" class="border-0 cancel_icon" data-bs-dismiss="modal" style="background-color: ">
                        <i class="bi bi-x"></i>
                    </button>
                </div>
                <div class='p-4'>
                    <form id="sendNotify" method="post" enctype="multipart/form-data">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                        <input type="hidden" name="uid" id="uid" value="{{$record->user_id}}">
                        <div class="row">
                            <div class="mb-3">
                                <label for="exampleInputEmail1" class="form-label label">{{ trans('admin.title') }}</label>
                                <input type="text" class="form-control rounded-pill bg-light_c @error('title') is-invalid @enderror" name="title" value="{{ old('title') }}">
                            </div>
                            <div class="mb-3">
                                <label for="hosts" class="form-label label">Hosts</label>
                                <select  id="hosts" class="form-select rounded-pill bg-light cat" name="hosts">
                                    <option value="">Select</option>
                                    @foreach(notification_host_list() as $host)
                                        <option value="{{$host->id}}" @if($host->is_default == 1) selected @endif>{{$host->name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="mb-3 position-relative">
                                <label for="exampleFormControlTextarea1" class="form-label label">{{ trans('admin.message') }}</label>
                                <textarea style="min-height: 200px !important;" data-emojiable="true" data-emoji-input="unicode" class="form-control bg-light_c textarea-round cat @error('message') is-invalid @enderror" name="message" rows="8" placeholder="{{ trans('admin.type_here') }}"></textarea>
                                
                                <div class="btn-group position-absolute bottom-0 p-2" role="group" aria-label="Basic example">
                                    <!-- <button type="button" class="btn btn-info col-upload border-0" style=' background-color: transparent;'>
                                        <i class="bi bi-image-fill"></i> {{ trans('admin.photo') }}
                                    </button> -->
                                    <button type="button" class="btn btn-info col-upload border-0 epicker" data-type='picker' style=' background-color: transparent;'>
                                        <i class="bi bi-emoji-smile-fill"></i> {{ trans('admin.emoji') }}
                                    </button>
                                </div>
                            </div>
                            <div class="container text-center">
                                <div class='d-grid'>
                                    <button class="btn btn-primary col-bt rounded-pill my-4" type="submit">{{ trans('admin.send') }}</button>
                                </div>
                            </div>    
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
	CKEDITOR.replace('message');
	CKEDITOR.replace('message2');
	CKEDITOR.replace('message3');

    // click indirectly on default emoji picker
    $(".epicker").click(function(){
        $('.emoji-picker').click();
    });

	$('.click').click(function() {
        $('#active_btn').click();
    });

    $('.new_Btn').click(function() {
        $('#html_btn').click();
    });

    $(document).ready(function(){
        $('#active_btn').on('change', function(){ //on file input change
          if (window.File && window.FileReader && window.FileList && window.Blob) //check File API supported browser
          {
            var data = $(this)[0].files; //this file data
            //$("#g_label").html('{{trans("home.product_image_txt")}}');
            $.each(data, function(index, file){ //loop though each file
              //if(/(\.|\/)(gif|jpe?g|png|pdf|docx)$/i.test(file.type)){ //check supported file type
                var fRead = new FileReader(); //new filereader
                fRead.onload = (function(file){ //trigger function on successful read
                return function(e) {
                  var img = $('<div class="col-2 text-center" id="RemoveIMG'+index+'">\
                      <div style="position: relative;">\
                        <label for="prewImg'+index+'">\
                          <img src="'+e.target.result+'" class="w-100 img rounded" width="100%" style="height: 60px;"/>\
                      </div>\
                      <div onclick="RemoveIMG('+index+');" class="p-2" style="position: absolute; top: -10px; background-color: red; color: white; border-radius: 50px; opacity: 0.8;">\
                        <i class="fa fa-close"></i>\
                      </div>\
                    </div>'); //create image element 
                  $('#preview_img').append(img); //append image to output element
                };
                })(file);
                fRead.readAsDataURL(file); //URL representing the file's data.
              /*} else{
                console_log('file type error');
              }*/
            }); 
          }else{
            console_log('browser support error');
          }
        });
      });
</script>
<link href="{{ asset('assets/plugins/emoji-picker/lib/css/emoji.css') }}" rel="stylesheet">
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/config.js') }}"></script>
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/util.js') }}"></script>
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/jquery.emojiarea.js') }}"></script>
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/emoji-picker.js') }}"></script>

<script>
$(function () {
    // Initializes and creates emoji set from sprite sheet
    window.emojiPicker = new EmojiPicker({
        emojiable_selector: '[data-emojiable=true]',
        assetsPath: '{{ asset("assets/plugins/emoji-picker/lib/img/") }}',
        popupButtonClasses: ''
    });
    window.emojiPicker.discover();
});
</script>
@endsection
@section('custom-js')
@include('nadel.providers.provider_dashboarJS')
@endsection
