@extends('admin.layout.master')
@section('content')
<form method="POST" action="{{url('providers/update-provider')}}" enctype="multipart/form-data">
    <input type="hidden" name="id" value="{{Crypt::Encrypt($record->id)}}">
    @csrf
    <div class='bg-white p-2 rounded m-2'>
        <div class="row  justify-content-between p-2 rounded m-2  bg-light">
            <div class="col-6 col-md-6 align-self-center">
                <a class='text-decoration-none fw-bold  text-dark breadc' href="">
                Home / Provider Edit
                </a>
            </div>
            <div class="col-6 col-md-6 align-self-center ">
                <div class='float-end'>
                    <!-- switch start  -->
                    <div class=" d-flex mt-1">
                        <div><p class='pt-1 pe-2 text-muted'>Business Status</p></div>
                        <div class='px-2'>
                            <label class="switch">
                            <input type="checkbox" name="open_status" id="togBtn" @if (!$record->open_status == 0)
                                checked
                            @endif>
                            <div class="slider round">
                            <!--ADDED HTML -->
                            <span class="on">ON</span>
                            <span class="off">OFF</span>
                            </div>
                            </label>
                        </div>
                    </div>
                    <!-- switch end  -->
                </div>
            </div>
        </div>
        <div class='p-3'>
            <div class="row flex-column-reverse flex-md-row">
                <div class="col-md-12">
                    @if (session()->has('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session()->get('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @elseif(session()->has('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session()->get('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                </div>
                <div class="col-md-8">
                    <div class="row">
                        <div class="col-md-6 col-12">
                            <div class="mb-3">
                                <label for="exampleInputEmail1" class="form-label">Enter Business Name</label>
                                <input type="text" class="form-control rounded-pill bg-light @error('business_name') is-invalid @enderror" name="business_name" value="{{$record->business_name}}"  id="exampleInputEmail1" placeholder="Name" aria-describedby="emailHelp"  >
                                @error('business_name')
                                    <span class="text-danger">{{$message}}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                            <label for="exampleInputEmail1" class="form-label">Select Category</label>
                            <select  id=" Select" class="form-select rounded-pill bg-light cat @error('category') is-invalid @enderror" name="category">
                                    <option value="">Select</option>
                                    @foreach ($types as $item)
                                        @php $selected = ($item->id == $record->vendor_type_id ? "selected" : "") @endphp
                                        <option {{$selected}} value="{{$item->id}}">{{ (Auth::user()->id) ?  $item->name_en  :  $item->name_ar }}</option>
                                    @endforeach
                                </select>
                                @error('category')
                                    <span class="text-danger">{{$message}}</span>
                                @enderror
                            </div>
                        </div>
                    
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="exampleInputEmail1" class="form-label" >Enter Email</label>
                                <input type="text" class="form-control @error('email') is-invalid @enderror rounded-pill bg-light" name="email" value="{{$record->user->email}}"  id="exampleInputEmail1" placeholder="Email" aria-describedby="emailHelp">
                                @error('email')
                                    <span class="text-danger">{{$message}}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="exampleInputEmail1" class="form-label">password</label>
                                <input type="text" class="form-control rounded-pill bg-light" name="password" value=""  id="exampleInputEmail1" placeholder="password" aria-describedby="emailHelp">
                            </div>
                        </div>
                    
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="exampleInputEmail1" class="form-label">Enter Address</label>
                                <input type="text" class="form-control rounded-pill bg-light" name="address" value="{{$record->address}}"  id="exampleInputEmail1" placeholder="Adress" aria-describedby="emailHelp">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="exampleInputEmail1" class="form-label">Enter Coordinates</label>
                                <input type="text" class="form-control rounded-pill bg-light" name="coordinates" value="{{$record->coordinates}}"  id="exampleInputEmail1" placeholder="Coordinates" aria-describedby="emailHelp">
                            </div>
                        </div>
                    
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="exampleInputEmail1" class="form-label">Mobile NO</label>
                                <input type="text" class="form-control rounded-pill bg-light" name="mobile" value="{{$record->user->mobile}}"  id="exampleInputEmail1" placeholder="Mobile No" aria-describedby="emailHelp">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="exampleInputEmail1" class="form-label">Enter Landline</label>
                                <input type="text" class="form-control rounded-pill bg-light" name="landline"  id="exampleInputEmail1" placeholder="Landline" aria-describedby="emailHelp" value="{{$record->landline}}">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="container mt-lg-2 pt-3 ">
                        <label class="upload-btn-wrapper bg-light_c" for="file">
                            <img src="{{ asset($record->user->photo) }}" class="img-fluid" alt="" id="preview">
                            <span class=" p-1 text-start"><i class="bi bi-camera pe-1"></i>Click Here</span>
                            @error('photo') 
                                <br><span class="text-danger">{{ $message }}</span> 
                            @enderror
                        </label>
                        <input type="file" name="photo" id="file" class="d-none  bg-light_c" onchange="itemname(event)" />
                    </div>
                </div>
            </div>
            <div class='row my-3 '>
                <div class="col-sm-8 overflow-auto p-2 bg-light rounded align-self-center">

                    <table class='table table-borderless p-2 '>
                        <tr>
                            <td>
                                <!-- switch start  -->
                                <div class=" d-flex">
                                    <div><p class='pt-1 pe-2'>Rooms</p></div>
                                <div class='px-2'>
                                    <label class="switch">
                                    <input type="checkbox" name="rooms_status" id="togBtn" @if (!$record->rooms_status == 0 )
                                        checked
                                    @endif>
                                    <div class="slider round">
                                    <!--ADDED HTML -->
                                    <span class="on">ON</span>
                                    <span class="off">OFF</span>
                                    </div>
                                    </label>
                                </div>
                            </div>
                            <!-- switch end  -->
                            </td>
                            <td>
                            <!-- switch start  -->
                            <div class=" d-flex">
                                    <div><p class='pt-1 pe-2'>Tables</p></div>
                                <div class='px-2'>
                                    <label class="switch">
                                    <input type="checkbox" name="table_status" id="togBtn"@if (!$record->tables_status == 0 )
                                        checked
                                    @endif>
                                    <div class="slider round">
                                    <!--ADDED HTML -->
                                    <span class="on">ON</span>
                                    <span class="off">OFF</span>
                                    </div>
                                    </label>
                                </div>
                            </div>
                            <!-- switch end  -->
                            </td>
                            <td>
                            <!-- switch start  -->
                            <div class=" d-flex">
                                <div><p class='pt-1 pe-2'>Featured</p></div>
                                <div class='px-2'>
                                    <label class="switch">
                                    <input type="checkbox" name="featured" id="togBtn" @if (!$record->featured == 0 )
                                        checked
                                    @endif>
                                    <div class="slider round">
                                    <!--ADDED HTML -->
                                    <span class="on">ON</span>
                                    <span class="off">OFF</span>
                                    </div>
                                    </label>
                                </div>
                            </div>
                            <!-- switch end  -->
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
            <button type='sumbit ' class='btn btn-success btn-color rounded-pill text-light px-lg-5'> Update</button>
        </div>
    </div>
</form>
<script>
    function itemname(event) {
        var preview = document.getElementById("preview");
        preview.src = URL.createObjectURL(event.target.files[0]);
    }
</script>
@endsection