@extends('admin.layout.master')
@section('content')
<div class='bg-white p-2 rounded m-2'>
    <div class="row   justify-content-between p-2 rounded m-2  bg-light">
        <div class="col-6 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold  text-dark breadc' href="">
                {{__('nadel.home')}} / {{__('nadel.account_state')}}
            </a>
        </div>
    </div>
    <div class='p-3'>
        <form method="POST" action="{{route('provider_account_status_reason')}}" enctype="multipart/form-data">
            @csrf
            <input type="hidden" name="id" value="{{$post->id}}">
            <div class="row">
                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session()->get('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @elseif(session()->has('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        {{ session()->get('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
                <div class="col-md-4 col-12">
                    <div class="mb-3">
                        <label for="status" class="form-label label">{{__('nadel.status')}}</label>
                        <select  id="status" class="form-select rounded-pill bg-light cat" name="status">
                            <option value="">Select</option>
                            <option value="1" @if($post->status == 1) selected @endif>Active</option>
                            <option value="0" @if($post->status == 0) selected @endif>Inactive</option>
                        </select>
                        @error('status')
                            <small class="text-danger">{{$message}}</small>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="reason" class="form-label label">{{__('nadel.reason')}}</label>
                        <textarea type="text" class="form-control bg-light_c @error('reason') is-invalid @enderror" name="reason" id="reason" rows="5"></textarea>
                        @error('reason')
                            <small class="text-danger">{{$message}}</small>
                        @enderror
                    </div>
                </div>
            </div>
            <button type='sumbit ' class='btn btn-success btn-color rounded-pill text-light px-5'> {{__('nadel.save')}}</button>
        </form>
    </div>
</div>
@endsection
