@extends('admin.layout.master')
@section('content')
<div class="container">
    <div class="row   justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-6 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold  text-dark breadc' href="">
            Home / Providers / {{(Auth::user()->locale == "en") ? $record->item_name_en : $record->item_name_ar}}
            </a>
        </div>
    </div>

    <div class="card p-3 m-2 mt-3">
        <form method="post" action="{{url('items/update')}}" enctype="multipart/form-data">
            @csrf
            <div class="row  ">
                @if (session()->has('success'))
                    <div class="alert alert-warning">
                        {{session()->get('success')}}
                    </div>
                @endif
                <div class="col-sm-5">
                    <div class="mb-3">
                        <label for="exampleInputEmail1" class="form-label">Enter Category Name (English)</label>
                        <input type="text" class="form-control @error('name_en') is-invalid @enderror  rounded-pill bg-light_c" id="exampleInputEmail1" name= "name_en" aria-describedby="emailHelp" value='{{$record->item_name_en}}'>
                        @error('name_en')
                            <small class="text-danger">{{$message}}</small>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="exampleInputEmail1" class="form-label">Enter Category Name (English)</label>
                        <input type="text" class="form-control @error('name_ar') is-invalid @enderror   rounded-pill bg-light_c" id="exampleInputEmail1" name= "name_ar" aria-describedby="emailHelp" value='{{$record->item_name_ar}}'>
                        @error('name_ar')
                            <small class="text-danger">{{$message}}</small>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="exampleInputEmail1" class="form-label">Enter Price</label>
                        <input type="text" class="form-control @error('price') is-invalid @enderror  rounded-pill bg-light_c" id="exampleInputEmail1"  name= "price"aria-describedby="emailHelp" value='{{$record->price}}'>
                        @error('price')
                            <small class="text-danger">{{$message}}</small>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="exampleInputEmail1" class="form-label">Select Time</label>
                        <input type="text" class="form-control @error('time') is-invalid @enderror   rounded-pill bg-light_c" id="exampleInputEmail1" name= "time" aria-describedby="emailHelp" value='{{$record->time}}'>
                    </div>
                    <div class="mb-3">
                        <label for="exampleInputPassword1" class="form-label">Select Category</label>
                        <select id=" Select" name ="category" class="form-select @error('category') is-invalid @enderror  rounded-pill bg-light_c cat">
                            <option value="">select</option>
                            @foreach ($itemCategory as $item)
                                @php
                                    $selected = ($item->id == $record->vendor_cat_id) ? "selected" : "";
                                @endphp
                                <option value="{{$item->id}}" {{$selected}}>{{(Auth::user()->locale) ? $item->name_en : $item->name_ar}}</option>
                            @endforeach
                        </select>
                        @error('category')
                            <small class="text-danger">{{$message}}</small>
                        @enderror
                    </div> <br>
                    <!-- switch start  -->
                    <div class="d-flex  mob_just">
                        <label for="default" class="ms-2 mb-1">Status </label>
                        <label class="switch ms-5">
                            <input type="checkbox" name="status" id="default" {{($record->status == 1) ? "checked" : ""}} >
                            <div class="slider round">
                                <!--ADDED HTML -->
                                <span class="on">on</span>
                                <span class="off">off</span>
                            </div>
                        </label>
                    </div><!-- switch end  --><br><br>
                </div>
                <input type="hidden" name="id" value="{{$record->id}}">
                <div class="col-12 col-md-4">
                    <div class="mb-3">
                        <label for="exampleFormControlTextarea1" class="form-label">Description (English)</label>
                        <textarea class="form-control bg-light_c @error('description_en') is-invalid @enderror rounded cat" name="description_en" rows="4">{{$record->item_description_en}}</textarea>
                        @error('description_en')
                            <small class="text-danger">{{$message}}</small>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="exampleFormControlTextarea1" class="form-label">Description (Arabic)</label>
                        <textarea class="form-control bg-light_c @error('description_ar') is-invalid @enderror  rounded cat" name="description_ar" rows="4">{{$record->item_description_ar}}</textarea>
                        @error('description_ar')
                            <small class="text-danger">{{$message}}</small>
                        @enderror
                    </div>
                </div>
                <div class="col-12 col-md-2">
                    <div class="container">
                        <label class="upload-btn-wrapper bg-light_c" for="file"> <span class="text_img">Photo</span>
                            <img src="{{asset($record->photo)}}" name="photo" class="img-fluid" id="preview">
                        </label>
                        <input type="file" name="photo" id="file" class="d-none" onchange="itemname(event)" />
                    </div>
                    @error('photo')
                        <small class="text-danger">{{$message}}</small>
                    @enderror
                </div>

            </div>
            <!-- row ended here  -->
            <div class="container bg-light rounded ">
                <div class="col-md-6 offset-md-5">
                    <div class="upload-btn-wrapper bg-light " style="background-color: transparent; height:57px; width:200px;">
                        <button class="border-0 mt-4" style=' background-color: transparent; color:rgba(84, 58, 178, 1);'>
                            DROP OR CLICK TO UPLOAD
                        </button>
                        <input type="file" id="file-input" name="slider[]" accept="image/png, image/jpeg" onchange="previewa()" multiple>
                    </div>
                </div>
            </div>
            <div class="container my-4">
                <p id="num-of-files">No Files Chosen</p>

                <div class="row my-2" id="current_images">
                    @foreach ($record->gallery as  $row)
                    <div class='col-2 shadow-sm p-0 mx-2 my-2 overflow-hidden' style='height:200px;''>
                            <span data-id = "{{$row->id}}" class='position-absolute remove-img' style='margin:-15px 0px 0px -10px;cursor:pointer'><i class='bi bi-x-circle-fill text-danger fs-5 position-absolute'></i></span>
                            <img class='img-fluid rounded shadow-sm' src='{{asset($row->photo)}}'> <small></small>
                        </div>
                    @endforeach

                </div>
                <div class="row my-2" id="images">

                </div>
                <button type="submit" class="btn btn-warning col-bt rounded-pill mt-4 text-white">Update</button>
            </div>
        </form>
    </div>
</div>
<style>
    .form-control,
    .cat {
        font-size: 14px;
        color: #383838;
    }

</style>
<script>

 </script>
<script>
    function itemname(event) {
        var preview = document.getElementById("preview");
        preview.src = URL.createObjectURL(event.target.files[0]);
    }
</script>
<script>
    function multi(event) {
        var preview = document.getElementById("pre");
        preview.src = URL.createObjectURL(event.target.files[0]);
    }
</script>
<script>
    let fileInput = document.getElementById("file-input");
    let imageContainer = document.getElementById("images");
    let numOfFiles = document.getElementById("num-of-files");

    function previewa() {
        try {
            imageContainer.innerHTML = "";
            numOfFiles.textContent = fileInput.files.length + 'Files Selected';

            for (i of fileInput.files) {
                let reader = new FileReader();
                reader.onload = () => {
                    // console.log(i);
                    imageContainer.innerHTML += "\
                        <div class='col-2 img-div shadow-sm p-0 mx-2 my-2 overflow-hidden' style='height:200px;''>\
                            <span data-id='0' class='position-absolute remove-img' style='margin:-15px 0px 0px -10px; cursor:pointer;'><i class='bi bi-x-circle-fill text-danger fs-5 position-absolute'></i></span>\
                            <img class='img-fluid rounded shadow-sm' src='"+reader.result+"'> \
                        </div>\
                    ";
                }

                reader.readAsDataURL(i);
            }
        } catch (error) {
            console.log(error);
        }
    }

    // function removeFile(index) {
    //     // console.log("Test = "+index);
    //     // var a = $(this).text() ;
    //     // alert(a);
    //    $(this).closest('.img-div').remove();
    // }
    $('body').on('click','.remove-img',function () {
        let  item_id = $(this).data('id');
        if(!item_id == 0){
            try {

                 loading();
                    $.ajax({
                        url: '{{url("/item-gallery/delete")}}/'+item_id,
                        type: 'get',
                    })
                    .done(function(response) {
                        // console.log(response);
                        loading("stop");
                        // swal(response.text.response.cls);

                    })
                    .fail(function() {
                        console.log("error");
                    })
                    .always(function() {
                        loading("stop");
                    });

            } catch (error) {
                loading("stop");
                console.log(error);
            }
        }
        $(this).parent().remove();
    });
</script>
@endsection
