@extends('admin.layout.master')
@section('content')
<div class="container">
    <div class="row   justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold text-dark breadc' href="">
                Make a Payment
            </a>
        </div>
    </div>
    <nav class="nav border bg-light rounded align-items-center m-2 mt-3">
        <ul class="nav tabbs" id="mytab">
            <li class="nav-item">
                <a class="nav-link text-muted active fw-bolder text-dark " data-toggle='pill' aria-current="page" href="#CUS">Customer Tab</a>
            </li>
            <li class="nav-item">
                <a class="nav-link text-muted" data-toggle='pill' href="#PRO">Provider Tab</a>
            </li>
        </ul>
    </nav>
    <div class='tab-content'>
        <div class="col-12">
            @if (session()->has('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session()->get('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @elseif(session()->has('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ session()->get('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
        </div>
        <div id='CUS' class='tab-pane fade show active'>
            <div class="container">
                <div class="row p-2 ">
                    <div class="border rounded p-2">
                        <div class="col-md-5 p-3">
                            <form action="{{route('customer_payment')}}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="mb-3">
                                    <label for="customer_id" class="form-label">Select Customer</label>
                                    <select id="customer_id" name="customer_id" class="form-select rounded-pill bg-light_c cat @error('customer_id') is-invalid @enderror">
                                        <option value="">Select</option>
                                        @foreach ($dataAry['customers'] as $data)
                                            <option value="{{$data->id}}">{{$data->name}}</option>
                                        @endforeach
                                    </select>
                                    @error('customer_id') 
                                        <span class="text-danger">{{ $message }}</span> 
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="customer_amount" class="form-label">Enter Amount</label>
                                    <input type="number" class="form-control  rounded-pill bg-light_c @error('customer_amount') is-invalid @enderror" id="customer_amount" name="customer_amount" aria-describedby="emailHelp" placeholder='Amount'>
                                    @error('customer_amount') 
                                        <span class="text-danger">{{ $message }}</span> 
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="cus_description" class="form-label">Description</label>
                                    <textarea class="form-control bg-light_c rounded cat @error('cus_description') is-invalid @enderror" id="cus_description" name="cus_description" rows="4" placeholder="Type here"></textarea>
                                    @error('cus_description') 
                                        <span class="text-danger">{{ $message }}</span> 
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="cus_description_ar" class="form-label">Description(arabic)</label>
                                    <textarea class="form-control bg-light_c rounded cat @error('cus_description_ar') is-invalid @enderror" id="cus_description_ar" name="cus_description_ar" rows="4" placeholder="Type here"></textarea>
                                    @error('cus_description_ar') 
                                        <span class="text-danger">{{ $message }}</span> 
                                    @enderror
                                </div>
                                <button type="submit" class="btn btn-warning col-bt rounded-pill mt-4 text-white">Review</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- one here complete  -->
        <div id='PRO' class='tab-pane fade show '>
            <div class="container">
                <div class="border rounded p-2">
                    <div class="row p-2  flex-column-reverse flex-md-row">
                        <div class="col-md-5 p-3">
                            <form action="{{route('provider_payment')}}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="mb-3">
                                    <label for="provider_id" class="form-label">Select Provider</label>
                                    <select id="provider_id" name="provider_id" class="form-select rounded-pill bg-light_c cat @error('provider_id') is-invalid @enderror">
                                        <option value="">Select</option>
                                        @foreach ($dataAry['providers'] as $data)
                                            <option value="{{$data->id}}">{{$data->name}}</option>
                                        @endforeach
                                    </select>
                                    @error('provider_id') 
                                        <span class="text-danger">{{ $message }}</span> 
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="provider_amount" class="form-label">Amount</label>
                                    <input type="number" class="form-control  rounded-pill bg-light_c @error('provider_amount') is-invalid @enderror" id="provider_amount" name="provider_amount" aria-describedby="emailHelp" placeholder='Amount'>
                                    @error('provider_amount') 
                                        <span class="text-danger">{{ $message }}</span> 
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="provider_description" class="form-label">Description</label>
                                    <textarea class="form-control bg-light_c rounded cat @error('provider_description') is-invalid @enderror" id="provider_description" name="provider_description" placeholder="Type here" rows="4"></textarea>
                                    @error('provider_description') 
                                        <span class="text-danger">{{ $message }}</span> 
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="provider_description_ar" class="form-label">Description(arabic)</label>
                                    <textarea class="form-control bg-light_c rounded cat @error('provider_description_ar') is-invalid @enderror" id="provider_description_ar" name="provider_description_ar" rows="4" placeholder="Type here"></textarea>
                                    @error('provider_description_ar') 
                                        <span class="text-danger">{{ $message }}</span> 
                                    @enderror
                                </div>
                                <button type="submit" class="btn btn-warning col-bt rounded-pill mt-4 text-white">Review</button>
                            </form>
                        </div>
                        <div class="col-md-5">
                            <div class="wallet mt-2">
                                <p class="text-muted fw-bold">Wallet</p>
                                <p class="fs-3 fw-bold text-dark"><span id="wallet_amount">$0.00</span></p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        $("#mytab a").click(function(e) {
            e.preventDefault();
            $(this).tab('show');
        });
    });

    $('body').on('change','#provider_id',function(e){
        e.preventDefault();
        loading('start');
        var id = $("#provider_id").val();
        if (id != "") {
            $.ajax({
                url: '{{url("/payment/provider_wallets")}}/'+id,
                type: 'get',
                dataType:'json',
            })
            .done(function (res) {
                $("#wallet_amount").html(res.wallet_amount);
            })
            .fail(function () {
                console.log("error");
            }).always(function(){
                loading("stop");
            });
        }else{
            loading("stop");
        }
    });
</script>
@endsection