@extends('admin.layout.master')
@section('content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.min.css">
<!-- <style>
    .card{
        transition:0.2s;
    }
    .card:hover {
        box-shadow: 0 0 11px rgba(33,33,33,.2) !important;
    }
</style> -->
<!-- body content  -->
<div class="card-dashboard rounded border-0 p-2">
	<div class="p-0 card-body p-md-2">
		<div class="p-3 rounded mb-2 clearfix shadow-sm">
	   		<div class="row align-items-center">
              	<div class="col-md-4">
	                <h3 class="font-500">{{ trans('admin.welcome')}}
	                    <span class="text" style="font-weight:600;">{{$username}}</span>
	                </h3>
	                <a href="{{url('/qa')}}" class="btn mt-2 rounded-pill px-3 alert-success btn-sm">{{ trans('admin.new_Question')}}</a>
	                <a href="{{url('/category')}}" class="btn mt-2 rounded-pill px-3 alert-danger btn-sm ms-2">{{ trans('admin.new_Category')}}</a>
            	</div>
				<div class="col mt-3 mt-md-0">
					<div class="row row-cols-2 row-cols-md-4 row-cols-sm-2 g-3 align-items-center">
				        <!-- color cards  -->
				        <div class="col ms-auto">
				          <div class="card alert-warning">
				            <div class="card-body clearfix">
				              	<div class="card-icon float-end">
				                	<i class="bi-people" style="font-size: 2.3em"></i>
				            	</div>
					            <h5 class="card-title font-weight-bold">
					                <a  class="text-warning no-deco" href="{{url('/user')}}">{{$total_user}}</a>
					            </h5>
				                <p class="card-text font-weight-bold text_arbic_view">{{trans('admin.total_Users')}}</p>
				            </div>
				            </div>
				        </div>
					    <div class="col">
					      	<div class="card alert-danger">
						        <div class="card-body">
						          	<div class="card-icon float-end">
						            	<i class="bi-check-all" style="font-size: 2.3em"></i>
							        </div>
							        <h5 class="card-title font-weight-bold">
							          <a class="text-danger no-deco" href="{{url('/user')}}"></a>
							    	</h5>
							    	<p class="card-text font-weight-bold">{{trans('admin.total_Teachers')}}</p>
								</div>
							</div>
						</div>

				        <div class="col">
				          	<div class="card alert-success">
				                <div class="card-body">
				                  	<div class="card-icon float-end">
				                    	<i class="bi-people" style="font-size: 2.3em"></i>
				                	</div>
				                	<h5 class="card-title font-weight-bold">
				                 		<a class="text-success no-deco" href="{{url('/user')}}"></a>
				             		</h5>
				                 	<p class="card-text font-weight-bold">{{trans('admin.total_Students')}}</p>
				             	</div>
				     		</div>
						</div>

						<div class="col">
						  	<div class="card alert-primary">
							    <div class="card-body">
							      	<div class="card-icon float-end">
							        	<i class="bi-layers" style="font-size: 2.3em"></i>
								    </div>
								    <h5 class="card-title font-weight-bold">
								      <a class="text-primary no-deco" href="{{url('/qa')}}" ></a>
									</h5>
									<p class="card-text font-weight-bold">{{trans('admin.Total_Questions')}}</p>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<!-- <div class="row row-cols-sm-1 g-2 row-cols-md-2 row-cols-lg-3">
		    <!-- graph 1 --
		    <div class="col h-100">
		        <div class="card shadow-sm border-0">
		          	<div class="card-header border-0 bg-white d-flex justify-content-between align-items-center py-1 px-1">
			            <p class="smal mb-0 pl-2"> Encome Expense </p>
			            <button type="button" class="btn btn-white px-1 py-0" id="btn-collapse" data-toggle="collapse" data-target="#graph1" aria-expanded="false" aria-controls="graph1">
			                <i class="fa fa-chevron-down"></i>
			            </button>
			        </div>

			        <div id="graph1" class="collapse show" role="alert">
			            <div class="card-body">

			              <canvas id="incomeTax"></canvas>

			          </div>
			      	</div>
			  	</div>
			</div>

			<!-- graph 2 --
			<div class="col h-100">
			    <div class="card shadow-sm border-0">
			      	<div class="card-header border-0 bg-white d-flex justify-content-between align-items-center py-1 px-1">
				        <p class="smal mb-0 pl-2"> Sale Recovery </p>
				        <button type="button" class="btn btn-white px-1 py-0" id="btn-collapse" data-toggle="collapse" data-target="#graph2" aria-expanded="false" aria-controls="graph2">
				            <i class="fa fa-chevron-down"></i>
				        </button>
			    	</div>

				    <div id="graph2" class="collapse show">
				        <div class="card-body">
				            <canvas id="customerSales"></canvas>
				        </div>
				    </div>
				</div>
			</div>

			<!-- graph 3 --
			<div class="col h-100">
			    <div class="card shadow-sm border-0">
			        <div class="card-header border-0 bg-white d-flex justify-content-between align-items-center py-1 px-1">
			          <p class="smal mb-0 pl-2">expenses trend</p>
			          <button type="button" class="btn btn-white px-1 py-0" id="btn-collapse" data-toggle="collapse" data-target="#graph3" aria-expanded="false" aria-controls="graph3">
			              <i class="fa fa-chevron-down"></i>
			          </button>
				      </div>

				      <div id="graph3" class="collapse show">
				          <div class="card-body">

				            <canvas id="expenseBreakdown" ></canvas>

				        </div>
				    </div>
				</div>
			</div>
		</div> --> <!-- rows-cols end -->

		<div class="row g-2" id="dash-card2">
            <div class="col-md-4">
                <div class="card shadow-sm border-0 pt-3 mb-2">
                    <div class="card-header border-0 py-1 d-flex align-items-center pl-3">
                        <h6 class="p-2 rtl_res alert-warning text-warning rounded-circle ">
                            <i class="bi-app-indicator" style="font-size: 2.3em"></i>
                        </h6>
                        <h4 class="mb-0 pl-2 mx-2 text-warning">{{trans('admin.Course')}}</h4>
                    </div>
                    <div class="card-body px-0">
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('admin.Total')}}
                                <span class="badge alert-success rounded-pill py-2 px-3"></span>
                            </li>
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('admin.Active')}}
                                <span class="badge alert-warning rounded-pill py-2 px-3"></span>
                            </li>
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('admin.Unactive')}}
                                <span class="badge alert-danger rounded-pill py-2 px-3"></span>
                            </li>
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('admin.Deleted')}}
                                <span class="badge alert-primary rounded-pill py-2 px-3"></span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card shadow-sm border-0 pt-3 mb-2">
                    <div class="card-header border-0 py-1 d-flex align-items-center pl-3">
                        <h6 class="p-2 rtl_res alert-danger text-danger rounded-circle align-self-center">
                        	<i class="bi-layers" style="font-size: 2.3em"></i>
                        </h6>
                        <h4 class="mb-0 pl-2 mx-2 text-danger">{{trans('admin.Guide')}}</h4>
                    </div>
                    <div class="card-body px-0">
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('admin.Total')}}
                                <span class="badge alert-success rounded-pill py-2 px-3"></span>
                            </li>
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('admin.Active')}}
                                <span class="badge alert-warning rounded-pill py-2 px-3"></span>
                            </li>
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('admin.Unactive')}}
                                <span class="badge alert-danger rounded-pill py-2 px-3"></span>
                            </li>
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('admin.Deleted')}}
                                <span class="badge alert-primary rounded-pill py-2 px-3"></span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card shadow-sm border-0 pt-3 mb-2">
                    <div class="card-header border-0 py-1 d-flex align-items-center pl-31">
                        <h6 class="p-2 rtl_res alert-success text-success rounded-circle align-self-center">
                        	<i class="bi-layers" style="font-size: 2.3em"></i>
                        </h6>
                        <h4 class="mb-0 pl-2 mx-2 text-success">{{trans('admin.Documents')}}</h4>
                    </div>
                    <div class="card-body px-0">
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('admin.Total')}}
                                <span class="badge alert-success rounded-pill py-2 px-3"></span>
                            </li>
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('admin.Active')}}
                                <span class="badge alert-warning rounded-pill py-2 px-3"></span>
                            </li>
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                               {{trans('admin.Unactive')}}
                                <span class="badge alert-danger rounded-pill py-2 px-3"></span>
                            </li>
                            <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                {{trans('admin.Deleted')}}
                                <span class="badge alert-primary rounded-pill py-2 px-3"></span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

		<div class="row g-2">
            <div class="col-md-4">
                <div class="card shadow-sm border-0 p-3 mb-2">
                    <div class="card-header border-0 py-1  px-1">
                        <h4 class="mb-0 pl-1 mt-3">{{trans('admin.New_Users')}}</h4>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive table-scroll p-0" style="min-height: 185px; max-height: 185;">
                            <table class="table table-sm table-hover mb-0">
                                <thead>
                                    <tr class="text-center">
                                        <th class="text-lowercase">{{trans('admin.id')}}</th>
                                        <th class="text-left">{{trans('admin.Name')}}</th>
                                        <th class="text-left">{{trans('admin.Mobile')}}</th>
                                        <th class="text-left">{{trans('admin.Email')}}</th>
                                    </tr>
                                </thead>
                                <tbody class="text-center" id="entries">
                                    @foreach($user as $row)
                                    	<tr id="{{$row->id}}">
                                    		<td>{{$row->id}}</td>
                                    		<td>{{$row->name}}</td>
                                    		<td>{{$row->mobile}}</td>
                                    		<td>{{$row->email}}</td>
                                    	</tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card shadow-sm border-0 p-3 mb-2">
                    <div class="card-header border-0 py-1  px-1">
                        <h4 class="mb-0 pl-1 mt-3">{{trans('admin.New_Teachers')}}</h4>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive table-scroll p-0" style="min-height: 185px; max-height: 185;">
                            <table class="table table-danger table-sm table-hover mb-0 table-bordered">
                                <thead>
                                    <tr class="text-center">
                                        <th class="text-lowercase">{{trans('admin.id')}}</th>
                                        <th class="text-left">{{trans('admin.name')}}</th>
                                        <th class="text-left">{{trans('admin.mobile')}}</th>
                                        <th class="text-left">{{trans('admin.email')}}</th>
                                    </tr>
                                </thead>
                                <tbody class="text-center" id="entries">

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card shadow-sm border-0 p-3 mb-2">
                    <div class="card-header border-0 bg-white py-1  px-1">
                        <h4 class="mb-0 pl-1 mt-3">{{trans('admin.New_Students')}}</h4>
                    </div>
                    <div class="card-body px-0">
                        <div class="table-responsive table-scroll p-0" style="min-height: 185px; max-height: 185;">
                            <table class="table table-warning table-sm table-hover mb-0 table-bordered">
                                <thead>
                                    <tr class="text-center">
                                        <th class="text-lowercase">{{trans('admin.id')}}</th>
                                        <th class="text-left">{{trans('admin.Name')}}</th>
                                        <th class="text-left">{{trans('admin.Mobile')}}</th>
                                        <th class="text-left">{{trans('admin.Email')}}</th>
                                    </tr>
                                </thead>
                                <tbody class="text-center" id="entries">

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
	</div> <!-- card body end -->
</div> <!-- Card end -->


@endsection
