@extends('admin.layout.master')
@section('content')
<div class='bg-white p-2 rounded m-2'>
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold text-dark breadc' href="">
                Home/Customer List
            </a>
        </div>
        <div class="col-12 col-md-6 align-self-center float-end ">
            <div class='align-self-center  text-center justify-content-center'>
                <div class="row">

                    <div class="col-6">
                        <div>
                            <select id="status" class="form-select rounded-pill" style="font-size: 14px;">
                                <option value="1">Active</option>

                                <option value="0">In-Active</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-2">
                        <div>
                            <button type="button" class="btn btn-secondary rounded-pill clear" style="font-size: 14px;">Clear</button>
                        </div>
                    </div>
                    <div class=" col-2 " style="display: none">
                        <a class='text-decoration-none ' href="">
                            <svg xmlns=" http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 55 55">
                                <g id="Group_12506" data-name="Group 12506" transform="translate(-1134.648 -427.545)">
                                    <ellipse id="Ellipse_593" data-name="Ellipse 593" cx="27.5" cy="27.5" rx="27.5" ry="27.5" transform="translate(1134.648 427.545)" fill="#f56a20" />
                                    <path id="Path_15415" data-name="Path 15415" d="M1.438-6.844V-9.469H8.25v-6.859h2.672v6.859h6.813v2.625H10.922V0H8.25V-6.844Z" transform="translate(1153.017 463.249)" fill="#fff" />
                                </g>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class='table-responsive p-2'>
        <table class='table table-border data-table'>
            <thead>
                <tr class='tex-g'>
                    <th>{{__('nadel.id')}}</th>
                    <th>{{__('nadel.name')}}</th>
                    <th>{{__('nadel.join_on')}}</th>
                    <th>{{__('nadel.contact')}}</th>
                    <th class=''>{{__('nadel.action')}}</th>
                </tr>
            </thead>

        </table>
    </div>
</div>
@endsection
@section('custom-js')
<style>
    .dataTables_filter {
        display: none;
    }
</style>
<script type="text/javascript">
    var table = "";

    $('body').on('change', '#active-status', function(e) {
        var id = $(this).data('id');
        var status = $(this).val();
        try {
            $.ajax({
                type : 'GET',
                url : '{{url("customer/change-status")}}/'+id+'/'+status,
                success : function (res) {
                    swal(res.message,res.status);
                }
            });
        } catch (error) {
            console.log(error);
        }
    });



    $(function() {

        table = $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ url('customer') }}",
                type: 'GET',
                data: function(d) {
                    // d.category_id = $('#category').val();
                    d.status_check = $('#status').val();
                    // console.log(d);
                }
            },
            columns: [{
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'name',
                    name: 'name'
                },
                {
                    data: 'join_on',
                    name: 'join_on'
                },
                {
                    data: 'contact',
                    name: 'contact'
                },

                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                },
            ],
            "lengthMenu": [
                [10, 25, 50, 100, -1],
                [10, 25, 50, 100, "All"]
            ]
        });

    });
    $("#search_new").on("keyup search input paste cut", function() {
        table.search(this.value).draw();
    });

    $('body').on('change', '#category,#status', function(e) {
        // alert($(this).val());
        table.draw(true);
    });

    $('body').on('click', '.clear', function(e) {
        $('#category').val("");
        $('#status').val("");
        table.draw(true);
    });
</script>

@endsection
