@extends('admin.layout.master')
@section('content')
<div class='bg-white p-2 rounded m-2'>
    <div class="row   justify-content-between p-2 rounded m-2  bg-light">
        <div class="col-6 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold  text-dark breadc' href="">
                {{__('nadel.home')}} / {{__('nadel.customer_list')}}
            </a>
        </div>
    </div>
    <div class='p-3'>
        <form method="POST" action="{{url('customer/update-customer/'.$user->id)}}" enctype="multipart/form-data">
            @csrf
            <div class="row">
                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ session()->get('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @elseif(session()->has('error'))
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        {{ session()->get('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                @endif
                <div class="col-md-4 col-12">
                    <div class="mb-3">
                        <label for="exampleInputEmail1" class="form-label label">{{__('nadel.customer_name')}}</label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror bg-light_c " name="name" id="exampleInputEmail1" value="{{$user->name}}" aria-describedby="emailHelp">
                        @error('name')
                            <small class="text-danger">{{$message}}</small>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="exampleInputEmail1" class="form-label label">{{__('nadel.customer_email')}}</label>
                        <input type="email" class="form-control rounded-pill bg-light_c   " name = "email" id="exampleInputEmail1" value="{{$user->email}}" aria-describedby="emailHelp">
                    </div>
                    <div class="mb-3">
                        <label for="exampleInputEmail1" class="form-label label">{{__('nadel.customer_d_o_b')}}</label>
                        <input type="date" class="form-control rounded-pill bg-light_c   " name = "dob" id="exampleInputEmail1" value="{{$user->dob}}" aria-describedby="emailHelp">
                    </div>
                    <div class="mb-3">
                        <label for="exampleInputEmail1" class="form-label label">{{__('nadel.customer_coordinates')}}</label>
                        <input type="text" class="form-control rounded-pill bg-light_c   " name = "coordinates" id="exampleInputEmail1" value="{{$user->coordinates}}" aria-describedby="emailHelp">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="exampleInputEmail1" class="form-label label">{{__('nadel.address')}}</label>
                        <input type="text" class="form-control rounded-pill bg-light_c   "name = "address"  id="exampleInputEmail1" value="{{$user->address}}" aria-describedby="emailHelp">
                    </div>
                    <div class="mb-3">
                        <label for="exampleInputEmail1" class="form-label label">{{__('nadel.mobile')}}</label>
                        <input type="text" class="form-control @error('mobile') is-invalid @enderror rounded-pill bg-light_c   "name = "mobile"  id="exampleInputEmail1" value="{{$user->mobile}}" aria-describedby="emailHelp">
                         @error('mobile')
                            <small class="text-danger">{{$message}}</small>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="exampleInputEmail1" class="form-label label">{{__('nadel.password')}}</label>
                        <input type="text" class="form-control rounded-pill bg-light_c   "name = "password"  id="exampleInputEmail1" value="" aria-describedby="emailHelp">
                    </div>
                    <div class="mb-3">
                        <label for="exampleInputEmail1" class="form-label label">{{__('nadel.gender')}}</label>
                        <select id=" Select" name = "" class="form-select rounded-pill bg-light_c cat">
                            <option value="Male" {{($user->gender == "Male") ? 'selected' : ""}}>{{__('nadel.male')}}</option>
                            <option value="Female" {{($user->gender == "Female") ? 'selected' : ""}}>{{__('nadel.female')}}</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="container mt-2">
                        <label class="upload-btn-wrapper bg-light_c" for="file"> 
                            <img src="{{asset($user->photo)}}" class="img-fluid" alt="" id="preview">
                            <span class="text_img">{{__('nadel.click here')}}</span>
                        </label>
                        <input type="file" name="photo" id="file" class="d-none" onchange="cus(event)" />
                    </div>
                    @error('photo')
                        <small class="text-danger">{{$message}}</small>
                    @enderror
                </div>
            </div>
            <br>
            <!-- switch start  -->
            {{-- <div class="d-flex  mob_just">
                <label for="default" class="ms-2 mb-1">{{__('nadel.status')}}</label>
                <label class="switch ms-5">
                    <input type="checkbox" name="status" id="default" value="{{$user->status}}" {{($user->status == 1) ? "checked" : ""}}>
                    <div class="slider round">
                        <!--ADDED HTML -->
                        <span class="on">{{__('nadel.on')}}</span>
                        <span class="off">{{__('nadel.off')}}</span>
                    </div>
                </label>
            </div> --}}
            <!-- switch end  -->
            <br><br>
            <button type='sumbit ' class='btn btn-success btn-color rounded-pill text-light px-5'> {{__('nadel.update')}}</button>
        </form>
    </div>
</div>
<script>
    function cus(event) {
        var preview = document.getElementById("preview");
        preview.src = URL.createObjectURL(event.target.files[0]);
    }
</script>
@endsection
