<!doctype html>
<html lang="en" >
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!-- Bootstrap CSS -->
        @if($locale == 'en')
            <link rel="stylesheet" href="{{asset('assets/theme/css/bootstrap.min_latist_version.css')}}">
            <link rel="stylesheet" href="{{asset('assets/frontend/css/default.css')}}">

        @else
            <link rel="stylesheet" href="{{asset('assets/theme/css/bootstrap.rtl.min_latist_version.css')}}">
            <link rel="stylesheet" href="{{asset('assets/frontend/css/default_rtl.css')}}">
        @endif

        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.6.1/font/bootstrap-icons.css">
        <!-- online google font s
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Oswald&display=swap" rel="stylesheet">
        slider -->
        <link rel="stylesheet" href="{{asset('assets/frontend/slider/css/lightslider.css')}}">

        <title>{{($site_info->site_title)}}</title>

        <link rel="icon" href="{{asset('images/logo/'.$site_info->favicon)}}" type="image/x-icon">

    </head>
<body>
<!-- navbar start -->
@if($settings['topbar']['hide'])
<nav class="navbar navbar-expand-lg text-center fixed-top" id="nav_togller" style="background:{{$settings['topbar']['colors']['background_color']}};">
    <div class="container-fluid">

        <a class="navbar-brand" href="#">
            <img src="{{asset($settings['topbar']['photo'])}}" class="img-fluid" width="40px" alt="logo">
        </a>
        <div class="">
        <form class="d-flex d-md-none" method="POST" action="{{ route('logout') }}">
            @csrf
            @if($locale == 'en')
                <a style="text-decoration: none; " href="{{url('localeA/ar')}}" class="text-white fs-6 px-1"> <img src="{{asset('project/frontend/default/flag_arabic.png')}}" class="img-fluid" alt=""> {{trans('default.arabic')}}</a>
            @else
                <a style="text-decoration: none; " href="{{url('localeA/en')}}" class="text-white fs-6 px-1"> <img src="{{asset('project/frontend/default/flag_en.png')}}" class="img-fluid" alt="">  {{trans('default.english')}}</a>
            @endif
            @if (Auth::check() && !empty(Auth::user()))
                <a style="text-decoration: none; " href="{{url('/home')}}" class="text-white fs-6 px-1">{{ (!empty(Auth::user()->name)) ? Auth::user()->name : trans('project.dashboard') }}</a>
                <a class="text-white fs-6 px-1" href="{{ route('logout') }}" onclick="event.preventDefault(); this.closest('form').submit();" style="text-decoration: none;">
                    Logout
                    </a>
            @else
                <a href="{{url('/login')}}" class="text-white fs-6 px-3">{{trans('default.login')}}</a>
            @endif
        </form>
    </div>
        <button class="navbar-toggler text-black me-3" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"><p class="text-black fs-2"><i class="bi bi-list"></i></p></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <ul class="navbar-nav me-auto mb-2 mb-lg-0 px-5">
                <li class="nav-item">
                    <a class="nav-link active" aria-current="page" href="/">{{trans('default.home')}}</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link px-3" href="/#about">{{trans('default.about')}}</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link px-3" href="/#feature">{{trans('default.features')}}</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link px-3" href="/#download">{{trans('default.download')}}</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link px-3" href="/#contact">{{trans('default.contact')}}</a>
                </li>
            </ul>

        </div>

        <div class="div d-md-flex d-none">
            <form class="d-flex  justify-content-end forms" method="POST" action="{{ route('logout') }}">
                @csrf
               <!--        @if($locale == 'en')
         <a href="{{url('localeA/ar')}}" class="bar_link"> <img src="{{asset('project/frontend/default/flag_arabic.png')}}" class="img-fluid px-2" alt=""> {{trans('default.arabic')}}</a>
            @else
                <a style="text-decoration: none; " href="{{url('localeA/en')}}" class="bar_link"> <img src="{{asset('project/frontend/default/flag_en.png')}}" class="img-fluid px-2" alt="">  {{trans('default.english')}}</a>
            @endif -->
            @if (Auth::check() && !empty(Auth::user()))
                <a href="{{url('/home')}}" class="bar_link">{{ (!empty(Auth::user()->name)) ? Auth::user()->name : trans('project.dashboard') }}</a>

              <a class="bar_link" href="{{ route('logout') }}" onclick="event.preventDefault(); this.closest('form').submit();" style="text-decoration: none;">
                  Logout
                  </a>
            @else
                <a href="{{url('/login')}}" class="bar_link">{{trans('default.login')}}</a>
            @endif
          </form>
          </div>
    </div>
</nav>
@endif
<!-- end navbar -->
