<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<section class="footer_color" id="contact">
    <div class=" container-fluid">
        <div class="row flex-column-reverse flex-md-row">
            @if($settings['contact_form']['hide'])
            <div class="col-sm-6">
                <div class="container">
                    <p>{{trans('admin.form_text')}}</p>
                    <p class="font_cost h1">{{trans('default.form_heading')}}</p>
                    <br>
                    <form id="contact_save">
                        @csrf
                        <div class="mb-3">
                            <label for="name" class="form-label"></label>
                            <input type="text" class="form-control border_radi" id="name"  placeholder="{{trans('default.form_name')}}" name="name">
                            @error('name')
                                <script>
                                    swal("{{ $message }}",'error');
                                </script>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <label for="mobile" class="form-label"></label>
                            <input type="text" class="form-control border_radi" id="mobile"  placeholder="{{trans('default.mob_number')}}" name="mobile">
                        </div>
                        <div class="mb-3">
                            <label for="email" class="form-label"></label>
                            <input type="email" class="form-control border_radi" id="email"  placeholder="{{trans('default.form_email')}}" name="email">
                            @error('email')
                                <script>
                                    swal("{{ $message }}",'error');
                                </script>
                            @enderror
                        </div>
                        <div class="mb-3">
                            <label for="text" class="form-label"></label>
                            <textarea class="form-control border_radi" id="text" rows="3" placeholder="{{trans('default.form_message')}}" name="text"></textarea>
                            @error('text')
                                <script>
                                    swal("{{ $message }}",'error');
                                </script>
                            @enderror
                        </div>
                        <button type="submit" class="btn btn-primary px-5 border_radi">{{trans('default.form_button')}}</button>
                    </form>
                </div>
            </div>
            @endif
            @if($settings['footer']['hide'])
            <div class="col-sm-6 col-md-5 offset-md-1">
                <div class="container">
                    <p>{{trans('default.footer_sub_heading')}}</p>
                    <p class="font_cost h1">{{trans('default.footer_heading')}}</p>

                    <div class="my-5">
                        {!! $settings['footer']['description'][$locale] !!}


                        <ul class="list-inline my-4">
                            @foreach ($socials as $social)
                                <li class="list-inline-item">
                                    <a href="{{$social['link']}}" target="_blank" class="text-white">
                                        <b class="bi bi-{{$social['icon']}}"></b>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>

                </div>
            </div>
            @endif
        </div>
    </div>

</section>

@if($settings['footer_bar']['hide'])
<section class="footer_color_b">
  <div class="container">
    <div class="d-inline-flex col-6"><span>{{$settings['footer_bar']['copy_right']['name'][$locale]}}</span></div>
        <div class="float-end text-end col-6">
            <a class="text-decoration-none px-2 text-capitalize" href="/privacy">{{$settings['footer_bar']['privacy_policy']['name'][$locale]}}</a>
            <a class="text-decoration-none px-2 text-capitalize" href="/terms">{{$settings['footer_bar']['terms_and_condetion']['name'][$locale]}}</a>
        </div>
    </div>
</section>
@endif
<script src="{{asset('assets/theme/js/jquery.js')}}"></script>
<script src="{{asset('assets/frontend/slider/js/lightslider.js')}}"></script>
<script src="{{asset('assets/frontend/js/main.js')}}"></script>

<style>
    .nav-link, .bar_link{
        color: {{$settings['topbar']['colors']['text_color']}} !important;
    }
    .footer_color{
        color: {{$settings['footer']['colors']['text_color']}} !important;
        background-color: {{$settings['footer']['colors']['background_color']}} !important;
    }
    .footer_color  p.h1, .footer_color  h6{
        color: {{$settings['footer']['colors']['title_color']}} !important;
    }
    .footer_color_b, .footer_color_b a{
        background-color: {{$settings['footer_bar']['colors']['background_color']}};
        color:{{$settings['footer_bar']['colors']['text_color']}} !important;
    }

    .footer_color .form-control{
        background-color: {{$settings['contact_form']['colors']['inputs_background']}};
        color: {{$settings['contact_form']['colors']['inputs_foreground']}};
    }
    .footer_color .btn{
        border:none;
        color: {{$settings['contact_form']['colors']['button_foreground']}} !important;
        background-color: {{$settings['contact_form']['colors']['button_background']}} !important;

    }

</style>
<script>
    $('body').on('submit','#contact_save',function(e){
        e.preventDefault();
        var form_data = new FormData(this);
        $.ajax({
            url: '{{url("/contact_msg")}}',
            data: form_data,
            contentType: false,
            processData: false,
            cache: false,
            type:'POST',
            dataType: 'json',
        })
        .done(function (res) {
            swal('',res.text, res.cls);
        })
        .fail(function () {
        console.log("error");
        }).always(function(){
            console.log("stop");
        });
    });

    $(document).ready(function(){
        // menu
        $('.navbar-nav>li>a').on('click', function(){
            $('.navbar-collapse').collapse('hide');
        });

        // Slider
            var slider = $('#light-slider').lightSlider({
            slideEndAnimation: true,
                keyPress: true,
                item: 4,
                loop: true,
                auto: false,
                controls: false,
                pauseOnHover: true,
                adaptiveHeight: true,
                pager : false,
                rtl: {{$locale == 'ar' ? 'true' : 'false'}},
                responsive : [
                    {
                        breakpoint:900,
                        settings: {
                            item:5,
                            slideMove:1
                        }
                    },
                    {
                        breakpoint:800,
                        settings: {
                            item:3,
                            slideMove:1,
                            slideMargin:6,
                        }
                    },
                    {
                        breakpoint:480,
                        settings: {
                            item:2,
                            slideMove:1
                        }
                    }
                ]
        });
    });

    var btn = $('#button');

    $(window).scroll(function() {
        if ($(window).scrollTop() > 300) {
            btn.addClass('show');
        } else {
            btn.removeClass('show');
        }
    });

    btn.on('click', function(e) {
        e.preventDefault();
        $('html, body').animate({scrollTop:0}, '300');
    });



</script>

<script src="{{asset('assets/theme/js/bootstrap.min.js')}}"></script>

  </body>
</html>
