@extends('admin.layout.master')
@section('content')
<div class='container '>
    <div class='row'>
        <div class="col-sm-9  ">
            <table class='table'>
                <tr>
                    <td> <a class='p-2' href="{{('/home')}}">
                        <svg xmlns="http://www.w3.org/2000/svg" width="34" height="34" viewBox="0 0 34 34">
                        <g id="Group_2427" data-name="Group 2427" transform="translate(-220 -100)">
                        <circle id="Color" cx="17" cy="17" r="17" transform="translate(220 100)" fill="#969696" opacity="0.2"/>
                        <path id="Icon_ionic-ios-arrow-round-back" data-name="Icon ionic-ios-arrow-round-back" d="M13.973,11.466a.763.763,0,0,1,.006,1.075L10.434,16.1H23.943a.759.759,0,0,1,0,1.518H10.434l3.551,3.557a.769.769,0,0,1-.006,1.075.756.756,0,0,1-1.069-.006L8.1,17.394h0a.853.853,0,0,1-.158-.239.725.725,0,0,1-.058-.292.761.761,0,0,1,.216-.531l4.812-4.847A.744.744,0,0,1,13.973,11.466Z" transform="translate(221.711 100.142)"/>
                        </g>
                        </svg>
                        </a></td>
                    <td>
                        <div class="mb-3 ">
                        <label for="exampleFormControlInput1" class="form-label">FROM</label>
                        <input type="date" class="form-control from-date" value="{{$fromDate}}" id="exampleFormControlInput1" placeholder=" ">
                        </div>
                    </td>
                    <td>
                        <div class="mb-3">
                        <label for="exampleFormControlInput1" class="form-label">TO</label>
                        <input type="date" class="form-control to-date" value="{{$toDate}}" id="exampleFormControlInput1" placeholder=" ">
                        </div>
                    </td>
                    <td>
                        <div class="mt-3 pt-2 ">
                        <button class='btn btn-info btn_blue btn-search'> Show Logs <i class="bi bi-arrow-right px-2"></i>

                    </button>
                        </div>
                    </td>
                </tr>
            </table>
        </div>
        </div>
        <div class='bg-light p-3 rounded'>
                <!-- ===Header text only  -->
            <div class="row ">
            <div class="col-sm-3 col-4">
                <p class='colr_blue'>Time & date</p>
            </div>
            <div class="col-sm-9 col-4">
                <p class='colr_blue'>Log Detail</p>
            </div>
        </div>
            <!-- ===Header text only end  -->
            <!-- ===the first row static -->
            @foreach ($record as $row)
                @php
                $html = "";
                    if(count($row->properties) > 0):
                        // echo count($row->properties);
                        if (isset($row->properties['old']) and $row->properties['old']) :
                        $html .= "Labels : Old Data<br>";
                            foreach ($row->properties['old'] as $key => $value) {
                                if(!is_array($value)):
                                    $html .= $key . ' : <strong>' . $value . '</strong></br>';
                                endif;
                            }
                        endif;
                        if (isset($row->properties['modified']) and $row->properties['modified']) :
                        $html .= "Labels : Modified Data<br>";
                            foreach ($row->properties['modified'] as $key => $value) {
                                $html .= $key . ' : <strong>' . $value . '</strong></br>';
                            }
                        endif;
                    endif;
                @endphp
                <div class="row p-3  ">
                    <div class="col-sm-3 col-6 border-bottom-0">
                        <div class='d-flex'>
                        <p>
                        <svg  xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12">
                        <g id="Ellipse_508" data-name="Ellipse 508" fill="#fff" stroke="#1dbf74" stroke-width="2">
                            <circle cx="6" cy="6" r="6" stroke="none"/>
                            <circle cx="6" cy="6" r="5" fill="none"/>
                        </g>
                        </svg>
                        </p>
                        <p class='px-2'>{{date('H:i A',strtotime($row->created_at))}}  -  {{date('d-M-Y',strtotime($row->created_at))}}</p>
                        </div>
                    </div>
                    <div class="col-sm-8 col-12 border-bottom bg-white p-2">
                        <p class='fw-bold text-dark'>{{$row->log_name}}</p>
                        <p>{{$row->description}}  <br>Details:<br>{!!$html!!}</p>
                    </div>
                </div>
            @endforeach
        </div>
</div>
@endsection
@section('custom-js')
<script>
    $('body').on('click','.btn-search',function(){
        var fromDate = $('.from-date').val();
        var toDate = $('.to-date').val();
        if(fromDate == "" || toDate == "")
        {
            swal("{{trans('admin.Empty_fields_are_not_allowed')}}","warn");
            return
        }
        window.location.href="{{route('my-loges')}}/"+fromDate+"/"+toDate;
    });
</script>
@endsection
