@extends('layouts.app')

@section('content')
<section>
    <div class="container shadow">
        <div class="row">
            <div class="image-holder">
                <img src="{{ asset('assets/theme/img/logo-label.png') }}" alt="">
                <h1><b>Sharpvisions-Studypool</b></h1>
                <h5>We Offer Advanced Features which will take you to the Next Level</h5>
            </div>
            <div class="form-content" >
                <form method="POST" action="{{ route('password.email') }}">
                    @csrf
                    <div class="form-header"> <h3>{{ __('Reset Password') }}</h3> </div>
                    @if (session('status'))
                        <div class="alert alert-success text-center" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                    <p id="messages" class="error"></p>
                    <p class="font-weight-bold">Enter Your Email to Reset Password</p>
                    <div class="form-row">
                        <div class="form-holder w-100">
                            <!-- <label for="email" class="col-md-4 col-form-label text-md-right"></label> -->
                            <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" placeholder="{{ __('E-Mail Address') }}" autofocus>

                            @error('email')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                    </div>
                    <a href="{{ route('login') }}" class="btn">Back To Login</a>
                    <button class="btn login float-right" type="submit">Continue</button>
                </form>
            </div>
        </div>
    </div>
</section>

<!-- <div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Reset Password') }}</div>

                <div class="card-body">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif

                    <form method="POST" action="{{ route('password.email') }}">
                        @csrf

                        <div class="form-group row">
                            <label for="email" class="col-md-4 col-form-label text-md-right">{{ __('E-Mail Address') }}</label>

                            <div class="col-md-6">
                                <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>

                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row mb-0">
                            <div class="col-md-6 offset-md-4">
                                <button type="submit" class="btn btn-primary">
                                    {{ __('Send Password Reset Link') }}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div> -->
@endsection
