@extends('admin.layout.master')
@section('content')
@include('admin/users/user_js')
<div class="nav-scroller bg-light shado-sm mx-3 mt-2 border">
  <nav class="nav nav-underline align-items-center">
    <li class="nav-item">
      <a class='text-decoration-none fw-bold' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right"></span>
            <span class='text-decoration-none fw-bold '>{{trans('admin.manage_Users')}}  </span> 
    </li>
    <li class="nav-item ms-auto">
      <a class="nav-link" href="#" onclick="jQuery('.card-body').print()">
      <i class="bi-printer" style="font-size:16;line-height:0;"></i> {{trans('admin.print')}}
      </a>
    </li>

    <li class="nav-item">
      <a class="nav-link" data-toggle="dropdown" href="#">
        <i class="bi-box-arrow-up-right" style="font-size:16;line-height:0;"></i> {{trans('admin.export')}}
      </a>
      <ul class="dropdown-menu">
        <li>
            <a class="dropdown-item" href="#" onclick="exportTable('sort', 'pdf', '{{trans('admin.manage_Users')}} <?= date('Y-m-d h:i:s') ?>')"> {{trans('admin.PDF')}}</a>
            <a class="dropdown-item" href="#" onclick="exportTable('sort', 'csv', '{{trans('admin.manage_Users')}} <?= date('Y-m-d h:i:s') ?>')"> {{trans('admin.excel')}} </a>

        </li>
      </ul>
    </li>
  </nav>
</div>
<main class="container-fluid px-0 scroll-y">
    <!-- body content  -->
    <div class="card card-invoice rounded border-0">
      <div class="card-body pt-0">
        <div class="row p-0 g-2 align-items-end bg-light px-2 pb-2 border mt-1 mx-0 no-print" id="from_to_date_area">
          <div class="col-md-2 col-6 mt-1">
            <input type="text" class="filtertbl form-control form-control-sm" id="search_new" style="min-width:150px;" placeholder="{{trans('admin.search')}}">
          </div>
          @can('insert /'.Request::path())
            <div class="col-auto ms-md-auto">
                <button class="btn btn-success rounded-pill btn-sm px-3" onclick="add_user()">
                {{trans('admin.add_New')}}
                </button>
            </div>
          @endcan

      </div>

        <div class="row">
          <div class="col-lg-12">
            <div class="table-responsive">
              <table class="table table-sm w-100 table-hover mb-0 table-bordered data-table">
                <thead class="bg-light">
                    <tr>
                        <th>{{trans('admin.id')}}</th>
                        <th>{{trans('admin.name')}}</th>
                        <th>{{trans('admin.Email')}}</th>
                        <th>{{trans('admin.action')}}</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
        </div>
      </div>
    </div>
  </div>
</main>
<style>
	.dataTables_filter {
    display: none;
  }
</style>
<script type="text/javascript">
var table ="";
  $(function () {

     table = $('.data-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: "{{ route('users.index') }}",
        columns: [
            {data: 'id', name: 'id'},
            {data: 'name', name: 'name'},
            {data: 'email', name: 'email'},
            {data: 'action', name: 'action', orderable: false, searchable: false},
        ],
		"lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]]
    });

  });
  $("#search_new").on("keyup search input paste cut", function() {
   table.search(this.value).draw();
});
</script>

{!! modelBox("adduser", trans('admin.add'),"box","status_msg","save_user") !!}
{!! modelBox("edituser", trans('admin.edit'),"box_edit","status_update","update_user") !!}
@endsection
