@extends('admin.layout.master')
@section('content')
@include('admin/countries/country_js')
<div class="nav-scroller bg-light shado-sm mx-3 mt-2 border">
    {{-- <div class="row">
            <div class="col-sm-9  ">
                <table class='table'>
                    <form class="search-form" method="POST">
                        <tr>
                            <td> <a class='p-2' href="{{('/home')}}">
                                <svg xmlns="http://www.w3.org/2000/svg" width="34" height="34" viewBox="0 0 34 34">
                                <g id="Group_2427" data-name="Group 2427" transform="translate(-220 -100)">
                                <circle id="Color" cx="17" cy="17" r="17" transform="translate(220 100)" fill="#969696" opacity="0.2"/>
                                <path id="Icon_ionic-ios-arrow-round-back" data-name="Icon ionic-ios-arrow-round-back" d="M13.973,11.466a.763.763,0,0,1,.006,1.075L10.434,16.1H23.943a.759.759,0,0,1,0,1.518H10.434l3.551,3.557a.769.769,0,0,1-.006,1.075.756.756,0,0,1-1.069-.006L8.1,17.394h0a.853.853,0,0,1-.158-.239.725.725,0,0,1-.058-.292.761.761,0,0,1,.216-.531l4.812-4.847A.744.744,0,0,1,13.973,11.466Z" transform="translate(221.711 100.142)"/>
                                </g>
                                </svg>
                                </a></td>
                            <td>
                                <div class="mb-3 ">
                                <label for="exampleFormControlInput1" class="form-label">FROM</label>
                                <input type="date" class="form-control from-date"  name="fromDate" placeholder=" ">
                                </div>
                            </td>
                            <td>
                                <div class="mb-3">
                                <label for="exampleFormControlInput1" class="form-label">TO</label>
                                <input type="date" class="form-control to-date" name="toDate" placeholder=" ">
                                </div>
                            </td>
                            <td>
                                <div class="mt-3 pt-2 ">
                                <button type="submit" class='btn btn-info btn_blue btn-search'>{{trans('admin.Search')}}<i class="bi bi-arrow-right px-2"></i></button>
                                <button type="reset" class='btn btn-info btn_yellow btn-reset'> {{trans("admin.Reset")}} <i class="bi bi-arrow-repeat px-2 pr-1"></i>

                                </button>
                                </div>
                            </td>
                        </tr>
                    </form>
                </table>
            </div>
      </div> --}}
  <nav class="nav nav-underline align-items-center">
    <li class="nav-item">
      <a class="nav-link font-weight-bold font-large p-1 px-2" href="#">{{trans('admin.UserLoginLog')}}</a>
    </li>
    <li class="nav-item ms-auto">
      <a class="nav-link" href="#" onclick="jQuery('.card-body').print()">
      <i class="bi-printer" style="font-size:16;line-height:0;"></i> {{trans('admin.print')}}
      </a>
    </li>

    <li class="nav-item">
      <a class="nav-link" data-toggle="dropdown" href="#">
        <i class="bi-box-arrow-up-right" style="font-size:16;line-height:0;"></i> {{trans('admin.export')}}
      </a>
      <ul class="dropdown-menu">
        <li>
            <a class="dropdown-item" href="#" onclick="exportTable('sort', 'pdf', '{{trans('admin.countries')}} <?= date('Y-m-d h:i:s') ?>')"> {{trans('admin.PDF')}}</a>
            <a class="dropdown-item" href="#" onclick="exportTable('sort', 'csv', '{{trans('admin.countries')}} <?= date('Y-m-d h:i:s') ?>')"> {{trans('admin.excel')}} </a>

        </li>
      </ul>
    </li>
  </nav>
</div>
<main class="container-fluid px-0 scroll-y">
    <!-- body content  -->
    <div class="card card-invoice rounded border-0">
      <div class="card-body pt-0">

        <div class="row g-2 p-0 align-items-end bg-light px-2 pb-2 border mt-1 mx-0 no-print" id="from_to_date_area">
          <div class="col-md-2 col-6 mt-1">
            <input type="text" class="filtertbl form-control form-control-sm" id="search_new" style="min-width:150px;" placeholder="{{trans('admin.search')}}">

          </div>
          {{-- <div class="col-auto ms-md-auto">
            <button class="btn btn-success rounded-pill btn-sm px-3" onclick="add_category()">
              {{trans('admin.Add_New')}}
            </button>
          </div> --}}
          {{-- <div class="col-auto ms-md-auto">
                <div class="row">
                    <div class="col-sm-12">
                        <form class="form form-horizental">
                            <input type="date" class="form-control">
                        </form>
                    </div>
                </div>
          </div> --}}

      </div>

        <div class="row">
          <div class="col-lg-12">
            <div class="table-responsive">
              <table class="table table-sm table-hover mb-0 table-bordered data-table">
                <thead class="bg-light">
                    <tr>
                        <th>{{trans('admin.id')}}</th>
                        {{-- <th>{{trans('admin.Name')}}</th> --}}
                        <th>{{trans('admin.user')}}</th>
                        <th>{{trans('admin.Browser')}}</th>
                        <th>{{trans('admin.OperatingSystem')}}</th>
                        <th>{{trans('admin.device')}}</th>
                        <th>{{trans('admin.deviceModel')}}</th>
                        <th>{{trans('admin.ip')}}</th>
                        <th>{{trans('admin.Country')}}</th>
                        <th>{{trans('admin.city')}}</th>
                        <th>{{trans('admin.state')}}</th>
                        <th>{{trans('admin.postal_code')}}</th>
                        <th>{{trans('admin.continent')}}</th>
                        <th>{{trans('admin.iso_code')}}</th>
                        <th>{{trans('admin.Time')}}</th>

                        {{-- <th>{{trans('admin.Action')}}</th> --}}
                    </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
        </div>
      </div>
    </div>
  </div>
</main>
<style>
    .dataTables_filter {
    display: none;
  }
</style>

@endsection
@section('custom-js')
<script type="text/javascript">
  var table ="";
  $(function () {
    table = $('.data-table').DataTable({
      processing: true,
      serverSide: true,
        ajax: {
            url: "{{ route('user-login-log') }}",
            data: function (d) {
                d.fromDate = $('input[name=fromDate]').val();
                d.toDate = $('input[name=toDate]').val();
            }
        },
      columns: [
          {data: 'id', name: 'id'},
          {data: 'user', name: 'user'},

          {data: 'browser', name: 'browser'},
          {data: 'operating_system', name: 'operating_system'},
          {data: 'device_family', name: 'device_family'},
          {data: 'device_model', name: 'device_model'},
          {data: 'user_ip', name: 'user_ip'},

          {data:'country',name:'country'},
          {data: 'city', name: 'city'},
          {data: 'state', name: 'state'},
          {data: 'postal_code', name: 'postal_code'},
          {data: 'continent', name: 'continent'},
          {data: 'iso_code', name: 'iso_code'},
          {data: 'created_at', name: 'created_at'},

        //   {data: 'action', name: 'action',
        //    orderable: false, searchable: false},
      ],
      "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]]
    });
  });
  $("body").on('reset','.search-form',function(e){
      $(this)[0].reset();
      table.draw();
  });
  $("#search_new").on("keyup search input paste cut", function() {
     table.search(this.value).draw();
  });
  $('body').on('submit','.search-form',function (e) {
    e.preventDefault();
    if($('input[name=fromDate]').val() == "" && $('input[name=toDate]').val() =="")
    {
        swal("{{trans('admin.empty_fields_are_not_allowed')}}","warn");
        return
    }
    table.draw();
  });

</script>

@endsection
