@extends('admin.layout.master')
@section('content')
<!-- THE ROW END HERE -->
<div class='bg-white p-2 rounded m-2'>
    <div class="row justify-content-between p-2 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center p-2">
            <a class='text-decoration-none fw-bold theme_link_color' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill theme_text_color"></span>
            <span class='text-decoration-none fw-bold theme_text_color' >{{trans('admin.activate_theme')}}</span>
        </div>
    </div>
    <div class='p-3'>
        <div class="container">
            <div class="row">
                <div class="col-12">
                    @if (session()->has('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                        {{ session()->get('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @elseif(session()->has('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session()->get('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif
                </div>

                    <div class="col-sm-4">
                        <form action="{{route('activate')}}" method="post" enctype="multipart/form-data">
                            <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                            <div class="card border-0 bg-light rounded">

                                <img src="{{asset('admin/theme-preview/select-theme3.png')}}" class='w-100 img-fluid' alt="">

                                <div class="themes_btn align-middle">
                                    <div style="display: flex; justify-content: space-between;padding:10px; ">
                                        <div  class="fw-bold">
                                            <label for="">{{trans('admin.version_no')}}</label><br>
                                            @if ($post->slug == 'default')
                                                <span type="button" class='btn btn-success btn-xs rounded-pill'>{{ trans('admin.active') }}</span>
                                            @else
                                                <button type='sumbit' class='btn btn-color btn-xs rounded-pill'>{{ trans('admin.activate') }}</button>
                                            @endif
                                        </div>
                                        <div class="text-center">
                                            <input type="hidden" class="" name="slug" id="slug" value="default">
                                        </div>
                                        <p class="mt-2">
                                            <span class="px-2">
                                                <a class="text-decoration-none px-1" href="{{url('/frontend')}}">
                                                    <span class="edit_icon">
                                                        <i class="bi bi-pen"></i>
                                                    </span>
                                                    <span class="px-1 e-text">{{ trans('admin.setting') }}</span>
                                                </a>
                                            </span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="col-sm-4">
                        <form action="{{route('activate')}}" method="post" enctype="multipart/form-data">
                            <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                            <div class="card border-0 bg-light rounded">

                                <img src="{{asset('admin/theme-preview/select-theme2.png')}}" class='w-100 img-fluid' alt="">

                                <div class="themes_btn align-middle">
                                    <div style="display: flex; justify-content: space-between;padding:10px; ">
                                        <div  class="fw-bold">
                                            <label for="">Vision21.02 - {{trans('admin.comming_soon')}}</label><br>
                                            {{-- @if ($post->slug == 'theme_1')
                                                <span type="button" class='btn btn-success btn-xs rounded-pill'>{{ trans('admin.active') }}</span>
                                            @else
                                                <button type='sumbit' class='btn btn-color btn-xs rounded-pill'>{{ trans('admin.activate') }}</button>
                                            @endif --}}
                                        </div>
                                        <div class="text-center">
                                            <input type="hidden" class="" name="slug" id="slug" value="theme_1">
                                        </div>
                                        <p class="mt-2">
                                            <span class="px-2">
                                                {{-- <a class="text-decoration-none px-1" href="{{url('/frontend')}}">
                                                    <span class="edit_icon">
                                                        <i class="bi bi-pen"></i>
                                                    </span>
                                                    <span class="px-1 e-text">Setting</span>
                                                </a> --}}
                                            </span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="col-sm-4">
                        <form action="{{route('activate')}}" method="post" enctype="multipart/form-data">
                            <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                            <div class="card border-0 bg-light rounded">

                                <img src="{{asset('admin/theme-preview/select-theme3.png')}}" class='w-100 img-fluid' alt="">

                                <div class="themes_btn align-middle">
                                    <div style="display: flex; justify-content: space-between;padding:10px; ">
                                        <div  class="fw-bold">
                                            <label for="">Vision21.03 - {{trans('admin.comming_soon')}}</label><br>
                                            {{-- @if ($post->slug == 'theme_1')
                                                <span type="button" class='btn btn-success btn-xs rounded-pill'>{{ trans('admin.active') }}</span>
                                            @else
                                                <button type='sumbit' class='btn btn-color btn-xs rounded-pill'>{{ trans('admin.activate') }}</button>
                                            @endif --}}
                                        </div>
                                        <div class="text-center">
                                            <input type="hidden" class="" name="slug" id="slug" value="theme_1">
                                        </div>
                                        <p class="mt-2">
                                            <span class="px-2">
                                                {{-- <a class="text-decoration-none px-1" href="{{url('/frontend')}}">
                                                    <span class="edit_icon">
                                                        <i class="bi bi-pen"></i>
                                                    </span>
                                                    <span class="px-1 e-text">Setting</span>
                                                </a> --}}
                                            </span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

            </div>
            <!--the row ended here-->
        </div>
    </div>
</div>
</div>
<style>
    .themes_btn:hover{
        display: block !important;
    }
</style>
@endsection
