@extends('admin.layout.master')
@section('content')
@include('admin/templates/script_js')
<div class='bg-white p-2 rounded m-2'>
    <div class="row justify-content-between p-lg-3 rounded m-2  bg-light">
        <div class="col-md-6 col-12  align-self-center">
            <a class='text-decoration-none fw-bold  theme_link_color' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right theme_text_color"></span>
             <span class='text-decoration-none fw-bold theme_text_color' >{{trans('admin.Email_templates')}}</span>
        </div>
        <div class="col-md-6 col-12  align-self-center float-end ">
            <div class='align-self-center  text-md-center justify-content-center'>
                <div class="row">
                    <div class="col-md-5 mt-md-0 mt-1">
                        <div>
                            <input type="text" class="form-control rounded-pill bg-light" id="search_new" placeholder="{{trans('admin.search')}}">
                        </div>
                    </div>
                    <div class="col-md-3 mt-md-0 mt-1">
                      <select id="status_filter" class="form-select rounded-pill">
                          <option value="" selected> {{ trans('admin.status') }}</option>
                          <option value="1"> {{ trans('admin.active') }}</option>
                          <option value="0"> {{ trans('admin.inactive') }} </option>
                      </select>
                    </div>
                    <div class="col-md-2 col-3 my-md-0 my-1">
                        <a class='text-decoration-none ' href="{{url('/email_templates/add')}}">
                            <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 55 55">
                                <g id="Group_12506" data-name="Group 12506" transform="translate(-1134.648 -427.545)">
                                    <ellipse id="Ellipse_593" data-name="Ellipse 593" cx="27.5" cy="27.5" rx="27.5" ry="27.5" transform="translate(1134.648 427.545)" fill="#f56a20" />
                                    <path id="Path_15415" data-name="Path 15415" d="M1.438-6.844V-9.469H8.25v-6.859h2.672v6.859h6.813v2.625H10.922V0H8.25V-6.844Z" transform="translate(1153.017 463.249)" fill="#fff" />
                                </g>
                            </svg>
                        </a>
                    </div>
                    <div class="col-md-2 col-3 my-md-0 my-1">
                        {{-- <div class="dropdown p-0">
                            <a class=" bi bi-three-dots-vertical fs-3 text-white bg-warning admin_css_dot d-flex justify-content-center align-items-center" href="#" id="dropdownMenuLink" data-bs-toggle="dropdown" aria-expanded="false">
                            </a>
                            <ul class=" dropdown-menu" aria-labelledby="dropdownMenuLink">
                            <li><a href="#" class="dropdown-item" onclick="jQuery('.data-table').print()"><i class="bi-printer mx-2"></i>
                                {{__('admin.print')}}</a>
                                </li>
                            <li>
                                <a class="dropdown-item" href="#" onclick="exportTable('data-table', 'pdf', '{{trans('email templates')}} <?= date('Y-m-d h:i:s') ?>')">  <i class="bi bi-file-earmark-pdf  mx-2"></i>
                                {{__('admin.PDF')}}
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="#" onclick="exportTable('data-table', 'csv', '{{trans('email templates')}} <?= date('Y-m-d h:i:s') ?>')"><i class="bi bi-file-spreadsheet  mx-2"></i>
                                {{__('admin.excel_csv')}}
                                </a>
                            </li>
                            </ul>
                        </div> --}}
                    </div>

                </div>
            </div>
        </div>
    </div>
    <div class='table-responsive p-3'>
        <table class='table w-100 table-border data-table'>
            <thead>
                <tr class='tex-g'>
                    <th>{{trans('admin.name')}}</th>
                    <th class='text-end  pe-4'>{{trans('admin.status')}}</th>
                    <th class='text-end'>{{trans('admin.action')}}</th>
                </tr>
            </thead>
            <tbody>
            </tbody>
        </table>
    </div>
</div>
<style>
  .dataTables_filter {
    display: none;
  }
</style>
<script type="text/javascript">
var table ="";
$(function () {
   table = $('.data-table').DataTable({
      //processing: true,
      //serverSide: true,
      //ajax: "{{ route('email_templates') }}",
      processing: true,
      serverSide: true,
      "searching": false,
      ajax: {
          url: "{{ route('email_templates') }}",
          type: 'GET',
          data: function(d) {
              d.search_new = $('#search_new').val();
              d.status_filter = $('#status_filter').val();
              // console.log(d);
          }
      },
      columns: [
          {data: 'name', name: 'name'},
          {data: 'status', name: 'status', orderable: false, searchable: false},
          {data: 'action', name: 'action', class:'no-print', orderable: false, searchable: false},
      ],
  	"lengthMenu": [[10, 25, 50, 100, -1], [100, 200, 500, 700, "All"]]
  });
});
$('body').on('change', '#status_filter', function(e) {
  table.draw(true);
});
$('body').on('keyup', '#search_new', function(e) {
  table.draw(true);
});
$('body').on('click', '.clear', function(e) {
    $('#search_new').val("");
    $('#status_filter').val("");
    table.draw(true);
});
/*$("#search_new").on("keyup", function() {
    table.draw();
 });*/
</script>
@endsection
