@extends('admin.layout.master')
@section('content')
@include('admin/send_mail/script_js')
<style>
    option {
        font-size: 12px !important;
    }
</style>
	<div class="container-fluid">
		<div class="row justify-content-between p-3 rounded m-2  bg-light">
			<div class="col-12 col-md-6 align-self-center">
				<a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill"></span>
				<a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.support')}}  </a> <span class="bi bi-caret-right"></span>
				<span class='text-decoration-none fw-bold' >{{trans('admin.support_reply')}}</span> 
			</div>
		</div>
	</div>

    <div class="container-fluid">
        <div class="row m-2">
        	<div class="col-12">
	            @if(session()->has('success'))
	                <div class="bg-success p-2 mt-4 rounded text-white">
	                    <span class="input-error">{{ session()->get('success') }}</span>
	                </div>
	            @elseif(session()->has('error'))
	                <div class="bg-danger p-2 mt-4 rounded text-white">
	                    <span class="input-error">{{ session()->get('error') }}</span>
	                </div>
	            @endif
	        </div>

            <div class="col-md-7 bg-light_c p-3 rounded g-2">
	        	<label class="label label" for="text">Support Message</label>
	            <div class="container">
	                <p class='fw-bold text-dark mt-2'>
	                	{{$post->message}} <small></small>
	                </p>
	                @foreach($postMsg as $row)
	                <p class='fw-bold text-end text-dark mt-2'>
	                	{{$row->message}} <small></small>
	                </p>
	                @endforeach
	            </div>
	        </div>
            <!-- END 7 COL  -->
	        <div class="col-md-5">
	        	<div class="container">
	                <form action="{{route('support_reply')}}" method="post">
		            	<input type="hidden" name="_token" value="{{ csrf_token() }}" />
		                <input type="hidden" name="id" id="id" value="{{$post->id}}">
		                <input type="hidden" name="type" id="type" value="{{$post->type}}">
		                <label class="label" for="text">Support Reply</label>
		                <div class="mb-3 position-relative">
		                    <textarea id="text" name="text" class="form-control bg-light_c border-0 rounded cat @error('text') is-invalid @enderror" data-emojiable="true" data-emoji-input="unicode" rows="15" placeholder="Type here">{{$post->text}}</textarea>
		                    <div class="btn-group position-absolute bottom-0 p-2" role="group" aria-label="Basic example">
		                        <button type="button" class="btn btn-info col-upload border-0 epicker" data-type='picker' style=' background-color: transparent;'>
		                            <i class="bi bi-emoji-smile-fill"></i> Emoji
		                        </button>
		                    </div>
		                    @error('text') 
		                        <span class="text-danger">{{ $message }}</span> 
		                    @enderror

		                </div>
		                <div class='d-flixs'>
		                    <button type="submit" class="btn btn-warning col-bt rounded-pill mb-4 mt-2 text-white">Reply</button>
		                </div>
		            </form>
	            </div>
	        </div>
            <!-- END 12 COL  -->            
        </div>
    </div>


<link href="{{ asset('assets/plugins/emoji-picker/lib/css/emoji.css') }}" rel="stylesheet">
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/config.js') }}"></script>
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/util.js') }}"></script>
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/jquery.emojiarea.js') }}"></script>
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/emoji-picker.js') }}"></script>

<script>
	// click indirectly on default emoji picker
    $(".epicker").click(function(){
        $('.emoji-picker').click();
    });

	$(function () {
	    // Initializes and creates emoji set from sprite sheet
	    window.emojiPicker = new EmojiPicker({
	        emojiable_selector: '[data-emojiable=true]',
	        assetsPath: '{{ asset("assets/plugins/emoji-picker/lib/img/") }}',
	        popupButtonClasses: ''
	    });
	    window.emojiPicker.discover();
	});
</script>
@endsection