@extends('admin.layout.master')
@section('content')
<div class="container-fluid">
    <div class="row justify-content-between p-1 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right"></span>
            <span class='text-decoration-none fw-bold' >{{trans('admin.support')}}</span>  
        </div>
        <div class="col-12 col-md-6 align-self-center float-end ">
            <div class='align-self-center  text-center justify-content-center mt-2'>
                <div class="row ">
                    <div class="col-md-6">
                        <div>
                            <input type="text" class="form-control rounded-pill bg-light" id="search_new" placeholder="{{trans('admin.search')}}">
                        </div>
                    </div>
                    <div class="col-md-6">
                      <select id="status_filter" class="form-select rounded-pill">
                          <option value="" selected>All Status</option>
                          <option value="0"> Pending </option>
                          <option value="1"> Active </option>
                          <option value="2"> Completed </option>
                          <option value="3"> Cancelled </option>
                      </select>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
</div>
<div class="container-fluid">
    <div class='p-2'>
        <table class='table w-100 border-top data-table'>
        	<thead>
                <tr class='tex-g'>
                    <th>Business Name</th>
                    <th>Ticket ID</th>
                    <th>Type</th>
                    <th>Date</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>              
            </tbody>
        </table>
    </div>
</div>
<style>
  .dataTables_filter {
    display: none;
  }
</style>
<script type="text/javascript">
var table ="";
$(function () {
   table = $('.data-table').DataTable({
      processing: true,
      serverSide: true,
      "searching": false,
      ajax: {
          url: "{{ route('support') }}",
          type: 'GET',
          data: function(d) {
            d.search_new = $('#search_new').val();
            d.status_filter = $('#status_filter').val();
            // console.log(d);
          }
      },
      columns: [
          {data: 'user_id', name: 'user_id'},
          {data: 'id', name: 'id'},
          {data: 'type', name: 'type'},
          {data: 'created_at', name: 'created_at'},
          {data: 'status', name: 'status', orderable: false, searchable: false},
          {data: 'action', name: 'action', orderable: false, searchable: false},
      ],
  	"lengthMenu": [[10, 25, 50, 100, -1], [100, 200, 500, 700, "All"]]
  });
});
$('body').on('change', '#status_filter', function(e) {
  table.draw(true);
});
$('body').on('keyup', '#search_new', function(e) {
  table.draw(true);
});
$('body').on('click', '.clear', function(e) {
    $('#search_new').val("");
    $('#status_filter').val("");
    table.draw(true);
});
/*$("#search_new").on("keyup", function() {
    table.draw();
 });*/

 $('body').on('change', '#active_status', function(e) {
        var id = $(this).data('id');
        var status = $(this).val();
        try {
            $.ajax({
                type : 'GET',
                url : '{{url("support/status_change")}}/'+id+'/'+status,
                success : function (res) {
                    swal(res.message,res.status);
                }
            });
        } catch (error) {
            console.log(error);
        }
    });
</script>
@endsection