@extends('admin.layout.master')
@section('content')
<div class='bg-white p-2 rounded '>
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill"></span>
            <a class='text-decoration-none fw-bold' href="{{url('/sms_template')}}" >{{trans('admin.sms_templates')}}</a><span class="bi bi-caret-right"></span>
            <span>{{ trans('admin.add_sms_templates') }} </span>
        </div>
    </div>
</div>
<div class="container rounded border">
    <div class="row p-3 ">
    	<div class="col-12">
            @if(session()->has('success'))
                <div class="bg-success p-2 mt-4 rounded text-white">
                    <span class="input-error">{{ session()->get('success') }}</span>
                </div>
            @elseif(session()->has('error'))
                <div class="bg-danger p-2 mt-4 rounded text-white">
                    <span class="input-error">{{ session()->get('error') }}</span>
                </div>
            @endif
            <!-- @if ($errors->any())
                <div class="bg-danger p-2 mt-4 rounded text-white">
                    @foreach ($errors->all() as $message)
                        <span class="input-error">{{ $message }}</span><br>
                    @endforeach
                </div>
            @endif -->
        </div>
        <div class="col-md-9 pe-lg-5">
            <form action="{{route('update_temp')}}" method="post">
            	<input type="hidden" name="_token" value="{{ csrf_token() }}" />
                <input type="hidden" name="id" id="id" value="{{$post->id}}">
            	<div class="mb-3">
                    <label for="name" class="form-label">Name</label>
                    <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('name') is-invalid @enderror" id="name" name="name" placeholder="Name" aria-describedby="emailHelp">
                    @error('name') 
                        <span class="text-danger">{{ $message }}</span> 
                    @enderror
                </div>
                <div class="mb-3">
                    <label for="subject" class="form-label">Parameters</label>
                    <input type="text" class="form-control  rounded-pill bg-light_c border-0 @error('params') is-invalid @enderror" id="params" name="params" aria-describedby="emailHelp" placeholder="Parameters" value="">
                    @error('params') 
                        <span class="text-danger">{{ $message }}</span> 
                    @enderror
                </div>
                <div class="mb-3 position-relative">
                    <label class="label label" for="text">Description</label>
                    <textarea id="text" name="text" class="form-control bg-light_c border-0 rounded cat @error('text') is-invalid @enderror" rows="12" placeholder="Type here"></textarea>
                    @error('text') 
                        <span class="text-danger">{{ $message }}</span> 
                    @enderror
                    @error('text') 
                        <span class="text-danger">{{ $message }}</span> 
                    @enderror
                    <!-- <div class="position-absolute bottom-0 p-3">
                        <button class="btn btn-info rounded-pill col-upload border-0" style=' background-color: transparent;'>
                            <i class="bi bi-emoji-smile-fill"></i>
                            Emoji
                        </button>
                    </div> -->
                </div>
                <div class='d-flixs'>
                    <button type="submit" class="btn btn-warning col-bt rounded-pill mb-4 mt-2 text-white">Update</button>
                </div>
            </form>
        </div>
        <div class="col-md-3 bg-light_c p-3 rounded g-2">
            <div class="container ">
                <i class="bi bi-question-circle-fill" style="font-size: 20px; padding-top:10px;"></i>
                <p class='fw-bold text-dark mt-2'>Parameters</p>
                <p class='font_side'>Add parameters like this.</p>
                <p><?php echo "{{username}},{{message}}" ?></p>
            </div>
        </div>
    </div>
</div>
@endsection