@extends('admin.layout.master')
@section('content')
@include('admin/sms/script_js')
<div class='bg-white p-2 rounded m-2'>
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right fw-bold">{{ trans('admin.sms_api') }}</span>
        </div>
        <div class="col-12 col-md-6 align-self-center float-end ">
            <div class='align-self-center  text-center justify-content-center'>
                <div class="row">
                    <div class="col-7">
                        <div>
                            <input type="text" class="form-control rounded-pill bg-light" id="search_new" placeholder="{{trans('admin.search')}}">
                        </div>
                    </div>
                    <div class="col-5">
                        <select id="status_filter" class="form-select rounded-pill">
                          <option value="" selected> {{ trans('admin.status') }}</option>
                          <option value="1"> {{ trans('admin.active') }} </option>
                          <option value="0"> {{ trans('admin.inactive') }} </option>
                        </select>
                    </div>
                    <!-- <div>
                        <a class='text-decoration-none' href="{{url('/sms_hosts/add')}}">
                        <svg xmlns=" http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 55 55">
                            <g id="Group_12506" data-name="Group 12506" transform="translate(-1134.648 -427.545)">
                                <ellipse id="Ellipse_593" data-name="Ellipse 593" cx="27.5" cy="27.5" rx="27.5" ry="27.5" transform="translate(1134.648 427.545)" fill="#f56a20" />
                                <path id="Path_15415" data-name="Path 15415" d="M1.438-6.844V-9.469H8.25v-6.859h2.672v6.859h6.813v2.625H10.922V0H8.25V-6.844Z" transform="translate(1153.017 463.249)" fill="#fff" />
                            </g>
                        </svg>
                    </a>
                    </div> -->
                </div>
            </div>
        </div>
    </div>
    <div class='table-responsive p-3'>
        <table class='table w-100 table-border data-table'>
            <thead>
                <tr class='tex-g'>
                    <th>#</th>
                    <th>{{ trans('admin.name') }}</th>
                    <th>{{ trans('admin.masks') }}</th>
                    <th class='text-center pe-4'>{{ trans('admin.default') }}</th>
                    <th class='text-center pe-4'>{{ trans('admin.status') }}</th>
                    <th class='text-center'>{{ trans('admin.actions') }}</th>
                </tr>
            </thead>
            <tbody>
                 
            </tbody>
        </table>
    </div>
</div>
<script type="text/javascript">
    var table = "";
    $(function() {
        table = $('.data-table').DataTable({
            processing: true,
            serverSide: true,
            "searching": false,
            ajax: {
                url: "{{ url('sms_hosts/host_list') }}",
                type: 'GET',
                data: function(d) {
                  d.search_new = $('#search_new').val();
                  d.status_filter = $('#status_filter').val();
                  // console.log(d);
                }
            },
            columns: [
                {data: 'id', name: 'id'},
                {data: 'name', name: 'name'},
                {data: 'mask', name: 'mask'},
                {data: 'is_default', name: 'is_default'},
                {data: 'status', name: 'status'},
                {data: 'actions', name: 'actions', orderable: false, searchable: false},
            ],
            "lengthMenu": [[10, 25, 50, 100, -1], [100, 200, 500, 700, "All"]]
        });
    });
    $('body').on('change', '#status_filter', function(e) {
      table.draw(true);
    });
    $('body').on('keyup', '#search_new', function(e) {
      table.draw(true);
    });
    $('body').on('click', '.clear', function(e) {
        $('#search_new').val("");
        $('#status_filter').val("");
        table.draw(true);
    });
</script>
@endsection