@extends('admin.layout.master')
@section('content')
<div class='bg-white p-2 rounded m-2'>
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right-fill fw-bold">{{ trans('admin.sms_api') }}</span>
            <span class="bi bi-caret-right fw-bold">{{$post->name}}</span>
        </div>
    </div>
</div>
<div class="container-fluid">
    <div class="row rounded border m-2 p-2">
        <div class="col-12">
            @if(session()->has('success'))
                <div class="bg-success p-2 mt-4 rounded text-white">
                    <span class="input-error">{{ session()->get('success') }}</span>
                </div>
            @elseif(session()->has('error'))
                <div class="bg-danger p-2 mt-4 rounded text-white">
                    <span class="input-error">{{ session()->get('error') }}</span>
                </div>
            @endif
            <!-- @if ($errors->any())
                <div class="bg-danger p-2 mt-4 rounded text-white">
                    @foreach ($errors->all() as $message)
                        <span class="input-error">{{ $message }}</span><br>
                    @endforeach
                </div>
            @endif -->
        </div>
        <div class="col-md-5">
            <div>
                <form action="{{route('update_sms_hosts')}}" method="post">
                    <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                    <input type="hidden" name="id" id="id" value="{{$post->id}}">
                    <div class="mb-3">
                        <label for="name" class="form-label">Heading</label>
                        <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('name') is-invalid @enderror" id="name" name="name" placeholder="Name" aria-describedby="emailHelp" value="{{$post->name}}" readonly>
                        @error('name') 
                            <span class="text-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="username" class="form-label">Username (Account ID)</label>
                        <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('username') is-invalid @enderror" id="username" name="username" placeholder="Username" aria-describedby="emailHelp" value="{{$post->username}}">
                        @error('username') 
                            <span class="text-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="mask" class="form-label">Masks</label>
                        <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('mask') is-invalid @enderror" id="mask" name="mask" placeholder="Type here" aria-describedby="emailHelp" value="{{$post->mask}}">
                        @error('mask') 
                            <span class="text-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label for="secret" class="form-label">Secret (Auth Token)</label>
                        <input type="text" class="form-control rounded-pill bg-light_c border-0 @error('secret') is-invalid @enderror" id="secret" name="secret" placeholder="Type here" aria-describedby="emailHelp" value="{{$post->secret}}">
                        @error('secret') 
                            <span class="text-danger">{{ $message }}</span> 
                        @enderror
                    </div>
                    <!-- switch start  -->
                    <div class="d-flex  mob_just pt-2 my-3">
                        <label for="status" class="ms-2 mb-1">Status</label>
                        <label class="switch ms-5">
                            <input type="checkbox" name="status" id="status" value="1" @if($post->status == 1) checked @endif>
                            <div class="slider round">
                                <!--ADDED HTML -->
                                <span class="on">on</span>
                                <span class="off">off</span>
                            </div>
                        </label>
                    </div>
                    <!-- switch end  -->

                    <!-- switch start  -->
                    <div class="d-flex  mob_just pt-2 my-3">
                        <label for="default" class="ms-2 mb-1">Default</label>
                        <label class="switch ms-5">
                            <input type="checkbox" name="default" id="default" value="1" @if($post->is_default == 1) checked @endif>
                            <div class="slider round">
                                <!--ADDED HTML -->
                                <span class="on">on</span>
                                <span class="off">off</span>
                            </div>
                        </label>
                    </div>
                    <!-- switch end  -->
                    <button type='sumbit' class='btn btn-success btn-color rounded-pill text-light px-5 mt-lg-3 my-2'>Update</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
