@extends('admin.layout.master')
@section('content')
@include('admin/sms/script_js')
<style>
    option {
        font-size: 12px !important;
    }
</style>
<div class="container-fluid">
    <div class="row justify-content-between p-3 rounded m-2  bg-light">
        <div class="col-12 col-md-6 align-self-center">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right"></span>
            <span class='text-decoration-none fw-bold' >{{trans('admin.send_multi_sms')}}</span>  
            <div class='  fs-5 float-end'>
                <a href=""><i class="fa fa-history text-dark" aria-hidden="true"></i></a>
            </div>
        </div>
        <div class="col-12 col-md-6 align-self-center float-end ">
            <div class='align-self-center  text-center justify-content-center'>
                <div class="row">
                    <div class="col-4">
                        <div>
                            <select id="users" class="form-select rounded-pill">
                                <option value="" selected> {{ trans('admin.all_users') }}</option>
                                {!! getUserTypeList() !!}
                            </select>
                        </div>
                    </div>
                    <div class="col-4">
                        <div>
                            <select id="languages" class="form-select rounded-pill">
                                <option value="" selected> {{ trans('admin.all_languages') }} </option>
                                <option value="en"> {{ trans('admin.english') }} </option>
                                <option value="ar"> {{ trans('admin.arabic') }} </option>
                            </select>
                        </div>
                    </div>
                    <div class="col-4">
                        <div>
                            <button type="button" class="btn btn-secondary rounded-pill clear">{{ trans('admin.clear') }}</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<section>
    <div class="container-fluid">
        <div class="row p-2">
            <div class="col-md-7 ">
                <table class="table w-100 table-striped|sm|bordered|inverse table-responsive data-table">
                    <thead>
                        <tr>
                            <th class='text-start text-secondary' width="70px">
                                <div class="form-check ms-2">
                                    <input type="checkbox" id="allchk" class="allchk check-all" label="check all"/>
                                    <label class="form-check-label" for="flexCheckDefault">
                                        {{ trans('admin.receiver') }}
                                    </label>
                                </div>
                            </th>
                            <th>{{ trans('admin.name') }}</th>
                            <th class='text-secondary'>{{ trans('admin.mob_no') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        
                    </tbody>
                </table>
            </div>
            <!-- END 7 COL  -->
            <div class="col-md-5">
                <form id="send" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                    <div class="mb-3">
                        <label for="title" class="form-label">{{ trans('admin.title') }}</label>
                        <input type="text" class="form-control  rounded-pill bg-light_c" id="title" name="title" aria-describedby="emailHelp" placeholder='Title'>
                    </div>
                    <div class="mb-3">
                        <label for="hosts" class="form-label label">{{ trans('admin.hosts') }}</label>
                        <select  id="hosts" class="form-select rounded-pill bg-light cat" name="hosts">
                            <option value="">{{ trans('admin.select') }}</option>
                            @foreach(sms_host_list() as $host)
                                <option value="{{$host->id}}" @if($host->is_default == 1) selected @endif>{{$host->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="template" class="form-label label">{{ trans('admin.templates') }}</label>
                        <select  id="template" class="form-select rounded-pill bg-light cat" name="template">
                            <option value="">{{ trans('admin.select') }}</option>
                            @foreach(sms_templates_list() as $temp)
                                <option value="{{$temp->id}}">{{$temp->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <div class="container bg-light p-2">
                            <i class="bi bi-question-circle-fill" style="font-size: 20px; padding-top:10px;"></i> <span class='fw-bold text-dark mt-2'>{{ trans('admin.parameters') }}</span>
                            <p id="params"></p>
                        </div>
                    </div>
                    <div class="mb-3 position-relative">
                        <label for="text" class="form-label">{{ trans('admin.description') }}</label>
                        <textarea class="form-control bg-light_c rounded cat" id="text" name="text" rows="6"></textarea>
                        <!-- <div class="position-absolute bottom-0 p-2">
                            <button type="button" class="btn btn-info rounded-pill col-upload border-0 epicker" data-type='picker' style=' background-color: transparent;'>
                            <i class="bi bi-emoji-smile-fill"></i>
                            Emoji
                        </button>
                        </div> -->
                    </div>
                    <div class="container text-center">

                        <p class='fs-6 mt-2 fw-bold'>{{ trans('admin.total_receiver') }} : <span id="counter"></span></p>
                        <div class='d-grid'>
                            <button class="btn btn-primary col-bt rounded-pill my-4" type="submit">{{ trans('admin.send') }}</button>
                        </div>
                    </div>
                </form>
            </div>
            <!-- END 5 COL  -->
        </div>
    </div>
</section>
<script>
    var table ="";
    $(function () {
           table = $('.data-table').DataTable({
              processing: true,
              serverSide: true,
              //ajax: "{{ route('send_email') }}",
              ajax: {
                url: "{{ route('sms') }}",
                data: function(d) {
                    d.user_filter = $('#users').val();
                    d.locale_filter = $('#languages').val();
                    // console.log(d);
                }
              },
              columns: [
                {data: 'id', name: 'id', orderable: false},
                {data: 'name', name: 'name'},
                {data: 'mobile', name: 'mobile'},
            ],
        "lengthMenu": [[10, 25, 50, 100, -1], [100, 200, 500, 700, "All"]]
      });
    });

    /*$("#search_new").on("keyup search input paste cut", function() {
        table.search(this.value).draw();
    });*/
    $('body').on('change', '#users, #languages', function(e) {
        table.draw(true);
    });
    $('body').on('click', '.clear', function(e) {
        $('#users').val("");
        $('#languages').val("");
        table.draw(true);
    });

    // click indirectly on default emoji picker
    $(".epicker").click(function(){
        $('.emoji-picker').click();
    });
</script>
<link href="{{ asset('assets/plugins/emoji-picker/lib/css/emoji.css') }}" rel="stylesheet">
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/config.js') }}"></script>
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/util.js') }}"></script>
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/jquery.emojiarea.js') }}"></script>
<script src="{{ asset('assets/plugins/emoji-picker/lib/js/emoji-picker.js') }}"></script>

<script>
    $(function () {
        // Initializes and creates emoji set from sprite sheet
        window.emojiPicker = new EmojiPicker({
            emojiable_selector: '[data-emojiable=true]',
            assetsPath: '{{ asset("assets/plugins/emoji-picker/lib/img/") }}',
            popupButtonClasses: ''
        });
        window.emojiPicker.discover();
    });
</script>
@endsection