@extends('admin.layout.master')
@section('content')
@include('admin/site_socials/socials_js')

<div class="row justify-content-between rounded bg-light shado-sm p-2 my-2 mx-3">
  <div class="col-12 align-self-center p-1 px-2">
      <a class='text-decoration-none fw-bold ' href="/home">Home  </a> <span class="bi bi-caret-right"></span>
      <span class='text-decoration-none fw-bold' >Social Media</span>  
  </div>
</div> 
<main class="container-fluid px-0 scroll-y">
    <!-- body content  -->
    <div class="card card-invoice rounded border-0">
      <div class="card-body pt-0">
        <div class="row g-2 align-items-end bg-light px-2 pb-2 border mt-1 mx-0 no-print p-0" id="from_to_date_area">
          <div class="col-md-2 col-6 mt-1">
            <input type="text" class="filtertbl form-control form-control-sm" id="search_new" style="min-width:150px;" placeholder="{{trans('admin.search')}}">
          </div>
          @can('insert /'.Request::path())
            <div class="col-auto ms-md-auto">
            <button class="btn btn-success rounded-pill btn-sm px-3" onclick="add_category()">
              {{trans('admin.add_New')}}
            </button>
          </div>
          @endcan

        </div>

        <div class="row">
          <div class="col-lg-12">
            <div class="table-responsive">
              <table class="table w-100 table-sm table-hover mb-0 table-bordered data-table">
                <thead class="bg-light">
                    <tr>
                        <th>{{trans('admin.id')}}</th>
                        <th>{{trans('admin.icon')}}</th>
                        <th>{{trans('admin.link')}}</th>
                        <th>{{trans('admin.status')}}</th>
                        <th>{{trans('admin.action')}}</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
              </table>
            </div>
        </div>
      </div>
    </div>
  </div>
</main>
<style>
    .dataTables_filter {
    display: none;
  }
</style>
<script type="text/javascript">
  var table ="";
  $(function () {
    table = $('.data-table').DataTable({
      processing: true,
      serverSide: true,
      ajax: "{{ route('socials') }}",
      columns: [
          {data: 'id', name: 'id'},
          {data: 'icon', name: 'icon'},
          {data: 'link', name: 'link'},
          {data: 'status', name: 'status'},
          {data: 'action', name: 'action', orderable: false, searchable: false},
      ],
      "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]]
    });
  });
  $("#search_new").on("keyup search input paste cut", function() {
     table.search(this.value).draw();
  });
</script>

{!! modelBox("addcategory", trans('admin.add'),"box","status_msg","add_category") !!}
{!! modelBox("editcategory", trans('admin.edit'),"box_edit","status_update","update_category") !!}
@endsection
