@extends('admin.layout.master')
@section('content')
<div class="conatiner">
    <div class="row justify-content-between rounded bg-light shado-sm p-2 my-2 mx-3">
        <div class="col-12 align-self-center p-1 px-2">
            <a class='text-decoration-none fw-bold ' href="{{url('/home')}}">{{trans('admin.Home')}}  </a> <span class="bi bi-caret-right"></span>
            <span class='text-decoration-none fw-bold' >{{trans('admin.site_info')}}</span>  
        </div>
      </div> 
    <div class='row p-4 bg-light m-2 mx-3 round '>
    	<div class="col-12">
            @if(session()->has('success'))
                <div class="bg-success p-2 mt-4 rounded text-white">
                    <span class="input-error">{{ session()->get('success') }}</span>
                </div>
            @elseif(session()->has('error'))
                <div class="bg-danger p-2 mt-4 rounded text-white">
                    <span class="input-error">{{ session()->get('error') }}</span>
                </div>
            @endif
            <!-- @if ($errors->any())
                <div class="bg-danger p-2 mt-4 rounded text-white">
                    @foreach ($errors->all() as $message)
                        <span class="input-error">{{ $message }}</span><br>
                    @endforeach
                </div>
            @endif -->
        </div>
        <div class="col-sm-3 text-center">
            <form action="{{url('site_info/update')}}" method="post" enctype="multipart/form-data">
            	@csrf
            	<input type="hidden" name="id" id="id" value="{{$info->id}}">
                <div class="  mt-1  mb-1 ">
                    <div class="container mt-lg-2 pt-3 ">
                        <label class="upload-btn-wrapper bg-light_c" for="photo"> <span class=" p-1 text-start"><i class="bi bi-camera pe-1"></i>{{ trans('admin.click_here') }}</span>
                            <img src="{{ asset('project/logo/'.$info->photo) }}" class="img-fluid" alt="" id="output">
                        </label>
                        <input type="file" name="photo" id="photo" class="d-none  bg-light_c" onchange="document.getElementById('output').src = window.URL.createObjectURL(this.files[0])" />
                    </div>
                </div>
                <span class='text-center '>{{ trans('admin.upload_logo') }}</span> <br>
                <div class="mt-lg-5 ">
                    <div class="container mt-lg-2 pt-3 ">
                        <label class="upload-btn-wrapper bg-light_c" for="favicon"> <span class=" p-1 text-start"><i class="bi bi-camera pe-1"></i>{{ trans('admin.click_here') }}</span>
                            <img src="{{ asset('project/logo/'.$info->favicon) }}" class="img-fluid" alt="" id="output2">
                        </label>
                        <input type="file" name="favicon" id="favicon" class="d-none  bg-light_c" onchange="document.getElementById('output2').src = window.URL.createObjectURL(this.files[0])" />
                    </div>
                </div>
                <span class='text-center '>{{ trans('admin.upload_favicon') }}</span>
        </div>
        <div class="col-sm-8 text-dark margin-top">
                <div class="mb-3">
                    <label for="site_title" class="form-label">{{ trans('admin.enter_website_title') }}</label>
                    <input type="text" class="form-control @error('site_title') is-invalid @enderror" id="site_title" name="site_title" placeholder="Title" value="{{$info->site_title}}">
                    @error('site_title')
                        <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>
                <div class="mb-3">
                    <label for="site_description_en" class="form-label">{{ trans('admin.enter_description_english') }}</label>
                    <textarea class="form-control @error('site_description_en') is-invalid @enderror" id="site_description_en" name="site_description_en" rows="3">{{$info->site_description_en}}</textarea>
                    @error('site_description_en')
                        <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>
                <div class="mb-3">
                    <label for="site_descrition_ar" class="form-label">{{ trans('admin.enter_description_arabic') }}</label>
                    <textarea class="form-control @error('site_descrition_ar') is-invalid @enderror" id="site_descrition_ar" name="site_descrition_ar" rows="3">{{$info->site_descrition_ar}}</textarea>
                    @error('site_descrition_ar')
                        <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>
                <div class="mb-3">
                    <label for="site_keyword_en" class="form-label">{{ trans('admin.keywords_english') }}</label>
                    <textarea class="form-control @error('site_keyword_en') is-invalid @enderror" id="site_keyword_en" name="site_keyword_en" rows="3">{{$info->site_keyword_en}}</textarea>
                    @error('site_keyword_en')
                        <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>
                <div class="mb-3">
                    <label for="site_keyword_ar" class="form-label">{{ trans('admin.keywords_arabic') }}</label>
                    <textarea class="form-control @error('site_keyword_ar') is-invalid @enderror" id="site_keyword_ar" name="site_keyword_ar" rows="3">{{$info->site_keyword_ar}}</textarea>
                    @error('site_keyword_ar')
                        <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>
      
                <div class='d-grid col-sm-6 my-4'>
                    <button type="submit" class="btn btn-success btn-block bt btn-sm">{{ trans('admin.save') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
<style>
    .form-control {
        font-size: 12px !important;
        color: #9A9A9A;
    }
</style>
@endsection
